<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Referee_Phone_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The referee's phone information.
 * @subpackage Structs
 */
class Referee_Phone_DataType extends AbstractStructBase
{
    /**
     * The Phone_Device_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The referee's phone device type.
     * - minOccurs: 0
     * @var \StructType\Phone_Device_TypeObjectType
     */
    public $Phone_Device_Type_Reference;
    /**
     * The Country_Phone_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: The referee's country phone code.
     * - minOccurs: 0
     * @var \StructType\Country_Phone_CodeObjectType
     */
    public $Country_Phone_Code_Reference;
    /**
     * The Phone_Number
     * Meta information extracted from the WSDL
     * - documentation: The referee's phone number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone_Number;
    /**
     * The Phone_Extension
     * Meta information extracted from the WSDL
     * - documentation: The referee's phone number extension.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone_Extension;
    /**
     * Constructor method for Referee_Phone_DataType
     * @uses Referee_Phone_DataType::setPhone_Device_Type_Reference()
     * @uses Referee_Phone_DataType::setCountry_Phone_Code_Reference()
     * @uses Referee_Phone_DataType::setPhone_Number()
     * @uses Referee_Phone_DataType::setPhone_Extension()
     * @param \StructType\Phone_Device_TypeObjectType $phone_Device_Type_Reference
     * @param \StructType\Country_Phone_CodeObjectType $country_Phone_Code_Reference
     * @param string $phone_Number
     * @param string $phone_Extension
     */
    public function __construct(\StructType\Phone_Device_TypeObjectType $phone_Device_Type_Reference = null, \StructType\Country_Phone_CodeObjectType $country_Phone_Code_Reference = null, $phone_Number = null, $phone_Extension = null)
    {
        $this
            ->setPhone_Device_Type_Reference($phone_Device_Type_Reference)
            ->setCountry_Phone_Code_Reference($country_Phone_Code_Reference)
            ->setPhone_Number($phone_Number)
            ->setPhone_Extension($phone_Extension);
    }
    /**
     * Get Phone_Device_Type_Reference value
     * @return \StructType\Phone_Device_TypeObjectType|null
     */
    public function getPhone_Device_Type_Reference()
    {
        return $this->Phone_Device_Type_Reference;
    }
    /**
     * Set Phone_Device_Type_Reference value
     * @param \StructType\Phone_Device_TypeObjectType $phone_Device_Type_Reference
     * @return \StructType\Referee_Phone_DataType
     */
    public function setPhone_Device_Type_Reference(\StructType\Phone_Device_TypeObjectType $phone_Device_Type_Reference = null)
    {
        $this->Phone_Device_Type_Reference = $phone_Device_Type_Reference;
        return $this;
    }
    /**
     * Get Country_Phone_Code_Reference value
     * @return \StructType\Country_Phone_CodeObjectType|null
     */
    public function getCountry_Phone_Code_Reference()
    {
        return $this->Country_Phone_Code_Reference;
    }
    /**
     * Set Country_Phone_Code_Reference value
     * @param \StructType\Country_Phone_CodeObjectType $country_Phone_Code_Reference
     * @return \StructType\Referee_Phone_DataType
     */
    public function setCountry_Phone_Code_Reference(\StructType\Country_Phone_CodeObjectType $country_Phone_Code_Reference = null)
    {
        $this->Country_Phone_Code_Reference = $country_Phone_Code_Reference;
        return $this;
    }
    /**
     * Get Phone_Number value
     * @return string|null
     */
    public function getPhone_Number()
    {
        return $this->Phone_Number;
    }
    /**
     * Set Phone_Number value
     * @param string $phone_Number
     * @return \StructType\Referee_Phone_DataType
     */
    public function setPhone_Number($phone_Number = null)
    {
        // validation for constraint: string
        if (!is_null($phone_Number) && !is_string($phone_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_Number, true), gettype($phone_Number)), __LINE__);
        }
        $this->Phone_Number = $phone_Number;
        return $this;
    }
    /**
     * Get Phone_Extension value
     * @return string|null
     */
    public function getPhone_Extension()
    {
        return $this->Phone_Extension;
    }
    /**
     * Set Phone_Extension value
     * @param string $phone_Extension
     * @return \StructType\Referee_Phone_DataType
     */
    public function setPhone_Extension($phone_Extension = null)
    {
        // validation for constraint: string
        if (!is_null($phone_Extension) && !is_string($phone_Extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_Extension, true), gettype($phone_Extension)), __LINE__);
        }
        $this->Phone_Extension = $phone_Extension;
        return $this;
    }
}
