<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Referee_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about the referee.
 * @subpackage Structs
 */
class Referee_Details_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The referee's reference ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Legal_Name_Data
     * @var \StructType\Legal_Name_DataType
     */
    public $Legal_Name_Data;
    /**
     * The Email_Address
     * Meta information extracted from the WSDL
     * - documentation: The referee's email address.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email_Address;
    /**
     * The Referee_Phone_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Referee_Phone_DataType
     */
    public $Referee_Phone_Data;
    /**
     * The Job_Title
     * Meta information extracted from the WSDL
     * - documentation: The referee's current job title.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Title;
    /**
     * The Company_Name
     * Meta information extracted from the WSDL
     * - documentation: The referee's current company name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Company_Name;
    /**
     * The Relationship_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The referee's relationship with the candidate.
     * - minOccurs: 0
     * @var \StructType\Referee_Relationship_TypeObjectType
     */
    public $Relationship_Type_Reference;
    /**
     * The Contact_Candidate
     * Meta information extracted from the WSDL
     * - documentation: The option to contact the candidate before reaching out to their referee. Possible value is Yes or No.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Contact_Candidate;
    /**
     * Constructor method for Referee_Details_DataType
     * @uses Referee_Details_DataType::setID()
     * @uses Referee_Details_DataType::setLegal_Name_Data()
     * @uses Referee_Details_DataType::setEmail_Address()
     * @uses Referee_Details_DataType::setReferee_Phone_Data()
     * @uses Referee_Details_DataType::setJob_Title()
     * @uses Referee_Details_DataType::setCompany_Name()
     * @uses Referee_Details_DataType::setRelationship_Type_Reference()
     * @uses Referee_Details_DataType::setContact_Candidate()
     * @param string $iD
     * @param \StructType\Legal_Name_DataType $legal_Name_Data
     * @param string $email_Address
     * @param \StructType\Referee_Phone_DataType $referee_Phone_Data
     * @param string $job_Title
     * @param string $company_Name
     * @param \StructType\Referee_Relationship_TypeObjectType $relationship_Type_Reference
     * @param bool $contact_Candidate
     */
    public function __construct($iD = null, \StructType\Legal_Name_DataType $legal_Name_Data = null, $email_Address = null, \StructType\Referee_Phone_DataType $referee_Phone_Data = null, $job_Title = null, $company_Name = null, \StructType\Referee_Relationship_TypeObjectType $relationship_Type_Reference = null, $contact_Candidate = null)
    {
        $this
            ->setID($iD)
            ->setLegal_Name_Data($legal_Name_Data)
            ->setEmail_Address($email_Address)
            ->setReferee_Phone_Data($referee_Phone_Data)
            ->setJob_Title($job_Title)
            ->setCompany_Name($company_Name)
            ->setRelationship_Type_Reference($relationship_Type_Reference)
            ->setContact_Candidate($contact_Candidate);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Referee_Details_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Legal_Name_Data value
     * @return \StructType\Legal_Name_DataType|null
     */
    public function getLegal_Name_Data()
    {
        return $this->Legal_Name_Data;
    }
    /**
     * Set Legal_Name_Data value
     * @param \StructType\Legal_Name_DataType $legal_Name_Data
     * @return \StructType\Referee_Details_DataType
     */
    public function setLegal_Name_Data(\StructType\Legal_Name_DataType $legal_Name_Data = null)
    {
        $this->Legal_Name_Data = $legal_Name_Data;
        return $this;
    }
    /**
     * Get Email_Address value
     * @return string|null
     */
    public function getEmail_Address()
    {
        return $this->Email_Address;
    }
    /**
     * Set Email_Address value
     * @param string $email_Address
     * @return \StructType\Referee_Details_DataType
     */
    public function setEmail_Address($email_Address = null)
    {
        // validation for constraint: string
        if (!is_null($email_Address) && !is_string($email_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_Address, true), gettype($email_Address)), __LINE__);
        }
        $this->Email_Address = $email_Address;
        return $this;
    }
    /**
     * Get Referee_Phone_Data value
     * @return \StructType\Referee_Phone_DataType|null
     */
    public function getReferee_Phone_Data()
    {
        return $this->Referee_Phone_Data;
    }
    /**
     * Set Referee_Phone_Data value
     * @param \StructType\Referee_Phone_DataType $referee_Phone_Data
     * @return \StructType\Referee_Details_DataType
     */
    public function setReferee_Phone_Data(\StructType\Referee_Phone_DataType $referee_Phone_Data = null)
    {
        $this->Referee_Phone_Data = $referee_Phone_Data;
        return $this;
    }
    /**
     * Get Job_Title value
     * @return string|null
     */
    public function getJob_Title()
    {
        return $this->Job_Title;
    }
    /**
     * Set Job_Title value
     * @param string $job_Title
     * @return \StructType\Referee_Details_DataType
     */
    public function setJob_Title($job_Title = null)
    {
        // validation for constraint: string
        if (!is_null($job_Title) && !is_string($job_Title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Title, true), gettype($job_Title)), __LINE__);
        }
        $this->Job_Title = $job_Title;
        return $this;
    }
    /**
     * Get Company_Name value
     * @return string|null
     */
    public function getCompany_Name()
    {
        return $this->Company_Name;
    }
    /**
     * Set Company_Name value
     * @param string $company_Name
     * @return \StructType\Referee_Details_DataType
     */
    public function setCompany_Name($company_Name = null)
    {
        // validation for constraint: string
        if (!is_null($company_Name) && !is_string($company_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company_Name, true), gettype($company_Name)), __LINE__);
        }
        $this->Company_Name = $company_Name;
        return $this;
    }
    /**
     * Get Relationship_Type_Reference value
     * @return \StructType\Referee_Relationship_TypeObjectType|null
     */
    public function getRelationship_Type_Reference()
    {
        return $this->Relationship_Type_Reference;
    }
    /**
     * Set Relationship_Type_Reference value
     * @param \StructType\Referee_Relationship_TypeObjectType $relationship_Type_Reference
     * @return \StructType\Referee_Details_DataType
     */
    public function setRelationship_Type_Reference(\StructType\Referee_Relationship_TypeObjectType $relationship_Type_Reference = null)
    {
        $this->Relationship_Type_Reference = $relationship_Type_Reference;
        return $this;
    }
    /**
     * Get Contact_Candidate value
     * @return bool|null
     */
    public function getContact_Candidate()
    {
        return $this->Contact_Candidate;
    }
    /**
     * Set Contact_Candidate value
     * @param bool $contact_Candidate
     * @return \StructType\Referee_Details_DataType
     */
    public function setContact_Candidate($contact_Candidate = null)
    {
        // validation for constraint: boolean
        if (!is_null($contact_Candidate) && !is_bool($contact_Candidate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contact_Candidate, true), gettype($contact_Candidate)), __LINE__);
        }
        $this->Contact_Candidate = $contact_Candidate;
        return $this;
    }
}
