<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Self-Service_Schedule_Time_Block_ContainerType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Section to add, update or delete Time Blocks for the Recruiting Calendar Schedule.
 * @subpackage Structs
 */
class Recruiting_Self_Service_Schedule_Time_Block_ContainerType extends AbstractStructBase
{
    /**
     * The Time_Block_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier used to reference a Recruiting Calendar Schedule Time Block.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Service_Time_Block_ContainerObjectType
     */
    public $Time_Block_Reference;
    /**
     * The Time_Block_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Service_Schedule_Time_Block_Container_DataType
     */
    public $Time_Block_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the request is only for adding a time block.
     * @var bool
     */
    public $Add_Only;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the request is only for deleting a time block.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Recruiting_Self-Service_Schedule_Time_Block_ContainerType
     * @uses Recruiting_Self_Service_Schedule_Time_Block_ContainerType::setTime_Block_Reference()
     * @uses Recruiting_Self_Service_Schedule_Time_Block_ContainerType::setTime_Block_Data()
     * @uses Recruiting_Self_Service_Schedule_Time_Block_ContainerType::setAdd_Only()
     * @uses Recruiting_Self_Service_Schedule_Time_Block_ContainerType::setDelete()
     * @param \StructType\Recruiting_Self_Service_Time_Block_ContainerObjectType $time_Block_Reference
     * @param \StructType\Recruiting_Self_Service_Schedule_Time_Block_Container_DataType $time_Block_Data
     * @param bool $add_Only
     * @param bool $delete
     */
    public function __construct(\StructType\Recruiting_Self_Service_Time_Block_ContainerObjectType $time_Block_Reference = null, \StructType\Recruiting_Self_Service_Schedule_Time_Block_Container_DataType $time_Block_Data = null, $add_Only = null, $delete = null)
    {
        $this
            ->setTime_Block_Reference($time_Block_Reference)
            ->setTime_Block_Data($time_Block_Data)
            ->setAdd_Only($add_Only)
            ->setDelete($delete);
    }
    /**
     * Get Time_Block_Reference value
     * @return \StructType\Recruiting_Self_Service_Time_Block_ContainerObjectType|null
     */
    public function getTime_Block_Reference()
    {
        return $this->Time_Block_Reference;
    }
    /**
     * Set Time_Block_Reference value
     * @param \StructType\Recruiting_Self_Service_Time_Block_ContainerObjectType $time_Block_Reference
     * @return \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType
     */
    public function setTime_Block_Reference(\StructType\Recruiting_Self_Service_Time_Block_ContainerObjectType $time_Block_Reference = null)
    {
        $this->Time_Block_Reference = $time_Block_Reference;
        return $this;
    }
    /**
     * Get Time_Block_Data value
     * @return \StructType\Recruiting_Self_Service_Schedule_Time_Block_Container_DataType|null
     */
    public function getTime_Block_Data()
    {
        return $this->Time_Block_Data;
    }
    /**
     * Set Time_Block_Data value
     * @param \StructType\Recruiting_Self_Service_Schedule_Time_Block_Container_DataType $time_Block_Data
     * @return \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType
     */
    public function setTime_Block_Data(\StructType\Recruiting_Self_Service_Schedule_Time_Block_Container_DataType $time_Block_Data = null)
    {
        $this->Time_Block_Data = $time_Block_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
