<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Instruction_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Job Requisition Recruiting Instructions or posting instructions.
 * @subpackage Structs
 */
class Recruiting_Instruction_DataType extends AbstractStructBase
{
    /**
     * The Recruiting_Instruction_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Recruiting Instruction for the Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Recruiting_InstructionObjectType
     */
    public $Recruiting_Instruction_Reference;
    /**
     * The Do_Not_Send_To_Recruiting_System
     * Meta information extracted from the WSDL
     * - documentation: Indicates the Job Requisition will be sent to an external recruiting system.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Do_Not_Send_To_Recruiting_System;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The Name of the Recruiting Instruction
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Recruiting_Instruction_DataType
     * @uses Recruiting_Instruction_DataType::setRecruiting_Instruction_Reference()
     * @uses Recruiting_Instruction_DataType::setDo_Not_Send_To_Recruiting_System()
     * @uses Recruiting_Instruction_DataType::setName()
     * @param \StructType\Recruiting_InstructionObjectType $recruiting_Instruction_Reference
     * @param bool $do_Not_Send_To_Recruiting_System
     * @param string $name
     */
    public function __construct(\StructType\Recruiting_InstructionObjectType $recruiting_Instruction_Reference = null, $do_Not_Send_To_Recruiting_System = null, $name = null)
    {
        $this
            ->setRecruiting_Instruction_Reference($recruiting_Instruction_Reference)
            ->setDo_Not_Send_To_Recruiting_System($do_Not_Send_To_Recruiting_System)
            ->setName($name);
    }
    /**
     * Get Recruiting_Instruction_Reference value
     * @return \StructType\Recruiting_InstructionObjectType|null
     */
    public function getRecruiting_Instruction_Reference()
    {
        return $this->Recruiting_Instruction_Reference;
    }
    /**
     * Set Recruiting_Instruction_Reference value
     * @param \StructType\Recruiting_InstructionObjectType $recruiting_Instruction_Reference
     * @return \StructType\Recruiting_Instruction_DataType
     */
    public function setRecruiting_Instruction_Reference(\StructType\Recruiting_InstructionObjectType $recruiting_Instruction_Reference = null)
    {
        $this->Recruiting_Instruction_Reference = $recruiting_Instruction_Reference;
        return $this;
    }
    /**
     * Get Do_Not_Send_To_Recruiting_System value
     * @return bool|null
     */
    public function getDo_Not_Send_To_Recruiting_System()
    {
        return $this->Do_Not_Send_To_Recruiting_System;
    }
    /**
     * Set Do_Not_Send_To_Recruiting_System value
     * @param bool $do_Not_Send_To_Recruiting_System
     * @return \StructType\Recruiting_Instruction_DataType
     */
    public function setDo_Not_Send_To_Recruiting_System($do_Not_Send_To_Recruiting_System = null)
    {
        // validation for constraint: boolean
        if (!is_null($do_Not_Send_To_Recruiting_System) && !is_bool($do_Not_Send_To_Recruiting_System)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($do_Not_Send_To_Recruiting_System, true), gettype($do_Not_Send_To_Recruiting_System)), __LINE__);
        }
        $this->Do_Not_Send_To_Recruiting_System = $do_Not_Send_To_Recruiting_System;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Recruiting_Instruction_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
