<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Assessment_Category_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for Assessment Category Data
 * @subpackage Structs
 */
class Recruiting_Assessment_Category_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * @var string
     */
    public $ID;
    /**
     * The Assessment_Category_Name
     * Meta information extracted from the WSDL
     * - documentation: Assessment Category Name
     * - maxOccurs: 1
     * @var string
     */
    public $Assessment_Category_Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Assessment Category Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Recruiting_Assessment_Category_DataType
     * @uses Recruiting_Assessment_Category_DataType::setID()
     * @uses Recruiting_Assessment_Category_DataType::setAssessment_Category_Name()
     * @uses Recruiting_Assessment_Category_DataType::setDescription()
     * @uses Recruiting_Assessment_Category_DataType::setInactive()
     * @param string $iD
     * @param string $assessment_Category_Name
     * @param string $description
     * @param bool $inactive
     */
    public function __construct($iD = null, $assessment_Category_Name = null, $description = null, $inactive = null)
    {
        $this
            ->setID($iD)
            ->setAssessment_Category_Name($assessment_Category_Name)
            ->setDescription($description)
            ->setInactive($inactive);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Recruiting_Assessment_Category_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Assessment_Category_Name value
     * @return string|null
     */
    public function getAssessment_Category_Name()
    {
        return $this->Assessment_Category_Name;
    }
    /**
     * Set Assessment_Category_Name value
     * @param string $assessment_Category_Name
     * @return \StructType\Recruiting_Assessment_Category_DataType
     */
    public function setAssessment_Category_Name($assessment_Category_Name = null)
    {
        // validation for constraint: string
        if (!is_null($assessment_Category_Name) && !is_string($assessment_Category_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assessment_Category_Name, true), gettype($assessment_Category_Name)), __LINE__);
        }
        $this->Assessment_Category_Name = $assessment_Category_Name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Recruiting_Assessment_Category_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Recruiting_Assessment_Category_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
