<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Questions_for_Questionnaire_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The questions on the questionnaire.
 * @subpackage Structs
 */
class Questions_for_Questionnaire_DataType extends AbstractStructBase
{
    /**
     * The Question_Setup_Reference
     * Meta information extracted from the WSDL
     * - documentation: A question on the questionnaire.
     * @var \StructType\Question_SetupObjectType
     */
    public $Question_Setup_Reference;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: The order of a question.
     * - maxOccurs: 1
     * @var string
     */
    public $Order;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: Boolean determining if this question is required.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required;
    /**
     * The Score_for_Question_Multiple_Choice_Answers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType[]
     */
    public $Score_for_Question_Multiple_Choice_Answers;
    /**
     * Constructor method for Questions_for_Questionnaire_DataType
     * @uses Questions_for_Questionnaire_DataType::setQuestion_Setup_Reference()
     * @uses Questions_for_Questionnaire_DataType::setOrder()
     * @uses Questions_for_Questionnaire_DataType::setRequired()
     * @uses Questions_for_Questionnaire_DataType::setScore_for_Question_Multiple_Choice_Answers()
     * @param \StructType\Question_SetupObjectType $question_Setup_Reference
     * @param string $order
     * @param bool $required
     * @param \StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType[] $score_for_Question_Multiple_Choice_Answers
     */
    public function __construct(\StructType\Question_SetupObjectType $question_Setup_Reference = null, $order = null, $required = null, array $score_for_Question_Multiple_Choice_Answers = array())
    {
        $this
            ->setQuestion_Setup_Reference($question_Setup_Reference)
            ->setOrder($order)
            ->setRequired($required)
            ->setScore_for_Question_Multiple_Choice_Answers($score_for_Question_Multiple_Choice_Answers);
    }
    /**
     * Get Question_Setup_Reference value
     * @return \StructType\Question_SetupObjectType|null
     */
    public function getQuestion_Setup_Reference()
    {
        return $this->Question_Setup_Reference;
    }
    /**
     * Set Question_Setup_Reference value
     * @param \StructType\Question_SetupObjectType $question_Setup_Reference
     * @return \StructType\Questions_for_Questionnaire_DataType
     */
    public function setQuestion_Setup_Reference(\StructType\Question_SetupObjectType $question_Setup_Reference = null)
    {
        $this->Question_Setup_Reference = $question_Setup_Reference;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Questions_for_Questionnaire_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \StructType\Questions_for_Questionnaire_DataType
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get Score_for_Question_Multiple_Choice_Answers value
     * @return \StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType[]|null
     */
    public function getScore_for_Question_Multiple_Choice_Answers()
    {
        return $this->Score_for_Question_Multiple_Choice_Answers;
    }
    /**
     * This method is responsible for validating the values passed to the setScore_for_Question_Multiple_Choice_Answers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setScore_for_Question_Multiple_Choice_Answers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateScore_for_Question_Multiple_Choice_AnswersForArrayConstraintsFromSetScore_for_Question_Multiple_Choice_Answers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $questions_for_Questionnaire_DataTypeScore_for_Question_Multiple_Choice_AnswersItem) {
            // validation for constraint: itemType
            if (!$questions_for_Questionnaire_DataTypeScore_for_Question_Multiple_Choice_AnswersItem instanceof \StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType) {
                $invalidValues[] = is_object($questions_for_Questionnaire_DataTypeScore_for_Question_Multiple_Choice_AnswersItem) ? get_class($questions_for_Questionnaire_DataTypeScore_for_Question_Multiple_Choice_AnswersItem) : sprintf('%s(%s)', gettype($questions_for_Questionnaire_DataTypeScore_for_Question_Multiple_Choice_AnswersItem), var_export($questions_for_Questionnaire_DataTypeScore_for_Question_Multiple_Choice_AnswersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Score_for_Question_Multiple_Choice_Answers property can only contain items of type \StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Score_for_Question_Multiple_Choice_Answers value
     * @throws \InvalidArgumentException
     * @param \StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType[] $score_for_Question_Multiple_Choice_Answers
     * @return \StructType\Questions_for_Questionnaire_DataType
     */
    public function setScore_for_Question_Multiple_Choice_Answers(array $score_for_Question_Multiple_Choice_Answers = array())
    {
        // validation for constraint: array
        if ('' !== ($score_for_Question_Multiple_Choice_AnswersArrayErrorMessage = self::validateScore_for_Question_Multiple_Choice_AnswersForArrayConstraintsFromSetScore_for_Question_Multiple_Choice_Answers($score_for_Question_Multiple_Choice_Answers))) {
            throw new \InvalidArgumentException($score_for_Question_Multiple_Choice_AnswersArrayErrorMessage, __LINE__);
        }
        $this->Score_for_Question_Multiple_Choice_Answers = $score_for_Question_Multiple_Choice_Answers;
        return $this;
    }
    /**
     * Add item to Score_for_Question_Multiple_Choice_Answers value
     * @throws \InvalidArgumentException
     * @param \StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType $item
     * @return \StructType\Questions_for_Questionnaire_DataType
     */
    public function addToScore_for_Question_Multiple_Choice_Answers(\StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType) {
            throw new \InvalidArgumentException(sprintf('The Score_for_Question_Multiple_Choice_Answers property can only contain items of type \StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Score_for_Question_Multiple_Choice_Answers[] = $item;
        return $this;
    }
}
