<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Site_Brand_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Put Brand Response.
 * @subpackage Structs
 */
class Put_Site_Brand_ResponseType extends AbstractStructBase
{
    /**
     * The Brand_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing a unique instance of a brand.
     * - minOccurs: 0
     * @var \StructType\BrandObjectType
     */
    public $Brand_Reference;
    /**
     * The Brand_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Brand_DataType[]
     */
    public $Brand_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Site_Brand_ResponseType
     * @uses Put_Site_Brand_ResponseType::setBrand_Reference()
     * @uses Put_Site_Brand_ResponseType::setBrand_Data()
     * @uses Put_Site_Brand_ResponseType::setVersion()
     * @param \StructType\BrandObjectType $brand_Reference
     * @param \StructType\Brand_DataType[] $brand_Data
     * @param string $version
     */
    public function __construct(\StructType\BrandObjectType $brand_Reference = null, array $brand_Data = array(), $version = null)
    {
        $this
            ->setBrand_Reference($brand_Reference)
            ->setBrand_Data($brand_Data)
            ->setVersion($version);
    }
    /**
     * Get Brand_Reference value
     * @return \StructType\BrandObjectType|null
     */
    public function getBrand_Reference()
    {
        return $this->Brand_Reference;
    }
    /**
     * Set Brand_Reference value
     * @param \StructType\BrandObjectType $brand_Reference
     * @return \StructType\Put_Site_Brand_ResponseType
     */
    public function setBrand_Reference(\StructType\BrandObjectType $brand_Reference = null)
    {
        $this->Brand_Reference = $brand_Reference;
        return $this;
    }
    /**
     * Get Brand_Data value
     * @return \StructType\Brand_DataType[]|null
     */
    public function getBrand_Data()
    {
        return $this->Brand_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBrand_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBrand_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBrand_DataForArrayConstraintsFromSetBrand_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Site_Brand_ResponseTypeBrand_DataItem) {
            // validation for constraint: itemType
            if (!$put_Site_Brand_ResponseTypeBrand_DataItem instanceof \StructType\Brand_DataType) {
                $invalidValues[] = is_object($put_Site_Brand_ResponseTypeBrand_DataItem) ? get_class($put_Site_Brand_ResponseTypeBrand_DataItem) : sprintf('%s(%s)', gettype($put_Site_Brand_ResponseTypeBrand_DataItem), var_export($put_Site_Brand_ResponseTypeBrand_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Brand_Data property can only contain items of type \StructType\Brand_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Brand_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Brand_DataType[] $brand_Data
     * @return \StructType\Put_Site_Brand_ResponseType
     */
    public function setBrand_Data(array $brand_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($brand_DataArrayErrorMessage = self::validateBrand_DataForArrayConstraintsFromSetBrand_Data($brand_Data))) {
            throw new \InvalidArgumentException($brand_DataArrayErrorMessage, __LINE__);
        }
        $this->Brand_Data = $brand_Data;
        return $this;
    }
    /**
     * Add item to Brand_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Brand_DataType $item
     * @return \StructType\Put_Site_Brand_ResponseType
     */
    public function addToBrand_Data(\StructType\Brand_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Brand_DataType) {
            throw new \InvalidArgumentException(sprintf('The Brand_Data property can only contain items of type \StructType\Brand_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Brand_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Site_Brand_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
