<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Put_Recruiting_Assessment_Category_Security_Segment_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the request to add, update or delete a Recruiting Assessment Category Security Segment.
 * @subpackage Structs
 */
class Put_Recruiting_Assessment_Category_Security_Segment_RequestType extends AbstractStructBase
{
    /**
     * The Recruiting_Assessment_Category_Security_Segment_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier used to reference a Recruiting Assessment Category Security Segment.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_Category_Security_SegmentObjectType
     */
    public $Recruiting_Assessment_Category_Security_Segment_Reference;
    /**
     * The Recruiting_Assessment_Category_Security_Segment_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing data for the Recruiting Assessment Category Security Segment.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_Category_Security_Segment_DataType
     */
    public $Recruiting_Assessment_Category_Security_Segment_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the request is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If true, indicates a delete operation.
     * @var bool
     */
    public $Delete;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for
     * Put_Recruiting_Assessment_Category_Security_Segment_RequestType
     * @uses Put_Recruiting_Assessment_Category_Security_Segment_RequestType::setRecruiting_Assessment_Category_Security_Segment_Reference()
     * @uses Put_Recruiting_Assessment_Category_Security_Segment_RequestType::setRecruiting_Assessment_Category_Security_Segment_Data()
     * @uses Put_Recruiting_Assessment_Category_Security_Segment_RequestType::setAdd_Only()
     * @uses Put_Recruiting_Assessment_Category_Security_Segment_RequestType::setDelete()
     * @uses Put_Recruiting_Assessment_Category_Security_Segment_RequestType::setVersion()
     * @param \StructType\Recruiting_Assessment_Category_Security_SegmentObjectType $recruiting_Assessment_Category_Security_Segment_Reference
     * @param \StructType\Recruiting_Assessment_Category_Security_Segment_DataType $recruiting_Assessment_Category_Security_Segment_Data
     * @param bool $add_Only
     * @param bool $delete
     * @param string $version
     */
    public function __construct(\StructType\Recruiting_Assessment_Category_Security_SegmentObjectType $recruiting_Assessment_Category_Security_Segment_Reference = null, \StructType\Recruiting_Assessment_Category_Security_Segment_DataType $recruiting_Assessment_Category_Security_Segment_Data = null, $add_Only = null, $delete = null, $version = null)
    {
        $this
            ->setRecruiting_Assessment_Category_Security_Segment_Reference($recruiting_Assessment_Category_Security_Segment_Reference)
            ->setRecruiting_Assessment_Category_Security_Segment_Data($recruiting_Assessment_Category_Security_Segment_Data)
            ->setAdd_Only($add_Only)
            ->setDelete($delete)
            ->setVersion($version);
    }
    /**
     * Get Recruiting_Assessment_Category_Security_Segment_Reference value
     * @return \StructType\Recruiting_Assessment_Category_Security_SegmentObjectType|null
     */
    public function getRecruiting_Assessment_Category_Security_Segment_Reference()
    {
        return $this->Recruiting_Assessment_Category_Security_Segment_Reference;
    }
    /**
     * Set Recruiting_Assessment_Category_Security_Segment_Reference value
     * @param \StructType\Recruiting_Assessment_Category_Security_SegmentObjectType $recruiting_Assessment_Category_Security_Segment_Reference
     * @return \StructType\Put_Recruiting_Assessment_Category_Security_Segment_RequestType
     */
    public function setRecruiting_Assessment_Category_Security_Segment_Reference(\StructType\Recruiting_Assessment_Category_Security_SegmentObjectType $recruiting_Assessment_Category_Security_Segment_Reference = null)
    {
        $this->Recruiting_Assessment_Category_Security_Segment_Reference = $recruiting_Assessment_Category_Security_Segment_Reference;
        return $this;
    }
    /**
     * Get Recruiting_Assessment_Category_Security_Segment_Data value
     * @return \StructType\Recruiting_Assessment_Category_Security_Segment_DataType|null
     */
    public function getRecruiting_Assessment_Category_Security_Segment_Data()
    {
        return $this->Recruiting_Assessment_Category_Security_Segment_Data;
    }
    /**
     * Set Recruiting_Assessment_Category_Security_Segment_Data value
     * @param \StructType\Recruiting_Assessment_Category_Security_Segment_DataType $recruiting_Assessment_Category_Security_Segment_Data
     * @return \StructType\Put_Recruiting_Assessment_Category_Security_Segment_RequestType
     */
    public function setRecruiting_Assessment_Category_Security_Segment_Data(\StructType\Recruiting_Assessment_Category_Security_Segment_DataType $recruiting_Assessment_Category_Security_Segment_Data = null)
    {
        $this->Recruiting_Assessment_Category_Security_Segment_Data = $recruiting_Assessment_Category_Security_Segment_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Recruiting_Assessment_Category_Security_Segment_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Put_Recruiting_Assessment_Category_Security_Segment_RequestType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Recruiting_Assessment_Category_Security_Segment_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
