<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Job_Posting_Site_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: After a PUT operation this element will be the response. It holds the updated Job Posting Site.
 * @subpackage Structs
 */
class Put_Job_Posting_Site_ResponseType extends AbstractStructBase
{
    /**
     * The Job_Posting_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: New or Updated Job Posting Site, which was updated in the PUT operation.
     * - minOccurs: 0
     * @var \StructType\Job_Posting_SiteObjectType
     */
    public $Job_Posting_Site_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Job_Posting_Site_ResponseType
     * @uses Put_Job_Posting_Site_ResponseType::setJob_Posting_Site_Reference()
     * @uses Put_Job_Posting_Site_ResponseType::setVersion()
     * @param \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @param string $version
     */
    public function __construct(\StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference = null, $version = null)
    {
        $this
            ->setJob_Posting_Site_Reference($job_Posting_Site_Reference)
            ->setVersion($version);
    }
    /**
     * Get Job_Posting_Site_Reference value
     * @return \StructType\Job_Posting_SiteObjectType|null
     */
    public function getJob_Posting_Site_Reference()
    {
        return $this->Job_Posting_Site_Reference;
    }
    /**
     * Set Job_Posting_Site_Reference value
     * @param \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @return \StructType\Put_Job_Posting_Site_ResponseType
     */
    public function setJob_Posting_Site_Reference(\StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference = null)
    {
        $this->Job_Posting_Site_Reference = $job_Posting_Site_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Job_Posting_Site_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
