<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Interview_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: A request to schedule an interview.
 * @subpackage Structs
 */
class Put_Interview_RequestType extends AbstractStructBase
{
    /**
     * The Interview_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains one of the following: Interview Event Reference, Job Application Reference, or the Candidate Interview Criteria Data.
     * @var \StructType\Interview_DataType
     */
    public $Interview_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Interview_RequestType
     * @uses Put_Interview_RequestType::setInterview_Data()
     * @uses Put_Interview_RequestType::setVersion()
     * @param \StructType\Interview_DataType $interview_Data
     * @param string $version
     */
    public function __construct(\StructType\Interview_DataType $interview_Data = null, $version = null)
    {
        $this
            ->setInterview_Data($interview_Data)
            ->setVersion($version);
    }
    /**
     * Get Interview_Data value
     * @return \StructType\Interview_DataType|null
     */
    public function getInterview_Data()
    {
        return $this->Interview_Data;
    }
    /**
     * Set Interview_Data value
     * @param \StructType\Interview_DataType $interview_Data
     * @return \StructType\Put_Interview_RequestType
     */
    public function setInterview_Data(\StructType\Interview_DataType $interview_Data = null)
    {
        $this->Interview_Data = $interview_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Interview_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
