<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Candidate_Attachment_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information about about the Candidate and/or Job Application the attachment was added to.
 * @subpackage Structs
 */
class Put_Candidate_Attachment_ResponseType extends AbstractStructBase
{
    /**
     * The Candidate_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Candidate.
     * - minOccurs: 0
     * @var \StructType\CandidateObjectType
     */
    public $Candidate_Reference;
    /**
     * The Attachment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Candidate Attachment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_AttachmentObjectType[]
     */
    public $Attachment_Reference;
    /**
     * The Job_Application_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Application_Attachment_ResponseType[]
     */
    public $Job_Application_Attachment_Data;
    /**
     * The Prospect_Resume_Attachment_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Prospect_Attachments_DataType
     */
    public $Prospect_Resume_Attachment_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Candidate_Attachment_ResponseType
     * @uses Put_Candidate_Attachment_ResponseType::setCandidate_Reference()
     * @uses Put_Candidate_Attachment_ResponseType::setAttachment_Reference()
     * @uses Put_Candidate_Attachment_ResponseType::setJob_Application_Attachment_Data()
     * @uses Put_Candidate_Attachment_ResponseType::setProspect_Resume_Attachment_Data()
     * @uses Put_Candidate_Attachment_ResponseType::setVersion()
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @param \StructType\Candidate_AttachmentObjectType[] $attachment_Reference
     * @param \StructType\Job_Application_Attachment_ResponseType[] $job_Application_Attachment_Data
     * @param \StructType\Prospect_Attachments_DataType $prospect_Resume_Attachment_Data
     * @param string $version
     */
    public function __construct(\StructType\CandidateObjectType $candidate_Reference = null, array $attachment_Reference = array(), array $job_Application_Attachment_Data = array(), \StructType\Prospect_Attachments_DataType $prospect_Resume_Attachment_Data = null, $version = null)
    {
        $this
            ->setCandidate_Reference($candidate_Reference)
            ->setAttachment_Reference($attachment_Reference)
            ->setJob_Application_Attachment_Data($job_Application_Attachment_Data)
            ->setProspect_Resume_Attachment_Data($prospect_Resume_Attachment_Data)
            ->setVersion($version);
    }
    /**
     * Get Candidate_Reference value
     * @return \StructType\CandidateObjectType|null
     */
    public function getCandidate_Reference()
    {
        return $this->Candidate_Reference;
    }
    /**
     * Set Candidate_Reference value
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @return \StructType\Put_Candidate_Attachment_ResponseType
     */
    public function setCandidate_Reference(\StructType\CandidateObjectType $candidate_Reference = null)
    {
        $this->Candidate_Reference = $candidate_Reference;
        return $this;
    }
    /**
     * Get Attachment_Reference value
     * @return \StructType\Candidate_AttachmentObjectType[]|null
     */
    public function getAttachment_Reference()
    {
        return $this->Attachment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_ReferenceForArrayConstraintsFromSetAttachment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Candidate_Attachment_ResponseTypeAttachment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$put_Candidate_Attachment_ResponseTypeAttachment_ReferenceItem instanceof \StructType\Candidate_AttachmentObjectType) {
                $invalidValues[] = is_object($put_Candidate_Attachment_ResponseTypeAttachment_ReferenceItem) ? get_class($put_Candidate_Attachment_ResponseTypeAttachment_ReferenceItem) : sprintf('%s(%s)', gettype($put_Candidate_Attachment_ResponseTypeAttachment_ReferenceItem), var_export($put_Candidate_Attachment_ResponseTypeAttachment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Reference property can only contain items of type \StructType\Candidate_AttachmentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_AttachmentObjectType[] $attachment_Reference
     * @return \StructType\Put_Candidate_Attachment_ResponseType
     */
    public function setAttachment_Reference(array $attachment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_ReferenceArrayErrorMessage = self::validateAttachment_ReferenceForArrayConstraintsFromSetAttachment_Reference($attachment_Reference))) {
            throw new \InvalidArgumentException($attachment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Reference = $attachment_Reference;
        return $this;
    }
    /**
     * Add item to Attachment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_AttachmentObjectType $item
     * @return \StructType\Put_Candidate_Attachment_ResponseType
     */
    public function addToAttachment_Reference(\StructType\Candidate_AttachmentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_AttachmentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Reference property can only contain items of type \StructType\Candidate_AttachmentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Reference[] = $item;
        return $this;
    }
    /**
     * Get Job_Application_Attachment_Data value
     * @return \StructType\Job_Application_Attachment_ResponseType[]|null
     */
    public function getJob_Application_Attachment_Data()
    {
        return $this->Job_Application_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Application_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Application_Attachment_DataForArrayConstraintsFromSetJob_Application_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Candidate_Attachment_ResponseTypeJob_Application_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$put_Candidate_Attachment_ResponseTypeJob_Application_Attachment_DataItem instanceof \StructType\Job_Application_Attachment_ResponseType) {
                $invalidValues[] = is_object($put_Candidate_Attachment_ResponseTypeJob_Application_Attachment_DataItem) ? get_class($put_Candidate_Attachment_ResponseTypeJob_Application_Attachment_DataItem) : sprintf('%s(%s)', gettype($put_Candidate_Attachment_ResponseTypeJob_Application_Attachment_DataItem), var_export($put_Candidate_Attachment_ResponseTypeJob_Application_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Application_Attachment_Data property can only contain items of type \StructType\Job_Application_Attachment_ResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Application_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Application_Attachment_ResponseType[] $job_Application_Attachment_Data
     * @return \StructType\Put_Candidate_Attachment_ResponseType
     */
    public function setJob_Application_Attachment_Data(array $job_Application_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Application_Attachment_DataArrayErrorMessage = self::validateJob_Application_Attachment_DataForArrayConstraintsFromSetJob_Application_Attachment_Data($job_Application_Attachment_Data))) {
            throw new \InvalidArgumentException($job_Application_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Application_Attachment_Data = $job_Application_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Job_Application_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Application_Attachment_ResponseType $item
     * @return \StructType\Put_Candidate_Attachment_ResponseType
     */
    public function addToJob_Application_Attachment_Data(\StructType\Job_Application_Attachment_ResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Application_Attachment_ResponseType) {
            throw new \InvalidArgumentException(sprintf('The Job_Application_Attachment_Data property can only contain items of type \StructType\Job_Application_Attachment_ResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Application_Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Prospect_Resume_Attachment_Data value
     * @return \StructType\Prospect_Attachments_DataType|null
     */
    public function getProspect_Resume_Attachment_Data()
    {
        return $this->Prospect_Resume_Attachment_Data;
    }
    /**
     * Set Prospect_Resume_Attachment_Data value
     * @param \StructType\Prospect_Attachments_DataType $prospect_Resume_Attachment_Data
     * @return \StructType\Put_Candidate_Attachment_ResponseType
     */
    public function setProspect_Resume_Attachment_Data(\StructType\Prospect_Attachments_DataType $prospect_Resume_Attachment_Data = null)
    {
        $this->Prospect_Resume_Attachment_Data = $prospect_Resume_Attachment_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Candidate_Attachment_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
