<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Candidate_Attachment_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains a Candidate and/or Job Application to add Attachments to.
 * @subpackage Structs
 */
class Put_Candidate_Attachment_RequestType extends AbstractStructBase
{
    /**
     * The Candidate_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Candidate.
     * - minOccurs: 0
     * @var \StructType\CandidateObjectType
     */
    public $Candidate_Reference;
    /**
     * The Prospect_Resume_Attachments_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Prospect_Attachments_DataType
     */
    public $Prospect_Resume_Attachments_Data;
    /**
     * The Candidate_Attachment_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Candidate_Attachment_DataType
     */
    public $Candidate_Attachment_Data;
    /**
     * The Job_Application_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Application_Attachment_DataType[]
     */
    public $Job_Application_Attachment_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update. If an existing instance is found and this flag is set there will be an error.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Candidate_Attachment_RequestType
     * @uses Put_Candidate_Attachment_RequestType::setCandidate_Reference()
     * @uses Put_Candidate_Attachment_RequestType::setProspect_Resume_Attachments_Data()
     * @uses Put_Candidate_Attachment_RequestType::setCandidate_Attachment_Data()
     * @uses Put_Candidate_Attachment_RequestType::setJob_Application_Attachment_Data()
     * @uses Put_Candidate_Attachment_RequestType::setAdd_Only()
     * @uses Put_Candidate_Attachment_RequestType::setVersion()
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @param \StructType\Prospect_Attachments_DataType $prospect_Resume_Attachments_Data
     * @param \StructType\Candidate_Attachment_DataType $candidate_Attachment_Data
     * @param \StructType\Job_Application_Attachment_DataType[] $job_Application_Attachment_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\CandidateObjectType $candidate_Reference = null, \StructType\Prospect_Attachments_DataType $prospect_Resume_Attachments_Data = null, \StructType\Candidate_Attachment_DataType $candidate_Attachment_Data = null, array $job_Application_Attachment_Data = array(), $add_Only = null, $version = null)
    {
        $this
            ->setCandidate_Reference($candidate_Reference)
            ->setProspect_Resume_Attachments_Data($prospect_Resume_Attachments_Data)
            ->setCandidate_Attachment_Data($candidate_Attachment_Data)
            ->setJob_Application_Attachment_Data($job_Application_Attachment_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Candidate_Reference value
     * @return \StructType\CandidateObjectType|null
     */
    public function getCandidate_Reference()
    {
        return $this->Candidate_Reference;
    }
    /**
     * Set Candidate_Reference value
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @return \StructType\Put_Candidate_Attachment_RequestType
     */
    public function setCandidate_Reference(\StructType\CandidateObjectType $candidate_Reference = null)
    {
        $this->Candidate_Reference = $candidate_Reference;
        return $this;
    }
    /**
     * Get Prospect_Resume_Attachments_Data value
     * @return \StructType\Prospect_Attachments_DataType|null
     */
    public function getProspect_Resume_Attachments_Data()
    {
        return $this->Prospect_Resume_Attachments_Data;
    }
    /**
     * Set Prospect_Resume_Attachments_Data value
     * @param \StructType\Prospect_Attachments_DataType $prospect_Resume_Attachments_Data
     * @return \StructType\Put_Candidate_Attachment_RequestType
     */
    public function setProspect_Resume_Attachments_Data(\StructType\Prospect_Attachments_DataType $prospect_Resume_Attachments_Data = null)
    {
        $this->Prospect_Resume_Attachments_Data = $prospect_Resume_Attachments_Data;
        return $this;
    }
    /**
     * Get Candidate_Attachment_Data value
     * @return \StructType\Candidate_Attachment_DataType|null
     */
    public function getCandidate_Attachment_Data()
    {
        return $this->Candidate_Attachment_Data;
    }
    /**
     * Set Candidate_Attachment_Data value
     * @param \StructType\Candidate_Attachment_DataType $candidate_Attachment_Data
     * @return \StructType\Put_Candidate_Attachment_RequestType
     */
    public function setCandidate_Attachment_Data(\StructType\Candidate_Attachment_DataType $candidate_Attachment_Data = null)
    {
        $this->Candidate_Attachment_Data = $candidate_Attachment_Data;
        return $this;
    }
    /**
     * Get Job_Application_Attachment_Data value
     * @return \StructType\Job_Application_Attachment_DataType[]|null
     */
    public function getJob_Application_Attachment_Data()
    {
        return $this->Job_Application_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Application_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Application_Attachment_DataForArrayConstraintsFromSetJob_Application_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Candidate_Attachment_RequestTypeJob_Application_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$put_Candidate_Attachment_RequestTypeJob_Application_Attachment_DataItem instanceof \StructType\Job_Application_Attachment_DataType) {
                $invalidValues[] = is_object($put_Candidate_Attachment_RequestTypeJob_Application_Attachment_DataItem) ? get_class($put_Candidate_Attachment_RequestTypeJob_Application_Attachment_DataItem) : sprintf('%s(%s)', gettype($put_Candidate_Attachment_RequestTypeJob_Application_Attachment_DataItem), var_export($put_Candidate_Attachment_RequestTypeJob_Application_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Application_Attachment_Data property can only contain items of type \StructType\Job_Application_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Application_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Application_Attachment_DataType[] $job_Application_Attachment_Data
     * @return \StructType\Put_Candidate_Attachment_RequestType
     */
    public function setJob_Application_Attachment_Data(array $job_Application_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Application_Attachment_DataArrayErrorMessage = self::validateJob_Application_Attachment_DataForArrayConstraintsFromSetJob_Application_Attachment_Data($job_Application_Attachment_Data))) {
            throw new \InvalidArgumentException($job_Application_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Application_Attachment_Data = $job_Application_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Job_Application_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Application_Attachment_DataType $item
     * @return \StructType\Put_Candidate_Attachment_RequestType
     */
    public function addToJob_Application_Attachment_Data(\StructType\Job_Application_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Application_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Job_Application_Attachment_Data property can only contain items of type \StructType\Job_Application_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Application_Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Candidate_Attachment_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Candidate_Attachment_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
