<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Period_Salary_Plan_Assignment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Period Salary Plan Compensation data.
 * @subpackage Structs
 */
class Proposed_Period_Salary_Plan_Assignment_DataType extends AbstractStructBase
{
    /**
     * The Period_Salary_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Period salary plan to update or assign. Does not default for Request Compensation Change.
     * - minOccurs: 0
     * @var \StructType\Period_Salary_PlanObjectType
     */
    public $Period_Salary_Plan_Reference;
    /**
     * The Compensation_Period_Reference
     * Meta information extracted from the WSDL
     * - documentation: Compensation period of time measure.
     * - minOccurs: 0
     * @var \StructType\Compensation_PeriodObjectType
     */
    public $Compensation_Period_Reference;
    /**
     * The Manage_by_Compensation_Basis_Override_Amount
     * Meta information extracted from the WSDL
     * - documentation: This field allows an override amount to be specified for workerswho are managed by compensation basis.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Manage_by_Compensation_Basis_Override_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency of the period salary plan.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Compensation_Period_Multiplier
     * Meta information extracted from the WSDL
     * - documentation: Default Compensation Period Multiplier is required.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Compensation_Period_Multiplier;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Frequency of the period salary plan.
     * - minOccurs: 0
     * @var \StructType\FrequencyObjectType
     */
    public $Frequency_Reference;
    /**
     * The Actual_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Actual End Date for the plan assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Actual_End_Date;
    /**
     * Constructor method for Proposed_Period_Salary_Plan_Assignment_DataType
     * @uses Proposed_Period_Salary_Plan_Assignment_DataType::setPeriod_Salary_Plan_Reference()
     * @uses Proposed_Period_Salary_Plan_Assignment_DataType::setCompensation_Period_Reference()
     * @uses Proposed_Period_Salary_Plan_Assignment_DataType::setManage_by_Compensation_Basis_Override_Amount()
     * @uses Proposed_Period_Salary_Plan_Assignment_DataType::setCurrency_Reference()
     * @uses Proposed_Period_Salary_Plan_Assignment_DataType::setCompensation_Period_Multiplier()
     * @uses Proposed_Period_Salary_Plan_Assignment_DataType::setFrequency_Reference()
     * @uses Proposed_Period_Salary_Plan_Assignment_DataType::setActual_End_Date()
     * @param \StructType\Period_Salary_PlanObjectType $period_Salary_Plan_Reference
     * @param \StructType\Compensation_PeriodObjectType $compensation_Period_Reference
     * @param float $manage_by_Compensation_Basis_Override_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $compensation_Period_Multiplier
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @param string $actual_End_Date
     */
    public function __construct(\StructType\Period_Salary_PlanObjectType $period_Salary_Plan_Reference = null, \StructType\Compensation_PeriodObjectType $compensation_Period_Reference = null, $manage_by_Compensation_Basis_Override_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, $compensation_Period_Multiplier = null, \StructType\FrequencyObjectType $frequency_Reference = null, $actual_End_Date = null)
    {
        $this
            ->setPeriod_Salary_Plan_Reference($period_Salary_Plan_Reference)
            ->setCompensation_Period_Reference($compensation_Period_Reference)
            ->setManage_by_Compensation_Basis_Override_Amount($manage_by_Compensation_Basis_Override_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setCompensation_Period_Multiplier($compensation_Period_Multiplier)
            ->setFrequency_Reference($frequency_Reference)
            ->setActual_End_Date($actual_End_Date);
    }
    /**
     * Get Period_Salary_Plan_Reference value
     * @return \StructType\Period_Salary_PlanObjectType|null
     */
    public function getPeriod_Salary_Plan_Reference()
    {
        return $this->Period_Salary_Plan_Reference;
    }
    /**
     * Set Period_Salary_Plan_Reference value
     * @param \StructType\Period_Salary_PlanObjectType $period_Salary_Plan_Reference
     * @return \StructType\Proposed_Period_Salary_Plan_Assignment_DataType
     */
    public function setPeriod_Salary_Plan_Reference(\StructType\Period_Salary_PlanObjectType $period_Salary_Plan_Reference = null)
    {
        $this->Period_Salary_Plan_Reference = $period_Salary_Plan_Reference;
        return $this;
    }
    /**
     * Get Compensation_Period_Reference value
     * @return \StructType\Compensation_PeriodObjectType|null
     */
    public function getCompensation_Period_Reference()
    {
        return $this->Compensation_Period_Reference;
    }
    /**
     * Set Compensation_Period_Reference value
     * @param \StructType\Compensation_PeriodObjectType $compensation_Period_Reference
     * @return \StructType\Proposed_Period_Salary_Plan_Assignment_DataType
     */
    public function setCompensation_Period_Reference(\StructType\Compensation_PeriodObjectType $compensation_Period_Reference = null)
    {
        $this->Compensation_Period_Reference = $compensation_Period_Reference;
        return $this;
    }
    /**
     * Get Manage_by_Compensation_Basis_Override_Amount value
     * @return float|null
     */
    public function getManage_by_Compensation_Basis_Override_Amount()
    {
        return $this->Manage_by_Compensation_Basis_Override_Amount;
    }
    /**
     * Set Manage_by_Compensation_Basis_Override_Amount value
     * @param float $manage_by_Compensation_Basis_Override_Amount
     * @return \StructType\Proposed_Period_Salary_Plan_Assignment_DataType
     */
    public function setManage_by_Compensation_Basis_Override_Amount($manage_by_Compensation_Basis_Override_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($manage_by_Compensation_Basis_Override_Amount) && !(is_float($manage_by_Compensation_Basis_Override_Amount) || is_numeric($manage_by_Compensation_Basis_Override_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($manage_by_Compensation_Basis_Override_Amount, true), gettype($manage_by_Compensation_Basis_Override_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($manage_by_Compensation_Basis_Override_Amount) && mb_strlen(mb_substr($manage_by_Compensation_Basis_Override_Amount, false !== mb_strpos($manage_by_Compensation_Basis_Override_Amount, '.') ? mb_strpos($manage_by_Compensation_Basis_Override_Amount, '.') + 1 : mb_strlen($manage_by_Compensation_Basis_Override_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($manage_by_Compensation_Basis_Override_Amount, true), mb_strlen(mb_substr($manage_by_Compensation_Basis_Override_Amount, mb_strpos($manage_by_Compensation_Basis_Override_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($manage_by_Compensation_Basis_Override_Amount) && mb_strlen(preg_replace('/(\D)/', '', $manage_by_Compensation_Basis_Override_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($manage_by_Compensation_Basis_Override_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $manage_by_Compensation_Basis_Override_Amount))), __LINE__);
        }
        $this->Manage_by_Compensation_Basis_Override_Amount = $manage_by_Compensation_Basis_Override_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Proposed_Period_Salary_Plan_Assignment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Compensation_Period_Multiplier value
     * @return float|null
     */
    public function getCompensation_Period_Multiplier()
    {
        return $this->Compensation_Period_Multiplier;
    }
    /**
     * Set Compensation_Period_Multiplier value
     * @param float $compensation_Period_Multiplier
     * @return \StructType\Proposed_Period_Salary_Plan_Assignment_DataType
     */
    public function setCompensation_Period_Multiplier($compensation_Period_Multiplier = null)
    {
        // validation for constraint: float
        if (!is_null($compensation_Period_Multiplier) && !(is_float($compensation_Period_Multiplier) || is_numeric($compensation_Period_Multiplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($compensation_Period_Multiplier, true), gettype($compensation_Period_Multiplier)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($compensation_Period_Multiplier) && mb_strlen(mb_substr($compensation_Period_Multiplier, false !== mb_strpos($compensation_Period_Multiplier, '.') ? mb_strpos($compensation_Period_Multiplier, '.') + 1 : mb_strlen($compensation_Period_Multiplier))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($compensation_Period_Multiplier, true), mb_strlen(mb_substr($compensation_Period_Multiplier, mb_strpos($compensation_Period_Multiplier, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($compensation_Period_Multiplier) && $compensation_Period_Multiplier < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($compensation_Period_Multiplier, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($compensation_Period_Multiplier) && mb_strlen(preg_replace('/(\D)/', '', $compensation_Period_Multiplier)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($compensation_Period_Multiplier, true), mb_strlen(preg_replace('/(\D)/', '', $compensation_Period_Multiplier))), __LINE__);
        }
        $this->Compensation_Period_Multiplier = $compensation_Period_Multiplier;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\FrequencyObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @return \StructType\Proposed_Period_Salary_Plan_Assignment_DataType
     */
    public function setFrequency_Reference(\StructType\FrequencyObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Actual_End_Date value
     * @return string|null
     */
    public function getActual_End_Date()
    {
        return $this->Actual_End_Date;
    }
    /**
     * Set Actual_End_Date value
     * @param string $actual_End_Date
     * @return \StructType\Proposed_Period_Salary_Plan_Assignment_DataType
     */
    public function setActual_End_Date($actual_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($actual_End_Date) && !is_string($actual_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actual_End_Date, true), gettype($actual_End_Date)), __LINE__);
        }
        $this->Actual_End_Date = $actual_End_Date;
        return $this;
    }
}
