<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Merit_Plan_Assignment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Merit Plan Compensation data.
 * @subpackage Structs
 */
class Proposed_Merit_Plan_Assignment_DataType extends AbstractStructBase
{
    /**
     * The Merit_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Merit Plan to update or assign. Does not default for Request Compensation Change.
     * - minOccurs: 0
     * @var \StructType\Merit_PlanObjectType
     */
    public $Merit_Plan_Reference;
    /**
     * The Individual_Target_Amount
     * Meta information extracted from the WSDL
     * - documentation: Individual target amount that overrides the default target percent on the plan, provided Allow Target Override is enabled on the plan. Mutually exclusive from Individual Target Percent. | Individual target amount that overrides the
     * default target amount on the plan, provided Allow Target Override is enabled on the plan. Mutually exclusive from Individual Target Percent. | Stock Plan does not allow override for individual target.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Individual_Target_Amount;
    /**
     * The Individual_Target_Percent
     * Meta information extracted from the WSDL
     * - documentation: Individual target percent that overrides the default target percent on the plan, provided Allow Target Override is enabled on the plan. Mutually exclusive from Individual Target Amount. | Individual target percent that overrides the
     * default target amount on the plan, provided Allow Target Override is enabled on the plan. | Stock Plan does not allow override for individual target.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 16
     * @var float
     */
    public $Individual_Target_Percent;
    /**
     * The Guaranteed_Minimum
     * Meta information extracted from the WSDL
     * - documentation: If true, employee is guaranteed the minimum for the merit plan.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Guaranteed_Minimum;
    /**
     * The Actual_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Actual End Date for the plan assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Actual_End_Date;
    /**
     * Constructor method for Proposed_Merit_Plan_Assignment_DataType
     * @uses Proposed_Merit_Plan_Assignment_DataType::setMerit_Plan_Reference()
     * @uses Proposed_Merit_Plan_Assignment_DataType::setIndividual_Target_Amount()
     * @uses Proposed_Merit_Plan_Assignment_DataType::setIndividual_Target_Percent()
     * @uses Proposed_Merit_Plan_Assignment_DataType::setGuaranteed_Minimum()
     * @uses Proposed_Merit_Plan_Assignment_DataType::setActual_End_Date()
     * @param \StructType\Merit_PlanObjectType $merit_Plan_Reference
     * @param float $individual_Target_Amount
     * @param float $individual_Target_Percent
     * @param bool $guaranteed_Minimum
     * @param string $actual_End_Date
     */
    public function __construct(\StructType\Merit_PlanObjectType $merit_Plan_Reference = null, $individual_Target_Amount = null, $individual_Target_Percent = null, $guaranteed_Minimum = null, $actual_End_Date = null)
    {
        $this
            ->setMerit_Plan_Reference($merit_Plan_Reference)
            ->setIndividual_Target_Amount($individual_Target_Amount)
            ->setIndividual_Target_Percent($individual_Target_Percent)
            ->setGuaranteed_Minimum($guaranteed_Minimum)
            ->setActual_End_Date($actual_End_Date);
    }
    /**
     * Get Merit_Plan_Reference value
     * @return \StructType\Merit_PlanObjectType|null
     */
    public function getMerit_Plan_Reference()
    {
        return $this->Merit_Plan_Reference;
    }
    /**
     * Set Merit_Plan_Reference value
     * @param \StructType\Merit_PlanObjectType $merit_Plan_Reference
     * @return \StructType\Proposed_Merit_Plan_Assignment_DataType
     */
    public function setMerit_Plan_Reference(\StructType\Merit_PlanObjectType $merit_Plan_Reference = null)
    {
        $this->Merit_Plan_Reference = $merit_Plan_Reference;
        return $this;
    }
    /**
     * Get Individual_Target_Amount value
     * @return float|null
     */
    public function getIndividual_Target_Amount()
    {
        return $this->Individual_Target_Amount;
    }
    /**
     * Set Individual_Target_Amount value
     * @param float $individual_Target_Amount
     * @return \StructType\Proposed_Merit_Plan_Assignment_DataType
     */
    public function setIndividual_Target_Amount($individual_Target_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($individual_Target_Amount) && !(is_float($individual_Target_Amount) || is_numeric($individual_Target_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($individual_Target_Amount, true), gettype($individual_Target_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($individual_Target_Amount) && mb_strlen(mb_substr($individual_Target_Amount, false !== mb_strpos($individual_Target_Amount, '.') ? mb_strpos($individual_Target_Amount, '.') + 1 : mb_strlen($individual_Target_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($individual_Target_Amount, true), mb_strlen(mb_substr($individual_Target_Amount, mb_strpos($individual_Target_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($individual_Target_Amount) && mb_strlen(preg_replace('/(\D)/', '', $individual_Target_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($individual_Target_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $individual_Target_Amount))), __LINE__);
        }
        $this->Individual_Target_Amount = $individual_Target_Amount;
        return $this;
    }
    /**
     * Get Individual_Target_Percent value
     * @return float|null
     */
    public function getIndividual_Target_Percent()
    {
        return $this->Individual_Target_Percent;
    }
    /**
     * Set Individual_Target_Percent value
     * @param float $individual_Target_Percent
     * @return \StructType\Proposed_Merit_Plan_Assignment_DataType
     */
    public function setIndividual_Target_Percent($individual_Target_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($individual_Target_Percent) && !(is_float($individual_Target_Percent) || is_numeric($individual_Target_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($individual_Target_Percent, true), gettype($individual_Target_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($individual_Target_Percent) && mb_strlen(mb_substr($individual_Target_Percent, false !== mb_strpos($individual_Target_Percent, '.') ? mb_strpos($individual_Target_Percent, '.') + 1 : mb_strlen($individual_Target_Percent))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($individual_Target_Percent, true), mb_strlen(mb_substr($individual_Target_Percent, mb_strpos($individual_Target_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($individual_Target_Percent) && $individual_Target_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($individual_Target_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($individual_Target_Percent) && mb_strlen(preg_replace('/(\D)/', '', $individual_Target_Percent)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($individual_Target_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $individual_Target_Percent))), __LINE__);
        }
        $this->Individual_Target_Percent = $individual_Target_Percent;
        return $this;
    }
    /**
     * Get Guaranteed_Minimum value
     * @return bool|null
     */
    public function getGuaranteed_Minimum()
    {
        return $this->Guaranteed_Minimum;
    }
    /**
     * Set Guaranteed_Minimum value
     * @param bool $guaranteed_Minimum
     * @return \StructType\Proposed_Merit_Plan_Assignment_DataType
     */
    public function setGuaranteed_Minimum($guaranteed_Minimum = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteed_Minimum) && !is_bool($guaranteed_Minimum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guaranteed_Minimum, true), gettype($guaranteed_Minimum)), __LINE__);
        }
        $this->Guaranteed_Minimum = $guaranteed_Minimum;
        return $this;
    }
    /**
     * Get Actual_End_Date value
     * @return string|null
     */
    public function getActual_End_Date()
    {
        return $this->Actual_End_Date;
    }
    /**
     * Set Actual_End_Date value
     * @param string $actual_End_Date
     * @return \StructType\Proposed_Merit_Plan_Assignment_DataType
     */
    public function setActual_End_Date($actual_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($actual_End_Date) && !is_string($actual_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actual_End_Date, true), gettype($actual_End_Date)), __LINE__);
        }
        $this->Actual_End_Date = $actual_End_Date;
        return $this;
    }
}
