<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Commission_Plan_Assignment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Commission Plan Compensation data.
 * @subpackage Structs
 */
class Proposed_Commission_Plan_Assignment_DataType extends AbstractStructBase
{
    /**
     * The Commission_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Commission plan to update or assign. Does not default for Request Compensation Change.
     * - minOccurs: 0
     * @var \StructType\Commission_PlanObjectType
     */
    public $Commission_Plan_Reference;
    /**
     * The Target_Amount
     * Meta information extracted from the WSDL
     * - documentation: Target amount for the Commission Plan.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Target_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency for the Commission Plan. Required if the target amount is entered and there is no default currency for the plan.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Frequency for the Commission Plan. Required if the target amount is entered and there is no default amount for the plan.
     * - minOccurs: 0
     * @var \StructType\FrequencyObjectType
     */
    public $Frequency_Reference;
    /**
     * The Draw_Amount
     * Meta information extracted from the WSDL
     * - documentation: Draw amount for the Commission Plan.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Draw_Amount;
    /**
     * The Draw_Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing a unique instance of Frequency for the Draw Amount.
     * - minOccurs: 0
     * @var \StructType\FrequencyObjectType
     */
    public $Draw_Frequency_Reference;
    /**
     * The Draw_Duration
     * Meta information extracted from the WSDL
     * - documentation: Description of the duration of the draw amount. For informational purposes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Draw_Duration;
    /**
     * The Recoverable
     * Meta information extracted from the WSDL
     * - documentation: If true, the compensation element is recoverable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Recoverable;
    /**
     * The Actual_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Actual End Date for the plan assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Actual_End_Date;
    /**
     * The Fixed_for_Manage_by_Basis_Total
     * Meta information extracted from the WSDL
     * - documentation: This field allows a plan assignment for a remainder plan in the compensation basis algorithm to be considered a fixed plan assignment. This field is only valid for plans in the PCB of a worker that is managed by basis total where the
     * plan allows override. The flag will be ignored if the conditions are not met.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Fixed_for_Manage_by_Basis_Total;
    /**
     * Constructor method for Proposed_Commission_Plan_Assignment_DataType
     * @uses Proposed_Commission_Plan_Assignment_DataType::setCommission_Plan_Reference()
     * @uses Proposed_Commission_Plan_Assignment_DataType::setTarget_Amount()
     * @uses Proposed_Commission_Plan_Assignment_DataType::setCurrency_Reference()
     * @uses Proposed_Commission_Plan_Assignment_DataType::setFrequency_Reference()
     * @uses Proposed_Commission_Plan_Assignment_DataType::setDraw_Amount()
     * @uses Proposed_Commission_Plan_Assignment_DataType::setDraw_Frequency_Reference()
     * @uses Proposed_Commission_Plan_Assignment_DataType::setDraw_Duration()
     * @uses Proposed_Commission_Plan_Assignment_DataType::setRecoverable()
     * @uses Proposed_Commission_Plan_Assignment_DataType::setActual_End_Date()
     * @uses Proposed_Commission_Plan_Assignment_DataType::setFixed_for_Manage_by_Basis_Total()
     * @param \StructType\Commission_PlanObjectType $commission_Plan_Reference
     * @param float $target_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @param float $draw_Amount
     * @param \StructType\FrequencyObjectType $draw_Frequency_Reference
     * @param string $draw_Duration
     * @param bool $recoverable
     * @param string $actual_End_Date
     * @param bool $fixed_for_Manage_by_Basis_Total
     */
    public function __construct(\StructType\Commission_PlanObjectType $commission_Plan_Reference = null, $target_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\FrequencyObjectType $frequency_Reference = null, $draw_Amount = null, \StructType\FrequencyObjectType $draw_Frequency_Reference = null, $draw_Duration = null, $recoverable = null, $actual_End_Date = null, $fixed_for_Manage_by_Basis_Total = null)
    {
        $this
            ->setCommission_Plan_Reference($commission_Plan_Reference)
            ->setTarget_Amount($target_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setFrequency_Reference($frequency_Reference)
            ->setDraw_Amount($draw_Amount)
            ->setDraw_Frequency_Reference($draw_Frequency_Reference)
            ->setDraw_Duration($draw_Duration)
            ->setRecoverable($recoverable)
            ->setActual_End_Date($actual_End_Date)
            ->setFixed_for_Manage_by_Basis_Total($fixed_for_Manage_by_Basis_Total);
    }
    /**
     * Get Commission_Plan_Reference value
     * @return \StructType\Commission_PlanObjectType|null
     */
    public function getCommission_Plan_Reference()
    {
        return $this->Commission_Plan_Reference;
    }
    /**
     * Set Commission_Plan_Reference value
     * @param \StructType\Commission_PlanObjectType $commission_Plan_Reference
     * @return \StructType\Proposed_Commission_Plan_Assignment_DataType
     */
    public function setCommission_Plan_Reference(\StructType\Commission_PlanObjectType $commission_Plan_Reference = null)
    {
        $this->Commission_Plan_Reference = $commission_Plan_Reference;
        return $this;
    }
    /**
     * Get Target_Amount value
     * @return float|null
     */
    public function getTarget_Amount()
    {
        return $this->Target_Amount;
    }
    /**
     * Set Target_Amount value
     * @param float $target_Amount
     * @return \StructType\Proposed_Commission_Plan_Assignment_DataType
     */
    public function setTarget_Amount($target_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($target_Amount) && !(is_float($target_Amount) || is_numeric($target_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($target_Amount, true), gettype($target_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($target_Amount) && mb_strlen(mb_substr($target_Amount, false !== mb_strpos($target_Amount, '.') ? mb_strpos($target_Amount, '.') + 1 : mb_strlen($target_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($target_Amount, true), mb_strlen(mb_substr($target_Amount, mb_strpos($target_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($target_Amount) && mb_strlen(preg_replace('/(\D)/', '', $target_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($target_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $target_Amount))), __LINE__);
        }
        $this->Target_Amount = $target_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Proposed_Commission_Plan_Assignment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\FrequencyObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @return \StructType\Proposed_Commission_Plan_Assignment_DataType
     */
    public function setFrequency_Reference(\StructType\FrequencyObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Draw_Amount value
     * @return float|null
     */
    public function getDraw_Amount()
    {
        return $this->Draw_Amount;
    }
    /**
     * Set Draw_Amount value
     * @param float $draw_Amount
     * @return \StructType\Proposed_Commission_Plan_Assignment_DataType
     */
    public function setDraw_Amount($draw_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($draw_Amount) && !(is_float($draw_Amount) || is_numeric($draw_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($draw_Amount, true), gettype($draw_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($draw_Amount) && mb_strlen(mb_substr($draw_Amount, false !== mb_strpos($draw_Amount, '.') ? mb_strpos($draw_Amount, '.') + 1 : mb_strlen($draw_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($draw_Amount, true), mb_strlen(mb_substr($draw_Amount, mb_strpos($draw_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($draw_Amount) && $draw_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($draw_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($draw_Amount) && mb_strlen(preg_replace('/(\D)/', '', $draw_Amount)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($draw_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $draw_Amount))), __LINE__);
        }
        $this->Draw_Amount = $draw_Amount;
        return $this;
    }
    /**
     * Get Draw_Frequency_Reference value
     * @return \StructType\FrequencyObjectType|null
     */
    public function getDraw_Frequency_Reference()
    {
        return $this->Draw_Frequency_Reference;
    }
    /**
     * Set Draw_Frequency_Reference value
     * @param \StructType\FrequencyObjectType $draw_Frequency_Reference
     * @return \StructType\Proposed_Commission_Plan_Assignment_DataType
     */
    public function setDraw_Frequency_Reference(\StructType\FrequencyObjectType $draw_Frequency_Reference = null)
    {
        $this->Draw_Frequency_Reference = $draw_Frequency_Reference;
        return $this;
    }
    /**
     * Get Draw_Duration value
     * @return string|null
     */
    public function getDraw_Duration()
    {
        return $this->Draw_Duration;
    }
    /**
     * Set Draw_Duration value
     * @param string $draw_Duration
     * @return \StructType\Proposed_Commission_Plan_Assignment_DataType
     */
    public function setDraw_Duration($draw_Duration = null)
    {
        // validation for constraint: string
        if (!is_null($draw_Duration) && !is_string($draw_Duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($draw_Duration, true), gettype($draw_Duration)), __LINE__);
        }
        $this->Draw_Duration = $draw_Duration;
        return $this;
    }
    /**
     * Get Recoverable value
     * @return bool|null
     */
    public function getRecoverable()
    {
        return $this->Recoverable;
    }
    /**
     * Set Recoverable value
     * @param bool $recoverable
     * @return \StructType\Proposed_Commission_Plan_Assignment_DataType
     */
    public function setRecoverable($recoverable = null)
    {
        // validation for constraint: boolean
        if (!is_null($recoverable) && !is_bool($recoverable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recoverable, true), gettype($recoverable)), __LINE__);
        }
        $this->Recoverable = $recoverable;
        return $this;
    }
    /**
     * Get Actual_End_Date value
     * @return string|null
     */
    public function getActual_End_Date()
    {
        return $this->Actual_End_Date;
    }
    /**
     * Set Actual_End_Date value
     * @param string $actual_End_Date
     * @return \StructType\Proposed_Commission_Plan_Assignment_DataType
     */
    public function setActual_End_Date($actual_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($actual_End_Date) && !is_string($actual_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actual_End_Date, true), gettype($actual_End_Date)), __LINE__);
        }
        $this->Actual_End_Date = $actual_End_Date;
        return $this;
    }
    /**
     * Get Fixed_for_Manage_by_Basis_Total value
     * @return bool|null
     */
    public function getFixed_for_Manage_by_Basis_Total()
    {
        return $this->Fixed_for_Manage_by_Basis_Total;
    }
    /**
     * Set Fixed_for_Manage_by_Basis_Total value
     * @param bool $fixed_for_Manage_by_Basis_Total
     * @return \StructType\Proposed_Commission_Plan_Assignment_DataType
     */
    public function setFixed_for_Manage_by_Basis_Total($fixed_for_Manage_by_Basis_Total = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixed_for_Manage_by_Basis_Total) && !is_bool($fixed_for_Manage_by_Basis_Total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixed_for_Manage_by_Basis_Total, true), gettype($fixed_for_Manage_by_Basis_Total)), __LINE__);
        }
        $this->Fixed_for_Manage_by_Basis_Total = $fixed_for_Manage_by_Basis_Total;
        return $this;
    }
}
