<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Commission_Plan_Assignment_Container_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Commission Plan Compensation data.
 * @subpackage Structs
 */
class Proposed_Commission_Plan_Assignment_Container_DataType extends AbstractStructBase
{
    /**
     * The Commission_Plan_Sub_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Commission Plan Compensation data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Proposed_Commission_Plan_Assignment_DataType[]
     */
    public $Commission_Plan_Sub_Data;
    /**
     * The Replace
     * Meta information extracted from the WSDL
     * - documentation: When True, indicates the compensation plans will replace any existing compensation plan assigned to the worker. The default value of False will add or update the compensation plans for the worker.
     * @var bool
     */
    public $Replace;
    /**
     * Constructor method for Proposed_Commission_Plan_Assignment_Container_DataType
     * @uses Proposed_Commission_Plan_Assignment_Container_DataType::setCommission_Plan_Sub_Data()
     * @uses Proposed_Commission_Plan_Assignment_Container_DataType::setReplace()
     * @param \StructType\Proposed_Commission_Plan_Assignment_DataType[] $commission_Plan_Sub_Data
     * @param bool $replace
     */
    public function __construct(array $commission_Plan_Sub_Data = array(), $replace = null)
    {
        $this
            ->setCommission_Plan_Sub_Data($commission_Plan_Sub_Data)
            ->setReplace($replace);
    }
    /**
     * Get Commission_Plan_Sub_Data value
     * @return \StructType\Proposed_Commission_Plan_Assignment_DataType[]|null
     */
    public function getCommission_Plan_Sub_Data()
    {
        return $this->Commission_Plan_Sub_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission_Plan_Sub_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission_Plan_Sub_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommission_Plan_Sub_DataForArrayConstraintsFromSetCommission_Plan_Sub_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $proposed_Commission_Plan_Assignment_Container_DataTypeCommission_Plan_Sub_DataItem) {
            // validation for constraint: itemType
            if (!$proposed_Commission_Plan_Assignment_Container_DataTypeCommission_Plan_Sub_DataItem instanceof \StructType\Proposed_Commission_Plan_Assignment_DataType) {
                $invalidValues[] = is_object($proposed_Commission_Plan_Assignment_Container_DataTypeCommission_Plan_Sub_DataItem) ? get_class($proposed_Commission_Plan_Assignment_Container_DataTypeCommission_Plan_Sub_DataItem) : sprintf('%s(%s)', gettype($proposed_Commission_Plan_Assignment_Container_DataTypeCommission_Plan_Sub_DataItem), var_export($proposed_Commission_Plan_Assignment_Container_DataTypeCommission_Plan_Sub_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission_Plan_Sub_Data property can only contain items of type \StructType\Proposed_Commission_Plan_Assignment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission_Plan_Sub_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Proposed_Commission_Plan_Assignment_DataType[] $commission_Plan_Sub_Data
     * @return \StructType\Proposed_Commission_Plan_Assignment_Container_DataType
     */
    public function setCommission_Plan_Sub_Data(array $commission_Plan_Sub_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($commission_Plan_Sub_DataArrayErrorMessage = self::validateCommission_Plan_Sub_DataForArrayConstraintsFromSetCommission_Plan_Sub_Data($commission_Plan_Sub_Data))) {
            throw new \InvalidArgumentException($commission_Plan_Sub_DataArrayErrorMessage, __LINE__);
        }
        $this->Commission_Plan_Sub_Data = $commission_Plan_Sub_Data;
        return $this;
    }
    /**
     * Add item to Commission_Plan_Sub_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Proposed_Commission_Plan_Assignment_DataType $item
     * @return \StructType\Proposed_Commission_Plan_Assignment_Container_DataType
     */
    public function addToCommission_Plan_Sub_Data(\StructType\Proposed_Commission_Plan_Assignment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Proposed_Commission_Plan_Assignment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Commission_Plan_Sub_Data property can only contain items of type \StructType\Proposed_Commission_Plan_Assignment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission_Plan_Sub_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace value
     * @return bool|null
     */
    public function getReplace()
    {
        return $this->Replace;
    }
    /**
     * Set Replace value
     * @param bool $replace
     * @return \StructType\Proposed_Commission_Plan_Assignment_Container_DataType
     */
    public function setReplace($replace = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace) && !is_bool($replace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace, true), gettype($replace)), __LINE__);
        }
        $this->Replace = $replace;
        return $this;
    }
}
