<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Bonus_Plan_Assignment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Bonus Plan Compensation data.
 * @subpackage Structs
 */
class Proposed_Bonus_Plan_Assignment_DataType extends AbstractStructBase
{
    /**
     * The Bonus_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Bonus Plan to update or assign. Does not default for Request Compensation Change.
     * - minOccurs: 0
     * @var \StructType\Bonus_PlanObjectType
     */
    public $Bonus_Plan_Reference;
    /**
     * The Individual_Target_Amount
     * Meta information extracted from the WSDL
     * - documentation: Individual target amount that overrides the default target percent on the plan, provided Allow Target Override is enabled on the plan. Mutually exclusive from Individual Target Percent. | Individual target amount that overrides the
     * default target amount on the plan, provided Allow Target Override is enabled on the plan. Mutually exclusive from Individual Target Percent. | Stock Plan does not allow override for individual target.
     * - base: xsd:decimal
     * - choice: Individual_Target_Amount | Individual_Target_Percent
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Individual_Target_Amount;
    /**
     * The Individual_Target_Percent
     * Meta information extracted from the WSDL
     * - documentation: Individual target percent that overrides the default target percent on the plan, provided Allow Target Override is enabled on the plan. Mutually exclusive from Individual Target Amount. | Individual target percent that overrides the
     * default target amount on the plan, provided Allow Target Override is enabled on the plan. | Stock Plan does not allow override for individual target.
     * - base: xsd:decimal
     * - choice: Individual_Target_Amount | Individual_Target_Percent
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 16
     * @var float
     */
    public $Individual_Target_Percent;
    /**
     * The Manage_by_Compensation_Basis_Override_Amount
     * Meta information extracted from the WSDL
     * - documentation: This field allows an override amount to be specified for workerswho are managed by compensation basis.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Manage_by_Compensation_Basis_Override_Amount;
    /**
     * The Guaranteed_Minimum
     * Meta information extracted from the WSDL
     * - documentation: If true, employee is guaranteed the minimum for the bonus plan.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Guaranteed_Minimum;
    /**
     * The Percent_Assigned
     * Meta information extracted from the WSDL
     * - documentation: Percent of the bonus assigned. If none entered, default is 100%.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 16
     * @var float
     */
    public $Percent_Assigned;
    /**
     * The Actual_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Actual End Date for the plan assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Actual_End_Date;
    /**
     * The Fixed_for_Manage_by_Basis_Total
     * Meta information extracted from the WSDL
     * - documentation: This field allows a plan assignment for a remainder plan in the compensation basis algorithm to be considered a fixed plan assignment. This field is only valid for plans in the PCB of a worker that is managed by basis total where the
     * plan allows override. The flag will be ignored if the conditions are not met.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Fixed_for_Manage_by_Basis_Total;
    /**
     * Constructor method for Proposed_Bonus_Plan_Assignment_DataType
     * @uses Proposed_Bonus_Plan_Assignment_DataType::setBonus_Plan_Reference()
     * @uses Proposed_Bonus_Plan_Assignment_DataType::setIndividual_Target_Amount()
     * @uses Proposed_Bonus_Plan_Assignment_DataType::setIndividual_Target_Percent()
     * @uses Proposed_Bonus_Plan_Assignment_DataType::setManage_by_Compensation_Basis_Override_Amount()
     * @uses Proposed_Bonus_Plan_Assignment_DataType::setGuaranteed_Minimum()
     * @uses Proposed_Bonus_Plan_Assignment_DataType::setPercent_Assigned()
     * @uses Proposed_Bonus_Plan_Assignment_DataType::setActual_End_Date()
     * @uses Proposed_Bonus_Plan_Assignment_DataType::setFixed_for_Manage_by_Basis_Total()
     * @param \StructType\Bonus_PlanObjectType $bonus_Plan_Reference
     * @param float $individual_Target_Amount
     * @param float $individual_Target_Percent
     * @param float $manage_by_Compensation_Basis_Override_Amount
     * @param bool $guaranteed_Minimum
     * @param float $percent_Assigned
     * @param string $actual_End_Date
     * @param bool $fixed_for_Manage_by_Basis_Total
     */
    public function __construct(\StructType\Bonus_PlanObjectType $bonus_Plan_Reference = null, $individual_Target_Amount = null, $individual_Target_Percent = null, $manage_by_Compensation_Basis_Override_Amount = null, $guaranteed_Minimum = null, $percent_Assigned = null, $actual_End_Date = null, $fixed_for_Manage_by_Basis_Total = null)
    {
        $this
            ->setBonus_Plan_Reference($bonus_Plan_Reference)
            ->setIndividual_Target_Amount($individual_Target_Amount)
            ->setIndividual_Target_Percent($individual_Target_Percent)
            ->setManage_by_Compensation_Basis_Override_Amount($manage_by_Compensation_Basis_Override_Amount)
            ->setGuaranteed_Minimum($guaranteed_Minimum)
            ->setPercent_Assigned($percent_Assigned)
            ->setActual_End_Date($actual_End_Date)
            ->setFixed_for_Manage_by_Basis_Total($fixed_for_Manage_by_Basis_Total);
    }
    /**
     * Get Bonus_Plan_Reference value
     * @return \StructType\Bonus_PlanObjectType|null
     */
    public function getBonus_Plan_Reference()
    {
        return $this->Bonus_Plan_Reference;
    }
    /**
     * Set Bonus_Plan_Reference value
     * @param \StructType\Bonus_PlanObjectType $bonus_Plan_Reference
     * @return \StructType\Proposed_Bonus_Plan_Assignment_DataType
     */
    public function setBonus_Plan_Reference(\StructType\Bonus_PlanObjectType $bonus_Plan_Reference = null)
    {
        $this->Bonus_Plan_Reference = $bonus_Plan_Reference;
        return $this;
    }
    /**
     * Get Individual_Target_Amount value
     * @return float|null
     */
    public function getIndividual_Target_Amount()
    {
        return isset($this->Individual_Target_Amount) ? $this->Individual_Target_Amount : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIndividual_Target_Amount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIndividual_Target_Amount method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIndividual_Target_AmountForChoiceConstraintsFromSetIndividual_Target_Amount($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Individual_Target_Percent',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Individual_Target_Amount can\'t be set as the property %s is already set. Only one property must be set among these properties: Individual_Target_Amount, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Individual_Target_Amount value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $individual_Target_Amount
     * @return \StructType\Proposed_Bonus_Plan_Assignment_DataType
     */
    public function setIndividual_Target_Amount($individual_Target_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($individual_Target_Amount) && !(is_float($individual_Target_Amount) || is_numeric($individual_Target_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($individual_Target_Amount, true), gettype($individual_Target_Amount)), __LINE__);
        }
        // validation for constraint: choice(Individual_Target_Amount, Individual_Target_Percent)
        if ('' !== ($individual_Target_AmountChoiceErrorMessage = self::validateIndividual_Target_AmountForChoiceConstraintsFromSetIndividual_Target_Amount($individual_Target_Amount))) {
            throw new \InvalidArgumentException($individual_Target_AmountChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($individual_Target_Amount) && mb_strlen(mb_substr($individual_Target_Amount, false !== mb_strpos($individual_Target_Amount, '.') ? mb_strpos($individual_Target_Amount, '.') + 1 : mb_strlen($individual_Target_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($individual_Target_Amount, true), mb_strlen(mb_substr($individual_Target_Amount, mb_strpos($individual_Target_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($individual_Target_Amount) && mb_strlen(preg_replace('/(\D)/', '', $individual_Target_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($individual_Target_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $individual_Target_Amount))), __LINE__);
        }
        if (is_null($individual_Target_Amount) || (is_array($individual_Target_Amount) && empty($individual_Target_Amount))) {
            unset($this->Individual_Target_Amount);
        } else {
            $this->Individual_Target_Amount = $individual_Target_Amount;
        }
        return $this;
    }
    /**
     * Get Individual_Target_Percent value
     * @return float|null
     */
    public function getIndividual_Target_Percent()
    {
        return isset($this->Individual_Target_Percent) ? $this->Individual_Target_Percent : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIndividual_Target_Percent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIndividual_Target_Percent method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIndividual_Target_PercentForChoiceConstraintsFromSetIndividual_Target_Percent($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Individual_Target_Amount',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Individual_Target_Percent can\'t be set as the property %s is already set. Only one property must be set among these properties: Individual_Target_Percent, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Individual_Target_Percent value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $individual_Target_Percent
     * @return \StructType\Proposed_Bonus_Plan_Assignment_DataType
     */
    public function setIndividual_Target_Percent($individual_Target_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($individual_Target_Percent) && !(is_float($individual_Target_Percent) || is_numeric($individual_Target_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($individual_Target_Percent, true), gettype($individual_Target_Percent)), __LINE__);
        }
        // validation for constraint: choice(Individual_Target_Amount, Individual_Target_Percent)
        if ('' !== ($individual_Target_PercentChoiceErrorMessage = self::validateIndividual_Target_PercentForChoiceConstraintsFromSetIndividual_Target_Percent($individual_Target_Percent))) {
            throw new \InvalidArgumentException($individual_Target_PercentChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($individual_Target_Percent) && mb_strlen(mb_substr($individual_Target_Percent, false !== mb_strpos($individual_Target_Percent, '.') ? mb_strpos($individual_Target_Percent, '.') + 1 : mb_strlen($individual_Target_Percent))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($individual_Target_Percent, true), mb_strlen(mb_substr($individual_Target_Percent, mb_strpos($individual_Target_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($individual_Target_Percent) && $individual_Target_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($individual_Target_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($individual_Target_Percent) && mb_strlen(preg_replace('/(\D)/', '', $individual_Target_Percent)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($individual_Target_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $individual_Target_Percent))), __LINE__);
        }
        if (is_null($individual_Target_Percent) || (is_array($individual_Target_Percent) && empty($individual_Target_Percent))) {
            unset($this->Individual_Target_Percent);
        } else {
            $this->Individual_Target_Percent = $individual_Target_Percent;
        }
        return $this;
    }
    /**
     * Get Manage_by_Compensation_Basis_Override_Amount value
     * @return float|null
     */
    public function getManage_by_Compensation_Basis_Override_Amount()
    {
        return $this->Manage_by_Compensation_Basis_Override_Amount;
    }
    /**
     * Set Manage_by_Compensation_Basis_Override_Amount value
     * @param float $manage_by_Compensation_Basis_Override_Amount
     * @return \StructType\Proposed_Bonus_Plan_Assignment_DataType
     */
    public function setManage_by_Compensation_Basis_Override_Amount($manage_by_Compensation_Basis_Override_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($manage_by_Compensation_Basis_Override_Amount) && !(is_float($manage_by_Compensation_Basis_Override_Amount) || is_numeric($manage_by_Compensation_Basis_Override_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($manage_by_Compensation_Basis_Override_Amount, true), gettype($manage_by_Compensation_Basis_Override_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($manage_by_Compensation_Basis_Override_Amount) && mb_strlen(mb_substr($manage_by_Compensation_Basis_Override_Amount, false !== mb_strpos($manage_by_Compensation_Basis_Override_Amount, '.') ? mb_strpos($manage_by_Compensation_Basis_Override_Amount, '.') + 1 : mb_strlen($manage_by_Compensation_Basis_Override_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($manage_by_Compensation_Basis_Override_Amount, true), mb_strlen(mb_substr($manage_by_Compensation_Basis_Override_Amount, mb_strpos($manage_by_Compensation_Basis_Override_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($manage_by_Compensation_Basis_Override_Amount) && mb_strlen(preg_replace('/(\D)/', '', $manage_by_Compensation_Basis_Override_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($manage_by_Compensation_Basis_Override_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $manage_by_Compensation_Basis_Override_Amount))), __LINE__);
        }
        $this->Manage_by_Compensation_Basis_Override_Amount = $manage_by_Compensation_Basis_Override_Amount;
        return $this;
    }
    /**
     * Get Guaranteed_Minimum value
     * @return bool|null
     */
    public function getGuaranteed_Minimum()
    {
        return $this->Guaranteed_Minimum;
    }
    /**
     * Set Guaranteed_Minimum value
     * @param bool $guaranteed_Minimum
     * @return \StructType\Proposed_Bonus_Plan_Assignment_DataType
     */
    public function setGuaranteed_Minimum($guaranteed_Minimum = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteed_Minimum) && !is_bool($guaranteed_Minimum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guaranteed_Minimum, true), gettype($guaranteed_Minimum)), __LINE__);
        }
        $this->Guaranteed_Minimum = $guaranteed_Minimum;
        return $this;
    }
    /**
     * Get Percent_Assigned value
     * @return float|null
     */
    public function getPercent_Assigned()
    {
        return $this->Percent_Assigned;
    }
    /**
     * Set Percent_Assigned value
     * @param float $percent_Assigned
     * @return \StructType\Proposed_Bonus_Plan_Assignment_DataType
     */
    public function setPercent_Assigned($percent_Assigned = null)
    {
        // validation for constraint: float
        if (!is_null($percent_Assigned) && !(is_float($percent_Assigned) || is_numeric($percent_Assigned))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_Assigned, true), gettype($percent_Assigned)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($percent_Assigned) && mb_strlen(mb_substr($percent_Assigned, false !== mb_strpos($percent_Assigned, '.') ? mb_strpos($percent_Assigned, '.') + 1 : mb_strlen($percent_Assigned))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($percent_Assigned, true), mb_strlen(mb_substr($percent_Assigned, mb_strpos($percent_Assigned, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_Assigned) && $percent_Assigned < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_Assigned, true)), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($percent_Assigned) && mb_strlen(preg_replace('/(\D)/', '', $percent_Assigned)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($percent_Assigned, true), mb_strlen(preg_replace('/(\D)/', '', $percent_Assigned))), __LINE__);
        }
        $this->Percent_Assigned = $percent_Assigned;
        return $this;
    }
    /**
     * Get Actual_End_Date value
     * @return string|null
     */
    public function getActual_End_Date()
    {
        return $this->Actual_End_Date;
    }
    /**
     * Set Actual_End_Date value
     * @param string $actual_End_Date
     * @return \StructType\Proposed_Bonus_Plan_Assignment_DataType
     */
    public function setActual_End_Date($actual_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($actual_End_Date) && !is_string($actual_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actual_End_Date, true), gettype($actual_End_Date)), __LINE__);
        }
        $this->Actual_End_Date = $actual_End_Date;
        return $this;
    }
    /**
     * Get Fixed_for_Manage_by_Basis_Total value
     * @return bool|null
     */
    public function getFixed_for_Manage_by_Basis_Total()
    {
        return $this->Fixed_for_Manage_by_Basis_Total;
    }
    /**
     * Set Fixed_for_Manage_by_Basis_Total value
     * @param bool $fixed_for_Manage_by_Basis_Total
     * @return \StructType\Proposed_Bonus_Plan_Assignment_DataType
     */
    public function setFixed_for_Manage_by_Basis_Total($fixed_for_Manage_by_Basis_Total = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixed_for_Manage_by_Basis_Total) && !is_bool($fixed_for_Manage_by_Basis_Total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixed_for_Manage_by_Basis_Total, true), gettype($fixed_for_Manage_by_Basis_Total)), __LINE__);
        }
        $this->Fixed_for_Manage_by_Basis_Total = $fixed_for_Manage_by_Basis_Total;
        return $this;
    }
}
