<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pre-Hire_Resume_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the applicant's resume(s).
 * @subpackage Structs
 */
class Pre_Hire_Resume_DataType extends AbstractStructBase
{
    /**
     * The Resume
     * Meta information extracted from the WSDL
     * - documentation: The resume for an applicant.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Pre_Hire_Resume_Detail_DataType[]
     */
    public $Resume;
    /**
     * Constructor method for Pre-Hire_Resume_DataType
     * @uses Pre_Hire_Resume_DataType::setResume()
     * @param \StructType\Pre_Hire_Resume_Detail_DataType[] $resume
     */
    public function __construct(array $resume = array())
    {
        $this
            ->setResume($resume);
    }
    /**
     * Get Resume value
     * @return \StructType\Pre_Hire_Resume_Detail_DataType[]|null
     */
    public function getResume()
    {
        return $this->Resume;
    }
    /**
     * This method is responsible for validating the values passed to the setResume method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResume method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResumeForArrayConstraintsFromSetResume(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pre_Hire_Resume_DataTypeResumeItem) {
            // validation for constraint: itemType
            if (!$pre_Hire_Resume_DataTypeResumeItem instanceof \StructType\Pre_Hire_Resume_Detail_DataType) {
                $invalidValues[] = is_object($pre_Hire_Resume_DataTypeResumeItem) ? get_class($pre_Hire_Resume_DataTypeResumeItem) : sprintf('%s(%s)', gettype($pre_Hire_Resume_DataTypeResumeItem), var_export($pre_Hire_Resume_DataTypeResumeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resume property can only contain items of type \StructType\Pre_Hire_Resume_Detail_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resume value
     * @throws \InvalidArgumentException
     * @param \StructType\Pre_Hire_Resume_Detail_DataType[] $resume
     * @return \StructType\Pre_Hire_Resume_DataType
     */
    public function setResume(array $resume = array())
    {
        // validation for constraint: array
        if ('' !== ($resumeArrayErrorMessage = self::validateResumeForArrayConstraintsFromSetResume($resume))) {
            throw new \InvalidArgumentException($resumeArrayErrorMessage, __LINE__);
        }
        $this->Resume = $resume;
        return $this;
    }
    /**
     * Add item to Resume value
     * @throws \InvalidArgumentException
     * @param \StructType\Pre_Hire_Resume_Detail_DataType $item
     * @return \StructType\Pre_Hire_Resume_DataType
     */
    public function addToResume(\StructType\Pre_Hire_Resume_Detail_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pre_Hire_Resume_Detail_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resume property can only contain items of type \StructType\Pre_Hire_Resume_Detail_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resume[] = $item;
        return $this;
    }
}
