<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pre-Hire_Probation_Period_Review_LengthType StructType
 * Meta information extracted from the WSDL
 * - documentation: Probation Review Data
 * @subpackage Structs
 */
class Pre_Hire_Probation_Period_Review_LengthType extends AbstractStructBase
{
    /**
     * The Schedule
     * Meta information extracted from the WSDL
     * - documentation: Schedule
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 20
     * @var float
     */
    public $Schedule;
    /**
     * The Unit_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit Reference
     * @var \StructType\Pre_Hire_Probation_Period_UnitObjectType
     */
    public $Unit_Reference;
    /**
     * Constructor method for Pre-Hire_Probation_Period_Review_LengthType
     * @uses Pre_Hire_Probation_Period_Review_LengthType::setSchedule()
     * @uses Pre_Hire_Probation_Period_Review_LengthType::setUnit_Reference()
     * @param float $schedule
     * @param \StructType\Pre_Hire_Probation_Period_UnitObjectType $unit_Reference
     */
    public function __construct($schedule = null, \StructType\Pre_Hire_Probation_Period_UnitObjectType $unit_Reference = null)
    {
        $this
            ->setSchedule($schedule)
            ->setUnit_Reference($unit_Reference);
    }
    /**
     * Get Schedule value
     * @return float|null
     */
    public function getSchedule()
    {
        return $this->Schedule;
    }
    /**
     * Set Schedule value
     * @param float $schedule
     * @return \StructType\Pre_Hire_Probation_Period_Review_LengthType
     */
    public function setSchedule($schedule = null)
    {
        // validation for constraint: float
        if (!is_null($schedule) && !(is_float($schedule) || is_numeric($schedule))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($schedule, true), gettype($schedule)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($schedule) && mb_strlen(mb_substr($schedule, false !== mb_strpos($schedule, '.') ? mb_strpos($schedule, '.') + 1 : mb_strlen($schedule))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($schedule, true), mb_strlen(mb_substr($schedule, mb_strpos($schedule, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($schedule) && $schedule < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($schedule, true)), __LINE__);
        }
        // validation for constraint: totalDigits(20)
        if (!is_null($schedule) && mb_strlen(preg_replace('/(\D)/', '', $schedule)) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 20 digits, "%d" given', var_export($schedule, true), mb_strlen(preg_replace('/(\D)/', '', $schedule))), __LINE__);
        }
        $this->Schedule = $schedule;
        return $this;
    }
    /**
     * Get Unit_Reference value
     * @return \StructType\Pre_Hire_Probation_Period_UnitObjectType|null
     */
    public function getUnit_Reference()
    {
        return $this->Unit_Reference;
    }
    /**
     * Set Unit_Reference value
     * @param \StructType\Pre_Hire_Probation_Period_UnitObjectType $unit_Reference
     * @return \StructType\Pre_Hire_Probation_Period_Review_LengthType
     */
    public function setUnit_Reference(\StructType\Pre_Hire_Probation_Period_UnitObjectType $unit_Reference = null)
    {
        $this->Unit_Reference = $unit_Reference;
        return $this;
    }
}
