<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pre-Hire_Contract_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for a Pre-Hire Contract.
 * @subpackage Structs
 */
class Pre_Hire_Contract_Details_DataType extends AbstractStructBase
{
    /**
     * The Contract_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The contract type.
     * - minOccurs: 0
     * @var \StructType\Employee_Contract_TypeObjectType
     */
    public $Contract_Type_Reference;
    /**
     * The Employee_Contract_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: The contract reason defined in the Maintain Employee Contract Reasons task.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Employee_Contract_ReasonObjectType[]
     */
    public $Employee_Contract_Reason_Reference;
    /**
     * The Contract_ID
     * Meta information extracted from the WSDL
     * - documentation: The user-defined identifier for the employee contract. This value isn't always unique.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_ID;
    /**
     * The Contract_Description
     * Meta information extracted from the WSDL
     * - documentation: The Contract Description for the employee contract.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Description;
    /**
     * The Maximum_Weekly_Hours
     * Meta information extracted from the WSDL
     * - documentation: The Maximum Weekly Hours entered for this Employee Contract.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Maximum_Weekly_Hours;
    /**
     * The Minimum_Weekly_Hours
     * Meta information extracted from the WSDL
     * - documentation: The Minimum Weekly Hours entered for this Employee Contract.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Minimum_Weekly_Hours;
    /**
     * Constructor method for Pre-Hire_Contract_Details_DataType
     * @uses Pre_Hire_Contract_Details_DataType::setContract_Type_Reference()
     * @uses Pre_Hire_Contract_Details_DataType::setEmployee_Contract_Reason_Reference()
     * @uses Pre_Hire_Contract_Details_DataType::setContract_ID()
     * @uses Pre_Hire_Contract_Details_DataType::setContract_Description()
     * @uses Pre_Hire_Contract_Details_DataType::setMaximum_Weekly_Hours()
     * @uses Pre_Hire_Contract_Details_DataType::setMinimum_Weekly_Hours()
     * @param \StructType\Employee_Contract_TypeObjectType $contract_Type_Reference
     * @param \StructType\Employee_Contract_ReasonObjectType[] $employee_Contract_Reason_Reference
     * @param string $contract_ID
     * @param string $contract_Description
     * @param float $maximum_Weekly_Hours
     * @param float $minimum_Weekly_Hours
     */
    public function __construct(\StructType\Employee_Contract_TypeObjectType $contract_Type_Reference = null, array $employee_Contract_Reason_Reference = array(), $contract_ID = null, $contract_Description = null, $maximum_Weekly_Hours = null, $minimum_Weekly_Hours = null)
    {
        $this
            ->setContract_Type_Reference($contract_Type_Reference)
            ->setEmployee_Contract_Reason_Reference($employee_Contract_Reason_Reference)
            ->setContract_ID($contract_ID)
            ->setContract_Description($contract_Description)
            ->setMaximum_Weekly_Hours($maximum_Weekly_Hours)
            ->setMinimum_Weekly_Hours($minimum_Weekly_Hours);
    }
    /**
     * Get Contract_Type_Reference value
     * @return \StructType\Employee_Contract_TypeObjectType|null
     */
    public function getContract_Type_Reference()
    {
        return $this->Contract_Type_Reference;
    }
    /**
     * Set Contract_Type_Reference value
     * @param \StructType\Employee_Contract_TypeObjectType $contract_Type_Reference
     * @return \StructType\Pre_Hire_Contract_Details_DataType
     */
    public function setContract_Type_Reference(\StructType\Employee_Contract_TypeObjectType $contract_Type_Reference = null)
    {
        $this->Contract_Type_Reference = $contract_Type_Reference;
        return $this;
    }
    /**
     * Get Employee_Contract_Reason_Reference value
     * @return \StructType\Employee_Contract_ReasonObjectType[]|null
     */
    public function getEmployee_Contract_Reason_Reference()
    {
        return $this->Employee_Contract_Reason_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployee_Contract_Reason_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployee_Contract_Reason_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployee_Contract_Reason_ReferenceForArrayConstraintsFromSetEmployee_Contract_Reason_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pre_Hire_Contract_Details_DataTypeEmployee_Contract_Reason_ReferenceItem) {
            // validation for constraint: itemType
            if (!$pre_Hire_Contract_Details_DataTypeEmployee_Contract_Reason_ReferenceItem instanceof \StructType\Employee_Contract_ReasonObjectType) {
                $invalidValues[] = is_object($pre_Hire_Contract_Details_DataTypeEmployee_Contract_Reason_ReferenceItem) ? get_class($pre_Hire_Contract_Details_DataTypeEmployee_Contract_Reason_ReferenceItem) : sprintf('%s(%s)', gettype($pre_Hire_Contract_Details_DataTypeEmployee_Contract_Reason_ReferenceItem), var_export($pre_Hire_Contract_Details_DataTypeEmployee_Contract_Reason_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Employee_Contract_Reason_Reference property can only contain items of type \StructType\Employee_Contract_ReasonObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Employee_Contract_Reason_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Employee_Contract_ReasonObjectType[] $employee_Contract_Reason_Reference
     * @return \StructType\Pre_Hire_Contract_Details_DataType
     */
    public function setEmployee_Contract_Reason_Reference(array $employee_Contract_Reason_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($employee_Contract_Reason_ReferenceArrayErrorMessage = self::validateEmployee_Contract_Reason_ReferenceForArrayConstraintsFromSetEmployee_Contract_Reason_Reference($employee_Contract_Reason_Reference))) {
            throw new \InvalidArgumentException($employee_Contract_Reason_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Employee_Contract_Reason_Reference = $employee_Contract_Reason_Reference;
        return $this;
    }
    /**
     * Add item to Employee_Contract_Reason_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Employee_Contract_ReasonObjectType $item
     * @return \StructType\Pre_Hire_Contract_Details_DataType
     */
    public function addToEmployee_Contract_Reason_Reference(\StructType\Employee_Contract_ReasonObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Employee_Contract_ReasonObjectType) {
            throw new \InvalidArgumentException(sprintf('The Employee_Contract_Reason_Reference property can only contain items of type \StructType\Employee_Contract_ReasonObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Employee_Contract_Reason_Reference[] = $item;
        return $this;
    }
    /**
     * Get Contract_ID value
     * @return string|null
     */
    public function getContract_ID()
    {
        return $this->Contract_ID;
    }
    /**
     * Set Contract_ID value
     * @param string $contract_ID
     * @return \StructType\Pre_Hire_Contract_Details_DataType
     */
    public function setContract_ID($contract_ID = null)
    {
        // validation for constraint: string
        if (!is_null($contract_ID) && !is_string($contract_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_ID, true), gettype($contract_ID)), __LINE__);
        }
        $this->Contract_ID = $contract_ID;
        return $this;
    }
    /**
     * Get Contract_Description value
     * @return string|null
     */
    public function getContract_Description()
    {
        return $this->Contract_Description;
    }
    /**
     * Set Contract_Description value
     * @param string $contract_Description
     * @return \StructType\Pre_Hire_Contract_Details_DataType
     */
    public function setContract_Description($contract_Description = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Description) && !is_string($contract_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Description, true), gettype($contract_Description)), __LINE__);
        }
        $this->Contract_Description = $contract_Description;
        return $this;
    }
    /**
     * Get Maximum_Weekly_Hours value
     * @return float|null
     */
    public function getMaximum_Weekly_Hours()
    {
        return $this->Maximum_Weekly_Hours;
    }
    /**
     * Set Maximum_Weekly_Hours value
     * @param float $maximum_Weekly_Hours
     * @return \StructType\Pre_Hire_Contract_Details_DataType
     */
    public function setMaximum_Weekly_Hours($maximum_Weekly_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($maximum_Weekly_Hours) && !(is_float($maximum_Weekly_Hours) || is_numeric($maximum_Weekly_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximum_Weekly_Hours, true), gettype($maximum_Weekly_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($maximum_Weekly_Hours) && mb_strlen(mb_substr($maximum_Weekly_Hours, false !== mb_strpos($maximum_Weekly_Hours, '.') ? mb_strpos($maximum_Weekly_Hours, '.') + 1 : mb_strlen($maximum_Weekly_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($maximum_Weekly_Hours, true), mb_strlen(mb_substr($maximum_Weekly_Hours, mb_strpos($maximum_Weekly_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($maximum_Weekly_Hours) && $maximum_Weekly_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($maximum_Weekly_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($maximum_Weekly_Hours) && mb_strlen(preg_replace('/(\D)/', '', $maximum_Weekly_Hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($maximum_Weekly_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $maximum_Weekly_Hours))), __LINE__);
        }
        $this->Maximum_Weekly_Hours = $maximum_Weekly_Hours;
        return $this;
    }
    /**
     * Get Minimum_Weekly_Hours value
     * @return float|null
     */
    public function getMinimum_Weekly_Hours()
    {
        return $this->Minimum_Weekly_Hours;
    }
    /**
     * Set Minimum_Weekly_Hours value
     * @param float $minimum_Weekly_Hours
     * @return \StructType\Pre_Hire_Contract_Details_DataType
     */
    public function setMinimum_Weekly_Hours($minimum_Weekly_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($minimum_Weekly_Hours) && !(is_float($minimum_Weekly_Hours) || is_numeric($minimum_Weekly_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum_Weekly_Hours, true), gettype($minimum_Weekly_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($minimum_Weekly_Hours) && mb_strlen(mb_substr($minimum_Weekly_Hours, false !== mb_strpos($minimum_Weekly_Hours, '.') ? mb_strpos($minimum_Weekly_Hours, '.') + 1 : mb_strlen($minimum_Weekly_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($minimum_Weekly_Hours, true), mb_strlen(mb_substr($minimum_Weekly_Hours, mb_strpos($minimum_Weekly_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($minimum_Weekly_Hours) && $minimum_Weekly_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($minimum_Weekly_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($minimum_Weekly_Hours) && mb_strlen(preg_replace('/(\D)/', '', $minimum_Weekly_Hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($minimum_Weekly_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $minimum_Weekly_Hours))), __LINE__);
        }
        $this->Minimum_Weekly_Hours = $minimum_Weekly_Hours;
        return $this;
    }
}
