<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Post_Job_Business_Process_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The chosen Job Posting Site can only have one Job Post Event in progress at a time. | Wrapper for Post Job data.
 * @subpackage Structs
 */
class Post_Job_Business_Process_DataType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Job Requisition that is being posted to.
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Job_Posting_Site_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper for the Job Posting Site. Each row is a Job Posting for the Job Requisition.
     * - maxOccurs: unbounded
     * @var \StructType\Job_Posting_Site_DataType[]
     */
    public $Job_Posting_Site_Data;
    /**
     * Constructor method for Post_Job_Business_Process_DataType
     * @uses Post_Job_Business_Process_DataType::setJob_Requisition_Reference()
     * @uses Post_Job_Business_Process_DataType::setJob_Posting_Site_Data()
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @param \StructType\Job_Posting_Site_DataType[] $job_Posting_Site_Data
     */
    public function __construct(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null, array $job_Posting_Site_Data = array())
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setJob_Posting_Site_Data($job_Posting_Site_Data);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Post_Job_Business_Process_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Job_Posting_Site_Data value
     * @return \StructType\Job_Posting_Site_DataType[]|null
     */
    public function getJob_Posting_Site_Data()
    {
        return $this->Job_Posting_Site_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Posting_Site_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Site_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Posting_Site_DataForArrayConstraintsFromSetJob_Posting_Site_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $post_Job_Business_Process_DataTypeJob_Posting_Site_DataItem) {
            // validation for constraint: itemType
            if (!$post_Job_Business_Process_DataTypeJob_Posting_Site_DataItem instanceof \StructType\Job_Posting_Site_DataType) {
                $invalidValues[] = is_object($post_Job_Business_Process_DataTypeJob_Posting_Site_DataItem) ? get_class($post_Job_Business_Process_DataTypeJob_Posting_Site_DataItem) : sprintf('%s(%s)', gettype($post_Job_Business_Process_DataTypeJob_Posting_Site_DataItem), var_export($post_Job_Business_Process_DataTypeJob_Posting_Site_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Posting_Site_Data property can only contain items of type \StructType\Job_Posting_Site_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Posting_Site_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_Site_DataType[] $job_Posting_Site_Data
     * @return \StructType\Post_Job_Business_Process_DataType
     */
    public function setJob_Posting_Site_Data(array $job_Posting_Site_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Posting_Site_DataArrayErrorMessage = self::validateJob_Posting_Site_DataForArrayConstraintsFromSetJob_Posting_Site_Data($job_Posting_Site_Data))) {
            throw new \InvalidArgumentException($job_Posting_Site_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Posting_Site_Data = $job_Posting_Site_Data;
        return $this;
    }
    /**
     * Add item to Job_Posting_Site_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_Site_DataType $item
     * @return \StructType\Post_Job_Business_Process_DataType
     */
    public function addToJob_Posting_Site_Data(\StructType\Job_Posting_Site_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Posting_Site_DataType) {
            throw new \InvalidArgumentException(sprintf('The Job_Posting_Site_Data property can only contain items of type \StructType\Job_Posting_Site_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Posting_Site_Data[] = $item;
        return $this;
    }
}
