<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Positions_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data on positions related to the job requisition.
 * @subpackage Structs
 */
class Positions_DataType extends AbstractStructBase
{
    /**
     * The Position_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier to a position related to the job requisition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Position_GroupObjectType[]
     */
    public $Position_Reference;
    /**
     * Constructor method for Positions_DataType
     * @uses Positions_DataType::setPosition_Reference()
     * @param \StructType\Position_GroupObjectType[] $position_Reference
     */
    public function __construct(array $position_Reference = array())
    {
        $this
            ->setPosition_Reference($position_Reference);
    }
    /**
     * Get Position_Reference value
     * @return \StructType\Position_GroupObjectType[]|null
     */
    public function getPosition_Reference()
    {
        return $this->Position_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePosition_ReferenceForArrayConstraintsFromSetPosition_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $positions_DataTypePosition_ReferenceItem) {
            // validation for constraint: itemType
            if (!$positions_DataTypePosition_ReferenceItem instanceof \StructType\Position_GroupObjectType) {
                $invalidValues[] = is_object($positions_DataTypePosition_ReferenceItem) ? get_class($positions_DataTypePosition_ReferenceItem) : sprintf('%s(%s)', gettype($positions_DataTypePosition_ReferenceItem), var_export($positions_DataTypePosition_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Position_Reference property can only contain items of type \StructType\Position_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Position_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_GroupObjectType[] $position_Reference
     * @return \StructType\Positions_DataType
     */
    public function setPosition_Reference(array $position_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($position_ReferenceArrayErrorMessage = self::validatePosition_ReferenceForArrayConstraintsFromSetPosition_Reference($position_Reference))) {
            throw new \InvalidArgumentException($position_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Position_Reference = $position_Reference;
        return $this;
    }
    /**
     * Add item to Position_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_GroupObjectType $item
     * @return \StructType\Positions_DataType
     */
    public function addToPosition_Reference(\StructType\Position_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Position_Reference property can only contain items of type \StructType\Position_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Position_Reference[] = $item;
        return $this;
    }
}
