<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the Request References element to retrieve a specific instance(s) of Position and its associated data.
 * @subpackage Structs
 */
class Position_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Positions_Reference
     * Meta information extracted from the WSDL
     * - documentation: An unique identifier for a Position requested.
     * - maxOccurs: unbounded
     * @var \StructType\Position_ElementObjectType[]
     */
    public $Positions_Reference;
    /**
     * The Skip_Non_Existing_Instances
     * @var bool
     */
    public $Skip_Non_Existing_Instances;
    /**
     * The Ignore_Invalid_References
     * @var bool
     */
    public $Ignore_Invalid_References;
    /**
     * Constructor method for Position_Request_ReferencesType
     * @uses Position_Request_ReferencesType::setPositions_Reference()
     * @uses Position_Request_ReferencesType::setSkip_Non_Existing_Instances()
     * @uses Position_Request_ReferencesType::setIgnore_Invalid_References()
     * @param \StructType\Position_ElementObjectType[] $positions_Reference
     * @param bool $skip_Non_Existing_Instances
     * @param bool $ignore_Invalid_References
     */
    public function __construct(array $positions_Reference = array(), $skip_Non_Existing_Instances = null, $ignore_Invalid_References = null)
    {
        $this
            ->setPositions_Reference($positions_Reference)
            ->setSkip_Non_Existing_Instances($skip_Non_Existing_Instances)
            ->setIgnore_Invalid_References($ignore_Invalid_References);
    }
    /**
     * Get Positions_Reference value
     * @return \StructType\Position_ElementObjectType[]|null
     */
    public function getPositions_Reference()
    {
        return $this->Positions_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPositions_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPositions_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositions_ReferenceForArrayConstraintsFromSetPositions_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $position_Request_ReferencesTypePositions_ReferenceItem) {
            // validation for constraint: itemType
            if (!$position_Request_ReferencesTypePositions_ReferenceItem instanceof \StructType\Position_ElementObjectType) {
                $invalidValues[] = is_object($position_Request_ReferencesTypePositions_ReferenceItem) ? get_class($position_Request_ReferencesTypePositions_ReferenceItem) : sprintf('%s(%s)', gettype($position_Request_ReferencesTypePositions_ReferenceItem), var_export($position_Request_ReferencesTypePositions_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Positions_Reference property can only contain items of type \StructType\Position_ElementObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Positions_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_ElementObjectType[] $positions_Reference
     * @return \StructType\Position_Request_ReferencesType
     */
    public function setPositions_Reference(array $positions_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($positions_ReferenceArrayErrorMessage = self::validatePositions_ReferenceForArrayConstraintsFromSetPositions_Reference($positions_Reference))) {
            throw new \InvalidArgumentException($positions_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Positions_Reference = $positions_Reference;
        return $this;
    }
    /**
     * Add item to Positions_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_ElementObjectType $item
     * @return \StructType\Position_Request_ReferencesType
     */
    public function addToPositions_Reference(\StructType\Position_ElementObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position_ElementObjectType) {
            throw new \InvalidArgumentException(sprintf('The Positions_Reference property can only contain items of type \StructType\Position_ElementObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Positions_Reference[] = $item;
        return $this;
    }
    /**
     * Get Skip_Non_Existing_Instances value
     * @return bool|null
     */
    public function getSkip_Non_Existing_Instances()
    {
        return $this->Skip_Non_Existing_Instances;
    }
    /**
     * Set Skip_Non_Existing_Instances value
     * @param bool $skip_Non_Existing_Instances
     * @return \StructType\Position_Request_ReferencesType
     */
    public function setSkip_Non_Existing_Instances($skip_Non_Existing_Instances = null)
    {
        // validation for constraint: boolean
        if (!is_null($skip_Non_Existing_Instances) && !is_bool($skip_Non_Existing_Instances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skip_Non_Existing_Instances, true), gettype($skip_Non_Existing_Instances)), __LINE__);
        }
        $this->Skip_Non_Existing_Instances = $skip_Non_Existing_Instances;
        return $this;
    }
    /**
     * Get Ignore_Invalid_References value
     * @return bool|null
     */
    public function getIgnore_Invalid_References()
    {
        return $this->Ignore_Invalid_References;
    }
    /**
     * Set Ignore_Invalid_References value
     * @param bool $ignore_Invalid_References
     * @return \StructType\Position_Request_ReferencesType
     */
    public function setIgnore_Invalid_References($ignore_Invalid_References = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignore_Invalid_References) && !is_bool($ignore_Invalid_References)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignore_Invalid_References, true), gettype($ignore_Invalid_References)), __LINE__);
        }
        $this->Ignore_Invalid_References = $ignore_Invalid_References;
        return $this;
    }
}
