<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Package_Reference_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of the Background Check Package.
 * @subpackage Structs
 */
class Package_Reference_DataType extends AbstractStructBase
{
    /**
     * The Package_Reference
     * Meta information extracted from the WSDL
     * - documentation: Verify the provided Package the same Background Check Package that the event uses. If the criteria bring up zero or more than one event, we have bigger problems to deal with so don't fire the validation. | Reference to the Background
     * Check Package.
     * - minOccurs: 0
     * @var \StructType\Background_Check_PackageObjectType
     */
    public $Package_Reference;
    /**
     * The Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the status for the Background Check Package.
     * @var \StructType\Background_Check_StatusObjectType
     */
    public $Status_Reference;
    /**
     * The Results_URL
     * Meta information extracted from the WSDL
     * - documentation: URL to the external provider's results.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Results_URL;
    /**
     * The Package_Comment
     * Meta information extracted from the WSDL
     * - documentation: An optional comment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Package_Comment;
    /**
     * The Package_Name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $Package_Name;
    /**
     * The Package_Description
     * Meta information extracted from the WSDL
     * - documentation: The description of the Background Check Package. The description cannot be updated using this operation.
     * @var string
     */
    public $Package_Description;
    /**
     * Constructor method for Package_Reference_DataType
     * @uses Package_Reference_DataType::setPackage_Reference()
     * @uses Package_Reference_DataType::setStatus_Reference()
     * @uses Package_Reference_DataType::setResults_URL()
     * @uses Package_Reference_DataType::setPackage_Comment()
     * @uses Package_Reference_DataType::setPackage_Name()
     * @uses Package_Reference_DataType::setPackage_Description()
     * @param \StructType\Background_Check_PackageObjectType $package_Reference
     * @param \StructType\Background_Check_StatusObjectType $status_Reference
     * @param string $results_URL
     * @param string $package_Comment
     * @param string $package_Name
     * @param string $package_Description
     */
    public function __construct(\StructType\Background_Check_PackageObjectType $package_Reference = null, \StructType\Background_Check_StatusObjectType $status_Reference = null, $results_URL = null, $package_Comment = null, $package_Name = null, $package_Description = null)
    {
        $this
            ->setPackage_Reference($package_Reference)
            ->setStatus_Reference($status_Reference)
            ->setResults_URL($results_URL)
            ->setPackage_Comment($package_Comment)
            ->setPackage_Name($package_Name)
            ->setPackage_Description($package_Description);
    }
    /**
     * Get Package_Reference value
     * @return \StructType\Background_Check_PackageObjectType|null
     */
    public function getPackage_Reference()
    {
        return $this->Package_Reference;
    }
    /**
     * Set Package_Reference value
     * @param \StructType\Background_Check_PackageObjectType $package_Reference
     * @return \StructType\Package_Reference_DataType
     */
    public function setPackage_Reference(\StructType\Background_Check_PackageObjectType $package_Reference = null)
    {
        $this->Package_Reference = $package_Reference;
        return $this;
    }
    /**
     * Get Status_Reference value
     * @return \StructType\Background_Check_StatusObjectType|null
     */
    public function getStatus_Reference()
    {
        return $this->Status_Reference;
    }
    /**
     * Set Status_Reference value
     * @param \StructType\Background_Check_StatusObjectType $status_Reference
     * @return \StructType\Package_Reference_DataType
     */
    public function setStatus_Reference(\StructType\Background_Check_StatusObjectType $status_Reference = null)
    {
        $this->Status_Reference = $status_Reference;
        return $this;
    }
    /**
     * Get Results_URL value
     * @return string|null
     */
    public function getResults_URL()
    {
        return $this->Results_URL;
    }
    /**
     * Set Results_URL value
     * @param string $results_URL
     * @return \StructType\Package_Reference_DataType
     */
    public function setResults_URL($results_URL = null)
    {
        // validation for constraint: string
        if (!is_null($results_URL) && !is_string($results_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($results_URL, true), gettype($results_URL)), __LINE__);
        }
        $this->Results_URL = $results_URL;
        return $this;
    }
    /**
     * Get Package_Comment value
     * @return string|null
     */
    public function getPackage_Comment()
    {
        return $this->Package_Comment;
    }
    /**
     * Set Package_Comment value
     * @param string $package_Comment
     * @return \StructType\Package_Reference_DataType
     */
    public function setPackage_Comment($package_Comment = null)
    {
        // validation for constraint: string
        if (!is_null($package_Comment) && !is_string($package_Comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($package_Comment, true), gettype($package_Comment)), __LINE__);
        }
        $this->Package_Comment = $package_Comment;
        return $this;
    }
    /**
     * Get Package_Name value
     * @return string|null
     */
    public function getPackage_Name()
    {
        return $this->Package_Name;
    }
    /**
     * Set Package_Name value
     * @param string $package_Name
     * @return \StructType\Package_Reference_DataType
     */
    public function setPackage_Name($package_Name = null)
    {
        // validation for constraint: string
        if (!is_null($package_Name) && !is_string($package_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($package_Name, true), gettype($package_Name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($package_Name) && mb_strlen($package_Name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($package_Name)), __LINE__);
        }
        $this->Package_Name = $package_Name;
        return $this;
    }
    /**
     * Get Package_Description value
     * @return string|null
     */
    public function getPackage_Description()
    {
        return $this->Package_Description;
    }
    /**
     * Set Package_Description value
     * @param string $package_Description
     * @return \StructType\Package_Reference_DataType
     */
    public function setPackage_Description($package_Description = null)
    {
        // validation for constraint: string
        if (!is_null($package_Description) && !is_string($package_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($package_Description, true), gettype($package_Description)), __LINE__);
        }
        $this->Package_Description = $package_Description;
        return $this;
    }
}
