<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Organization_Assignments_for_Job_Requisition_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the default organization assignments for this job requisition.
 * @subpackage Structs
 */
class Organization_Assignments_for_Job_Requisition_DataType extends AbstractStructBase
{
    /**
     * The Company_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The identifier for Company.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Assignment_Reference;
    /**
     * The Cost_Center_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The identifier for Cost Center.
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType
     */
    public $Cost_Center_Assignment_Reference;
    /**
     * The Region_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The identifier for Region.
     * - minOccurs: 0
     * @var \StructType\RegionObjectType
     */
    public $Region_Assignment_Reference;
    /**
     * The Business_Unit_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The identifier for Business Unit.
     * - minOccurs: 0
     * @var \StructType\Business_UnitObjectType
     */
    public $Business_Unit_Assignment_Reference;
    /**
     * The Grant_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The identifier for Grant.
     * - minOccurs: 0
     * @var \StructType\GrantObjectType
     */
    public $Grant_Assignment_Reference;
    /**
     * The Program_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The identifier for Program.
     * - minOccurs: 0
     * @var \StructType\ProgramObjectType
     */
    public $Program_Assignment_Reference;
    /**
     * The Fund_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The identifier for Fund.
     * - minOccurs: 0
     * @var \StructType\FundObjectType
     */
    public $Fund_Assignment_Reference;
    /**
     * The Gift_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The identifier for Gift.
     * - minOccurs: 0
     * @var \StructType\GiftObjectType
     */
    public $Gift_Assignment_Reference;
    /**
     * The Custom_Organization_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The identifier for Custom Organization.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType[]
     */
    public $Custom_Organization_Assignment_Reference;
    /**
     * Constructor method for Organization_Assignments_for_Job_Requisition_DataType
     * @uses Organization_Assignments_for_Job_Requisition_DataType::setCompany_Assignment_Reference()
     * @uses Organization_Assignments_for_Job_Requisition_DataType::setCost_Center_Assignment_Reference()
     * @uses Organization_Assignments_for_Job_Requisition_DataType::setRegion_Assignment_Reference()
     * @uses Organization_Assignments_for_Job_Requisition_DataType::setBusiness_Unit_Assignment_Reference()
     * @uses Organization_Assignments_for_Job_Requisition_DataType::setGrant_Assignment_Reference()
     * @uses Organization_Assignments_for_Job_Requisition_DataType::setProgram_Assignment_Reference()
     * @uses Organization_Assignments_for_Job_Requisition_DataType::setFund_Assignment_Reference()
     * @uses Organization_Assignments_for_Job_Requisition_DataType::setGift_Assignment_Reference()
     * @uses Organization_Assignments_for_Job_Requisition_DataType::setCustom_Organization_Assignment_Reference()
     * @param \StructType\CompanyObjectType $company_Assignment_Reference
     * @param \StructType\Cost_CenterObjectType $cost_Center_Assignment_Reference
     * @param \StructType\RegionObjectType $region_Assignment_Reference
     * @param \StructType\Business_UnitObjectType $business_Unit_Assignment_Reference
     * @param \StructType\GrantObjectType $grant_Assignment_Reference
     * @param \StructType\ProgramObjectType $program_Assignment_Reference
     * @param \StructType\FundObjectType $fund_Assignment_Reference
     * @param \StructType\GiftObjectType $gift_Assignment_Reference
     * @param \StructType\Custom_OrganizationObjectType[] $custom_Organization_Assignment_Reference
     */
    public function __construct(\StructType\CompanyObjectType $company_Assignment_Reference = null, \StructType\Cost_CenterObjectType $cost_Center_Assignment_Reference = null, \StructType\RegionObjectType $region_Assignment_Reference = null, \StructType\Business_UnitObjectType $business_Unit_Assignment_Reference = null, \StructType\GrantObjectType $grant_Assignment_Reference = null, \StructType\ProgramObjectType $program_Assignment_Reference = null, \StructType\FundObjectType $fund_Assignment_Reference = null, \StructType\GiftObjectType $gift_Assignment_Reference = null, array $custom_Organization_Assignment_Reference = array())
    {
        $this
            ->setCompany_Assignment_Reference($company_Assignment_Reference)
            ->setCost_Center_Assignment_Reference($cost_Center_Assignment_Reference)
            ->setRegion_Assignment_Reference($region_Assignment_Reference)
            ->setBusiness_Unit_Assignment_Reference($business_Unit_Assignment_Reference)
            ->setGrant_Assignment_Reference($grant_Assignment_Reference)
            ->setProgram_Assignment_Reference($program_Assignment_Reference)
            ->setFund_Assignment_Reference($fund_Assignment_Reference)
            ->setGift_Assignment_Reference($gift_Assignment_Reference)
            ->setCustom_Organization_Assignment_Reference($custom_Organization_Assignment_Reference);
    }
    /**
     * Get Company_Assignment_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Assignment_Reference()
    {
        return $this->Company_Assignment_Reference;
    }
    /**
     * Set Company_Assignment_Reference value
     * @param \StructType\CompanyObjectType $company_Assignment_Reference
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType
     */
    public function setCompany_Assignment_Reference(\StructType\CompanyObjectType $company_Assignment_Reference = null)
    {
        $this->Company_Assignment_Reference = $company_Assignment_Reference;
        return $this;
    }
    /**
     * Get Cost_Center_Assignment_Reference value
     * @return \StructType\Cost_CenterObjectType|null
     */
    public function getCost_Center_Assignment_Reference()
    {
        return $this->Cost_Center_Assignment_Reference;
    }
    /**
     * Set Cost_Center_Assignment_Reference value
     * @param \StructType\Cost_CenterObjectType $cost_Center_Assignment_Reference
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType
     */
    public function setCost_Center_Assignment_Reference(\StructType\Cost_CenterObjectType $cost_Center_Assignment_Reference = null)
    {
        $this->Cost_Center_Assignment_Reference = $cost_Center_Assignment_Reference;
        return $this;
    }
    /**
     * Get Region_Assignment_Reference value
     * @return \StructType\RegionObjectType|null
     */
    public function getRegion_Assignment_Reference()
    {
        return $this->Region_Assignment_Reference;
    }
    /**
     * Set Region_Assignment_Reference value
     * @param \StructType\RegionObjectType $region_Assignment_Reference
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType
     */
    public function setRegion_Assignment_Reference(\StructType\RegionObjectType $region_Assignment_Reference = null)
    {
        $this->Region_Assignment_Reference = $region_Assignment_Reference;
        return $this;
    }
    /**
     * Get Business_Unit_Assignment_Reference value
     * @return \StructType\Business_UnitObjectType|null
     */
    public function getBusiness_Unit_Assignment_Reference()
    {
        return $this->Business_Unit_Assignment_Reference;
    }
    /**
     * Set Business_Unit_Assignment_Reference value
     * @param \StructType\Business_UnitObjectType $business_Unit_Assignment_Reference
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType
     */
    public function setBusiness_Unit_Assignment_Reference(\StructType\Business_UnitObjectType $business_Unit_Assignment_Reference = null)
    {
        $this->Business_Unit_Assignment_Reference = $business_Unit_Assignment_Reference;
        return $this;
    }
    /**
     * Get Grant_Assignment_Reference value
     * @return \StructType\GrantObjectType|null
     */
    public function getGrant_Assignment_Reference()
    {
        return $this->Grant_Assignment_Reference;
    }
    /**
     * Set Grant_Assignment_Reference value
     * @param \StructType\GrantObjectType $grant_Assignment_Reference
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType
     */
    public function setGrant_Assignment_Reference(\StructType\GrantObjectType $grant_Assignment_Reference = null)
    {
        $this->Grant_Assignment_Reference = $grant_Assignment_Reference;
        return $this;
    }
    /**
     * Get Program_Assignment_Reference value
     * @return \StructType\ProgramObjectType|null
     */
    public function getProgram_Assignment_Reference()
    {
        return $this->Program_Assignment_Reference;
    }
    /**
     * Set Program_Assignment_Reference value
     * @param \StructType\ProgramObjectType $program_Assignment_Reference
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType
     */
    public function setProgram_Assignment_Reference(\StructType\ProgramObjectType $program_Assignment_Reference = null)
    {
        $this->Program_Assignment_Reference = $program_Assignment_Reference;
        return $this;
    }
    /**
     * Get Fund_Assignment_Reference value
     * @return \StructType\FundObjectType|null
     */
    public function getFund_Assignment_Reference()
    {
        return $this->Fund_Assignment_Reference;
    }
    /**
     * Set Fund_Assignment_Reference value
     * @param \StructType\FundObjectType $fund_Assignment_Reference
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType
     */
    public function setFund_Assignment_Reference(\StructType\FundObjectType $fund_Assignment_Reference = null)
    {
        $this->Fund_Assignment_Reference = $fund_Assignment_Reference;
        return $this;
    }
    /**
     * Get Gift_Assignment_Reference value
     * @return \StructType\GiftObjectType|null
     */
    public function getGift_Assignment_Reference()
    {
        return $this->Gift_Assignment_Reference;
    }
    /**
     * Set Gift_Assignment_Reference value
     * @param \StructType\GiftObjectType $gift_Assignment_Reference
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType
     */
    public function setGift_Assignment_Reference(\StructType\GiftObjectType $gift_Assignment_Reference = null)
    {
        $this->Gift_Assignment_Reference = $gift_Assignment_Reference;
        return $this;
    }
    /**
     * Get Custom_Organization_Assignment_Reference value
     * @return \StructType\Custom_OrganizationObjectType[]|null
     */
    public function getCustom_Organization_Assignment_Reference()
    {
        return $this->Custom_Organization_Assignment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCustom_Organization_Assignment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustom_Organization_Assignment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustom_Organization_Assignment_ReferenceForArrayConstraintsFromSetCustom_Organization_Assignment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organization_Assignments_for_Job_Requisition_DataTypeCustom_Organization_Assignment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$organization_Assignments_for_Job_Requisition_DataTypeCustom_Organization_Assignment_ReferenceItem instanceof \StructType\Custom_OrganizationObjectType) {
                $invalidValues[] = is_object($organization_Assignments_for_Job_Requisition_DataTypeCustom_Organization_Assignment_ReferenceItem) ? get_class($organization_Assignments_for_Job_Requisition_DataTypeCustom_Organization_Assignment_ReferenceItem) : sprintf('%s(%s)', gettype($organization_Assignments_for_Job_Requisition_DataTypeCustom_Organization_Assignment_ReferenceItem), var_export($organization_Assignments_for_Job_Requisition_DataTypeCustom_Organization_Assignment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Custom_Organization_Assignment_Reference property can only contain items of type \StructType\Custom_OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Custom_Organization_Assignment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_OrganizationObjectType[] $custom_Organization_Assignment_Reference
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType
     */
    public function setCustom_Organization_Assignment_Reference(array $custom_Organization_Assignment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($custom_Organization_Assignment_ReferenceArrayErrorMessage = self::validateCustom_Organization_Assignment_ReferenceForArrayConstraintsFromSetCustom_Organization_Assignment_Reference($custom_Organization_Assignment_Reference))) {
            throw new \InvalidArgumentException($custom_Organization_Assignment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Custom_Organization_Assignment_Reference = $custom_Organization_Assignment_Reference;
        return $this;
    }
    /**
     * Add item to Custom_Organization_Assignment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_OrganizationObjectType $item
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType
     */
    public function addToCustom_Organization_Assignment_Reference(\StructType\Custom_OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Custom_OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Custom_Organization_Assignment_Reference property can only contain items of type \StructType\Custom_OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Custom_Organization_Assignment_Reference[] = $item;
        return $this;
    }
}
