<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for One-Time_Payment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data Element that contains the one-time payment information.
 * @subpackage Structs
 */
class One_Time_Payment_DataType extends AbstractStructBase
{
    /**
     * The One_Time_Payment_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: One-time payment plan for the one-time payment. If Multiple One-Time Payments is enabled on the Edit Tenant Setup - HCM task, there can be multiple plans.
     * @var \StructType\One_Time_Payment_PlanObjectType
     */
    public $One_Time_Payment_Plan_Reference;
    /**
     * The Scheduled_Payment_Date
     * Meta information extracted from the WSDL
     * - documentation: Date the employee will receive the one-time payment. Workday defaults the effective date if a Scheduled Payment Date is not provided. Multiple One-Time Payments must be enabled on the Edit Tenant Setup - HCM task.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Scheduled_Payment_Date;
    /**
     * The Clawback_Date
     * Meta information extracted from the WSDL
     * - documentation: Enter a clawback date for this one-time payment. Payment is no longer eligible for recovery after this date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Clawback_Date;
    /**
     * The Coverage_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start date of the period a FLSA-eligible wage increase applies.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Coverage_Start_Date;
    /**
     * The Coverage_End_Date
     * Meta information extracted from the WSDL
     * - documentation: End date of the period a FLSA-eligible wage increase applies.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Coverage_End_Date;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount of the one time payment. Decimal precision of the amount must match the currency. This is mutually exclusive with the percent. | Amount for the allowance plan. Decimal precision of the amount must match the currency. Required
     * if amount allowance plan is entered and there is no default amount for the plan. Mutually exclusive from the percent. | Amount for the salary or hourly plan assignment. Required if the plan has no default amount. Decimal precision of the amount must
     * match the currency. Mutually exclusive from the percent.
     * - base: xsd:decimal
     * - choice: Amount | Percent
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Amount;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: Percent of the calculation basis defined on the one-time payment plan. Workday calculates the amount based on this percent. This is mutually exclusive with the amount. | Percent for the allowance plan. Required if percent allowance
     * plan is entered and there is no default percent for the plan. The amount will be calculated using this percent. Mutually exclusive from the amount.
     * - base: xsd:decimal
     * - choice: Amount | Percent
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Percent;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency for the one-time payment. Defaults to the one-time payment plan currency default if not provided.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comment for the one-time payment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Do_Not_Pay
     * Meta information extracted from the WSDL
     * - documentation: If True, Workday Payroll doesn't process this one-time payment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Do_Not_Pay;
    /**
     * The Costing_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Optional: Specify a costing company to charge this one-time payment to. Intercompany Accounting must be enabled in Edit Tenant Setup - Payroll.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Costing_Company_Reference;
    /**
     * The One_Time_Payment_Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worktags associated with this one-time payment. If provided, the worktag type must match that of the Worktag Balancing Configuration unless the employee has that organizational assignment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tenanted_Payroll_WorktagObjectType[]
     */
    public $One_Time_Payment_Worktags_Reference;
    /**
     * Constructor method for One-Time_Payment_DataType
     * @uses One_Time_Payment_DataType::setOne_Time_Payment_Plan_Reference()
     * @uses One_Time_Payment_DataType::setScheduled_Payment_Date()
     * @uses One_Time_Payment_DataType::setClawback_Date()
     * @uses One_Time_Payment_DataType::setCoverage_Start_Date()
     * @uses One_Time_Payment_DataType::setCoverage_End_Date()
     * @uses One_Time_Payment_DataType::setAmount()
     * @uses One_Time_Payment_DataType::setPercent()
     * @uses One_Time_Payment_DataType::setCurrency_Reference()
     * @uses One_Time_Payment_DataType::setComment()
     * @uses One_Time_Payment_DataType::setDo_Not_Pay()
     * @uses One_Time_Payment_DataType::setCosting_Company_Reference()
     * @uses One_Time_Payment_DataType::setOne_Time_Payment_Worktags_Reference()
     * @param \StructType\One_Time_Payment_PlanObjectType $one_Time_Payment_Plan_Reference
     * @param string $scheduled_Payment_Date
     * @param string $clawback_Date
     * @param string $coverage_Start_Date
     * @param string $coverage_End_Date
     * @param float $amount
     * @param float $percent
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $comment
     * @param bool $do_Not_Pay
     * @param \StructType\CompanyObjectType $costing_Company_Reference
     * @param \StructType\Tenanted_Payroll_WorktagObjectType[] $one_Time_Payment_Worktags_Reference
     */
    public function __construct(\StructType\One_Time_Payment_PlanObjectType $one_Time_Payment_Plan_Reference = null, $scheduled_Payment_Date = null, $clawback_Date = null, $coverage_Start_Date = null, $coverage_End_Date = null, $amount = null, $percent = null, \StructType\CurrencyObjectType $currency_Reference = null, $comment = null, $do_Not_Pay = null, \StructType\CompanyObjectType $costing_Company_Reference = null, array $one_Time_Payment_Worktags_Reference = array())
    {
        $this
            ->setOne_Time_Payment_Plan_Reference($one_Time_Payment_Plan_Reference)
            ->setScheduled_Payment_Date($scheduled_Payment_Date)
            ->setClawback_Date($clawback_Date)
            ->setCoverage_Start_Date($coverage_Start_Date)
            ->setCoverage_End_Date($coverage_End_Date)
            ->setAmount($amount)
            ->setPercent($percent)
            ->setCurrency_Reference($currency_Reference)
            ->setComment($comment)
            ->setDo_Not_Pay($do_Not_Pay)
            ->setCosting_Company_Reference($costing_Company_Reference)
            ->setOne_Time_Payment_Worktags_Reference($one_Time_Payment_Worktags_Reference);
    }
    /**
     * Get One_Time_Payment_Plan_Reference value
     * @return \StructType\One_Time_Payment_PlanObjectType|null
     */
    public function getOne_Time_Payment_Plan_Reference()
    {
        return $this->One_Time_Payment_Plan_Reference;
    }
    /**
     * Set One_Time_Payment_Plan_Reference value
     * @param \StructType\One_Time_Payment_PlanObjectType $one_Time_Payment_Plan_Reference
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setOne_Time_Payment_Plan_Reference(\StructType\One_Time_Payment_PlanObjectType $one_Time_Payment_Plan_Reference = null)
    {
        $this->One_Time_Payment_Plan_Reference = $one_Time_Payment_Plan_Reference;
        return $this;
    }
    /**
     * Get Scheduled_Payment_Date value
     * @return string|null
     */
    public function getScheduled_Payment_Date()
    {
        return $this->Scheduled_Payment_Date;
    }
    /**
     * Set Scheduled_Payment_Date value
     * @param string $scheduled_Payment_Date
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setScheduled_Payment_Date($scheduled_Payment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($scheduled_Payment_Date) && !is_string($scheduled_Payment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduled_Payment_Date, true), gettype($scheduled_Payment_Date)), __LINE__);
        }
        $this->Scheduled_Payment_Date = $scheduled_Payment_Date;
        return $this;
    }
    /**
     * Get Clawback_Date value
     * @return string|null
     */
    public function getClawback_Date()
    {
        return $this->Clawback_Date;
    }
    /**
     * Set Clawback_Date value
     * @param string $clawback_Date
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setClawback_Date($clawback_Date = null)
    {
        // validation for constraint: string
        if (!is_null($clawback_Date) && !is_string($clawback_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clawback_Date, true), gettype($clawback_Date)), __LINE__);
        }
        $this->Clawback_Date = $clawback_Date;
        return $this;
    }
    /**
     * Get Coverage_Start_Date value
     * @return string|null
     */
    public function getCoverage_Start_Date()
    {
        return $this->Coverage_Start_Date;
    }
    /**
     * Set Coverage_Start_Date value
     * @param string $coverage_Start_Date
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setCoverage_Start_Date($coverage_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($coverage_Start_Date) && !is_string($coverage_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverage_Start_Date, true), gettype($coverage_Start_Date)), __LINE__);
        }
        $this->Coverage_Start_Date = $coverage_Start_Date;
        return $this;
    }
    /**
     * Get Coverage_End_Date value
     * @return string|null
     */
    public function getCoverage_End_Date()
    {
        return $this->Coverage_End_Date;
    }
    /**
     * Set Coverage_End_Date value
     * @param string $coverage_End_Date
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setCoverage_End_Date($coverage_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($coverage_End_Date) && !is_string($coverage_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverage_End_Date, true), gettype($coverage_End_Date)), __LINE__);
        }
        $this->Coverage_End_Date = $coverage_End_Date;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmount method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAmountForChoiceConstraintsFromSetAmount($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Percent',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Amount can\'t be set as the property %s is already set. Only one property must be set among these properties: Amount, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Amount value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $amount
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: choice(Amount, Percent)
        if ('' !== ($amountChoiceErrorMessage = self::validateAmountForChoiceConstraintsFromSetAmount($amount))) {
            throw new \InvalidArgumentException($amountChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, false !== mb_strpos($amount, '.') ? mb_strpos($amount, '.') + 1 : mb_strlen($amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($amount) && mb_strlen(preg_replace('/(\D)/', '', $amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($amount, true), mb_strlen(preg_replace('/(\D)/', '', $amount))), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return isset($this->Percent) ? $this->Percent : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPercent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPercent method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePercentForChoiceConstraintsFromSetPercent($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Amount',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Percent can\'t be set as the property %s is already set. Only one property must be set among these properties: Percent, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Percent value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $percent
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        // validation for constraint: choice(Amount, Percent)
        if ('' !== ($percentChoiceErrorMessage = self::validatePercentForChoiceConstraintsFromSetPercent($percent))) {
            throw new \InvalidArgumentException($percentChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($percent) && mb_strlen(mb_substr($percent, false !== mb_strpos($percent, '.') ? mb_strpos($percent, '.') + 1 : mb_strlen($percent))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($percent, true), mb_strlen(mb_substr($percent, mb_strpos($percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($percent) && mb_strlen(preg_replace('/(\D)/', '', $percent)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($percent, true), mb_strlen(preg_replace('/(\D)/', '', $percent))), __LINE__);
        }
        if (is_null($percent) || (is_array($percent) && empty($percent))) {
            unset($this->Percent);
        } else {
            $this->Percent = $percent;
        }
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Do_Not_Pay value
     * @return bool|null
     */
    public function getDo_Not_Pay()
    {
        return $this->Do_Not_Pay;
    }
    /**
     * Set Do_Not_Pay value
     * @param bool $do_Not_Pay
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setDo_Not_Pay($do_Not_Pay = null)
    {
        // validation for constraint: boolean
        if (!is_null($do_Not_Pay) && !is_bool($do_Not_Pay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($do_Not_Pay, true), gettype($do_Not_Pay)), __LINE__);
        }
        $this->Do_Not_Pay = $do_Not_Pay;
        return $this;
    }
    /**
     * Get Costing_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCosting_Company_Reference()
    {
        return $this->Costing_Company_Reference;
    }
    /**
     * Set Costing_Company_Reference value
     * @param \StructType\CompanyObjectType $costing_Company_Reference
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setCosting_Company_Reference(\StructType\CompanyObjectType $costing_Company_Reference = null)
    {
        $this->Costing_Company_Reference = $costing_Company_Reference;
        return $this;
    }
    /**
     * Get One_Time_Payment_Worktags_Reference value
     * @return \StructType\Tenanted_Payroll_WorktagObjectType[]|null
     */
    public function getOne_Time_Payment_Worktags_Reference()
    {
        return $this->One_Time_Payment_Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOne_Time_Payment_Worktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOne_Time_Payment_Worktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOne_Time_Payment_Worktags_ReferenceForArrayConstraintsFromSetOne_Time_Payment_Worktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $one_Time_Payment_DataTypeOne_Time_Payment_Worktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$one_Time_Payment_DataTypeOne_Time_Payment_Worktags_ReferenceItem instanceof \StructType\Tenanted_Payroll_WorktagObjectType) {
                $invalidValues[] = is_object($one_Time_Payment_DataTypeOne_Time_Payment_Worktags_ReferenceItem) ? get_class($one_Time_Payment_DataTypeOne_Time_Payment_Worktags_ReferenceItem) : sprintf('%s(%s)', gettype($one_Time_Payment_DataTypeOne_Time_Payment_Worktags_ReferenceItem), var_export($one_Time_Payment_DataTypeOne_Time_Payment_Worktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The One_Time_Payment_Worktags_Reference property can only contain items of type \StructType\Tenanted_Payroll_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set One_Time_Payment_Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tenanted_Payroll_WorktagObjectType[] $one_Time_Payment_Worktags_Reference
     * @return \StructType\One_Time_Payment_DataType
     */
    public function setOne_Time_Payment_Worktags_Reference(array $one_Time_Payment_Worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($one_Time_Payment_Worktags_ReferenceArrayErrorMessage = self::validateOne_Time_Payment_Worktags_ReferenceForArrayConstraintsFromSetOne_Time_Payment_Worktags_Reference($one_Time_Payment_Worktags_Reference))) {
            throw new \InvalidArgumentException($one_Time_Payment_Worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->One_Time_Payment_Worktags_Reference = $one_Time_Payment_Worktags_Reference;
        return $this;
    }
    /**
     * Add item to One_Time_Payment_Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tenanted_Payroll_WorktagObjectType $item
     * @return \StructType\One_Time_Payment_DataType
     */
    public function addToOne_Time_Payment_Worktags_Reference(\StructType\Tenanted_Payroll_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tenanted_Payroll_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The One_Time_Payment_Worktags_Reference property can only contain items of type \StructType\Tenanted_Payroll_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->One_Time_Payment_Worktags_Reference[] = $item;
        return $this;
    }
}
