<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Move_Candidate_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Collects the Candidate reference and Job Requisition reference
 * @subpackage Structs
 */
class Move_Candidate_CriteriaType extends AbstractStructBase
{
    /**
     * The Candidate_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Candidate.
     * @var \StructType\CandidateObjectType
     */
    public $Candidate_Reference;
    /**
     * The Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to a Requisition
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Requisition_Reference;
    /**
     * Constructor method for Move_Candidate_CriteriaType
     * @uses Move_Candidate_CriteriaType::setCandidate_Reference()
     * @uses Move_Candidate_CriteriaType::setRequisition_Reference()
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @param \StructType\Job_Requisition_EnabledObjectType $requisition_Reference
     */
    public function __construct(\StructType\CandidateObjectType $candidate_Reference = null, \StructType\Job_Requisition_EnabledObjectType $requisition_Reference = null)
    {
        $this
            ->setCandidate_Reference($candidate_Reference)
            ->setRequisition_Reference($requisition_Reference);
    }
    /**
     * Get Candidate_Reference value
     * @return \StructType\CandidateObjectType|null
     */
    public function getCandidate_Reference()
    {
        return $this->Candidate_Reference;
    }
    /**
     * Set Candidate_Reference value
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @return \StructType\Move_Candidate_CriteriaType
     */
    public function setCandidate_Reference(\StructType\CandidateObjectType $candidate_Reference = null)
    {
        $this->Candidate_Reference = $candidate_Reference;
        return $this;
    }
    /**
     * Get Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getRequisition_Reference()
    {
        return $this->Requisition_Reference;
    }
    /**
     * Set Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $requisition_Reference
     * @return \StructType\Move_Candidate_CriteriaType
     */
    public function setRequisition_Reference(\StructType\Job_Requisition_EnabledObjectType $requisition_Reference = null)
    {
        $this->Requisition_Reference = $requisition_Reference;
        return $this;
    }
}
