<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Masked_Recruiting_Configuration_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for Masked Configuration Data
 * @subpackage Structs
 */
class Masked_Recruiting_Configuration_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: ID of Masked Configuration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name of Masked Configuration
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Exclude_Internal_Candidates
     * Meta information extracted from the WSDL
     * - documentation: Boolean to Exclude Internal Candidates
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Internal_Candidates;
    /**
     * The Exclude_Referral_Candidates
     * Meta information extracted from the WSDL
     * - documentation: Boolean to Exclude Internal Candidates
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Referral_Candidates;
    /**
     * The Masked_Recruiting_Configuration_Item_Data
     * Meta information extracted from the WSDL
     * - documentation: Masked Configuration Item Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Masked_Configuration_Item_DataType[]
     */
    public $Masked_Recruiting_Configuration_Item_Data;
    /**
     * Constructor method for Masked_Recruiting_Configuration_DataType
     * @uses Masked_Recruiting_Configuration_DataType::setID()
     * @uses Masked_Recruiting_Configuration_DataType::setName()
     * @uses Masked_Recruiting_Configuration_DataType::setExclude_Internal_Candidates()
     * @uses Masked_Recruiting_Configuration_DataType::setExclude_Referral_Candidates()
     * @uses Masked_Recruiting_Configuration_DataType::setMasked_Recruiting_Configuration_Item_Data()
     * @param string $iD
     * @param string $name
     * @param bool $exclude_Internal_Candidates
     * @param bool $exclude_Referral_Candidates
     * @param \StructType\Masked_Configuration_Item_DataType[] $masked_Recruiting_Configuration_Item_Data
     */
    public function __construct($iD = null, $name = null, $exclude_Internal_Candidates = null, $exclude_Referral_Candidates = null, array $masked_Recruiting_Configuration_Item_Data = array())
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setExclude_Internal_Candidates($exclude_Internal_Candidates)
            ->setExclude_Referral_Candidates($exclude_Referral_Candidates)
            ->setMasked_Recruiting_Configuration_Item_Data($masked_Recruiting_Configuration_Item_Data);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Masked_Recruiting_Configuration_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Masked_Recruiting_Configuration_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Exclude_Internal_Candidates value
     * @return bool|null
     */
    public function getExclude_Internal_Candidates()
    {
        return $this->Exclude_Internal_Candidates;
    }
    /**
     * Set Exclude_Internal_Candidates value
     * @param bool $exclude_Internal_Candidates
     * @return \StructType\Masked_Recruiting_Configuration_DataType
     */
    public function setExclude_Internal_Candidates($exclude_Internal_Candidates = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Internal_Candidates) && !is_bool($exclude_Internal_Candidates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Internal_Candidates, true), gettype($exclude_Internal_Candidates)), __LINE__);
        }
        $this->Exclude_Internal_Candidates = $exclude_Internal_Candidates;
        return $this;
    }
    /**
     * Get Exclude_Referral_Candidates value
     * @return bool|null
     */
    public function getExclude_Referral_Candidates()
    {
        return $this->Exclude_Referral_Candidates;
    }
    /**
     * Set Exclude_Referral_Candidates value
     * @param bool $exclude_Referral_Candidates
     * @return \StructType\Masked_Recruiting_Configuration_DataType
     */
    public function setExclude_Referral_Candidates($exclude_Referral_Candidates = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Referral_Candidates) && !is_bool($exclude_Referral_Candidates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Referral_Candidates, true), gettype($exclude_Referral_Candidates)), __LINE__);
        }
        $this->Exclude_Referral_Candidates = $exclude_Referral_Candidates;
        return $this;
    }
    /**
     * Get Masked_Recruiting_Configuration_Item_Data value
     * @return \StructType\Masked_Configuration_Item_DataType[]|null
     */
    public function getMasked_Recruiting_Configuration_Item_Data()
    {
        return $this->Masked_Recruiting_Configuration_Item_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setMasked_Recruiting_Configuration_Item_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMasked_Recruiting_Configuration_Item_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMasked_Recruiting_Configuration_Item_DataForArrayConstraintsFromSetMasked_Recruiting_Configuration_Item_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $masked_Recruiting_Configuration_DataTypeMasked_Recruiting_Configuration_Item_DataItem) {
            // validation for constraint: itemType
            if (!$masked_Recruiting_Configuration_DataTypeMasked_Recruiting_Configuration_Item_DataItem instanceof \StructType\Masked_Configuration_Item_DataType) {
                $invalidValues[] = is_object($masked_Recruiting_Configuration_DataTypeMasked_Recruiting_Configuration_Item_DataItem) ? get_class($masked_Recruiting_Configuration_DataTypeMasked_Recruiting_Configuration_Item_DataItem) : sprintf('%s(%s)', gettype($masked_Recruiting_Configuration_DataTypeMasked_Recruiting_Configuration_Item_DataItem), var_export($masked_Recruiting_Configuration_DataTypeMasked_Recruiting_Configuration_Item_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Masked_Recruiting_Configuration_Item_Data property can only contain items of type \StructType\Masked_Configuration_Item_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Masked_Recruiting_Configuration_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Masked_Configuration_Item_DataType[] $masked_Recruiting_Configuration_Item_Data
     * @return \StructType\Masked_Recruiting_Configuration_DataType
     */
    public function setMasked_Recruiting_Configuration_Item_Data(array $masked_Recruiting_Configuration_Item_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($masked_Recruiting_Configuration_Item_DataArrayErrorMessage = self::validateMasked_Recruiting_Configuration_Item_DataForArrayConstraintsFromSetMasked_Recruiting_Configuration_Item_Data($masked_Recruiting_Configuration_Item_Data))) {
            throw new \InvalidArgumentException($masked_Recruiting_Configuration_Item_DataArrayErrorMessage, __LINE__);
        }
        $this->Masked_Recruiting_Configuration_Item_Data = $masked_Recruiting_Configuration_Item_Data;
        return $this;
    }
    /**
     * Add item to Masked_Recruiting_Configuration_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Masked_Configuration_Item_DataType $item
     * @return \StructType\Masked_Recruiting_Configuration_DataType
     */
    public function addToMasked_Recruiting_Configuration_Item_Data(\StructType\Masked_Configuration_Item_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Masked_Configuration_Item_DataType) {
            throw new \InvalidArgumentException(sprintf('The Masked_Recruiting_Configuration_Item_Data property can only contain items of type \StructType\Masked_Configuration_Item_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Masked_Recruiting_Configuration_Item_Data[] = $item;
        return $this;
    }
}
