<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_Masking_Rule_Configuration_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing data for the Masked Job Application Defaults table.
 * @subpackage Structs
 */
class Job_Requisition_Masking_Rule_Configuration_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier used to reference the representation of the Masked Job Requisition Defaults table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Masked_Job_Requisition_Default_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing the data for individual rows of the Masked Job Requisition Defaults table.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Masked_Job_Requisition_Default_DataType[]
     */
    public $Masked_Job_Requisition_Default_Data;
    /**
     * Constructor method for Job_Requisition_Masking_Rule_Configuration_DataType
     * @uses Job_Requisition_Masking_Rule_Configuration_DataType::setID()
     * @uses Job_Requisition_Masking_Rule_Configuration_DataType::setMasked_Job_Requisition_Default_Data()
     * @param string $iD
     * @param \StructType\Masked_Job_Requisition_Default_DataType[] $masked_Job_Requisition_Default_Data
     */
    public function __construct($iD = null, array $masked_Job_Requisition_Default_Data = array())
    {
        $this
            ->setID($iD)
            ->setMasked_Job_Requisition_Default_Data($masked_Job_Requisition_Default_Data);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Job_Requisition_Masking_Rule_Configuration_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Masked_Job_Requisition_Default_Data value
     * @return \StructType\Masked_Job_Requisition_Default_DataType[]|null
     */
    public function getMasked_Job_Requisition_Default_Data()
    {
        return $this->Masked_Job_Requisition_Default_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setMasked_Job_Requisition_Default_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMasked_Job_Requisition_Default_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMasked_Job_Requisition_Default_DataForArrayConstraintsFromSetMasked_Job_Requisition_Default_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Masking_Rule_Configuration_DataTypeMasked_Job_Requisition_Default_DataItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Masking_Rule_Configuration_DataTypeMasked_Job_Requisition_Default_DataItem instanceof \StructType\Masked_Job_Requisition_Default_DataType) {
                $invalidValues[] = is_object($job_Requisition_Masking_Rule_Configuration_DataTypeMasked_Job_Requisition_Default_DataItem) ? get_class($job_Requisition_Masking_Rule_Configuration_DataTypeMasked_Job_Requisition_Default_DataItem) : sprintf('%s(%s)', gettype($job_Requisition_Masking_Rule_Configuration_DataTypeMasked_Job_Requisition_Default_DataItem), var_export($job_Requisition_Masking_Rule_Configuration_DataTypeMasked_Job_Requisition_Default_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Masked_Job_Requisition_Default_Data property can only contain items of type \StructType\Masked_Job_Requisition_Default_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Masked_Job_Requisition_Default_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Masked_Job_Requisition_Default_DataType[] $masked_Job_Requisition_Default_Data
     * @return \StructType\Job_Requisition_Masking_Rule_Configuration_DataType
     */
    public function setMasked_Job_Requisition_Default_Data(array $masked_Job_Requisition_Default_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($masked_Job_Requisition_Default_DataArrayErrorMessage = self::validateMasked_Job_Requisition_Default_DataForArrayConstraintsFromSetMasked_Job_Requisition_Default_Data($masked_Job_Requisition_Default_Data))) {
            throw new \InvalidArgumentException($masked_Job_Requisition_Default_DataArrayErrorMessage, __LINE__);
        }
        $this->Masked_Job_Requisition_Default_Data = $masked_Job_Requisition_Default_Data;
        return $this;
    }
    /**
     * Add item to Masked_Job_Requisition_Default_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Masked_Job_Requisition_Default_DataType $item
     * @return \StructType\Job_Requisition_Masking_Rule_Configuration_DataType
     */
    public function addToMasked_Job_Requisition_Default_Data(\StructType\Masked_Job_Requisition_Default_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Masked_Job_Requisition_Default_DataType) {
            throw new \InvalidArgumentException(sprintf('The Masked_Job_Requisition_Default_Data property can only contain items of type \StructType\Masked_Job_Requisition_Default_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Masked_Job_Requisition_Default_Data[] = $item;
        return $this;
    }
}
