<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_Assessment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Assessments to be used at the beginning or during the Job Application process. For use by Recruiting customers only.
 * @subpackage Structs
 */
class Job_Requisition_Assessment_DataType extends AbstractStructBase
{
    /**
     * The Inline_Assessment_Test_Reference
     * Meta information extracted from the WSDL
     * - documentation: The inline assessment associated with the job posting on external career sites.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_TestObjectType
     */
    public $Inline_Assessment_Test_Reference;
    /**
     * The Default_Assessment_Tests_Reference
     * Meta information extracted from the WSDL
     * - documentation: The default assessments used for ad hoc candidate assessments in the job application process.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_TestObjectType[]
     */
    public $Default_Assessment_Tests_Reference;
    /**
     * Constructor method for Job_Requisition_Assessment_DataType
     * @uses Job_Requisition_Assessment_DataType::setInline_Assessment_Test_Reference()
     * @uses Job_Requisition_Assessment_DataType::setDefault_Assessment_Tests_Reference()
     * @param \StructType\Recruiting_Assessment_TestObjectType $inline_Assessment_Test_Reference
     * @param \StructType\Recruiting_Assessment_TestObjectType[] $default_Assessment_Tests_Reference
     */
    public function __construct(\StructType\Recruiting_Assessment_TestObjectType $inline_Assessment_Test_Reference = null, array $default_Assessment_Tests_Reference = array())
    {
        $this
            ->setInline_Assessment_Test_Reference($inline_Assessment_Test_Reference)
            ->setDefault_Assessment_Tests_Reference($default_Assessment_Tests_Reference);
    }
    /**
     * Get Inline_Assessment_Test_Reference value
     * @return \StructType\Recruiting_Assessment_TestObjectType|null
     */
    public function getInline_Assessment_Test_Reference()
    {
        return $this->Inline_Assessment_Test_Reference;
    }
    /**
     * Set Inline_Assessment_Test_Reference value
     * @param \StructType\Recruiting_Assessment_TestObjectType $inline_Assessment_Test_Reference
     * @return \StructType\Job_Requisition_Assessment_DataType
     */
    public function setInline_Assessment_Test_Reference(\StructType\Recruiting_Assessment_TestObjectType $inline_Assessment_Test_Reference = null)
    {
        $this->Inline_Assessment_Test_Reference = $inline_Assessment_Test_Reference;
        return $this;
    }
    /**
     * Get Default_Assessment_Tests_Reference value
     * @return \StructType\Recruiting_Assessment_TestObjectType[]|null
     */
    public function getDefault_Assessment_Tests_Reference()
    {
        return $this->Default_Assessment_Tests_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDefault_Assessment_Tests_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefault_Assessment_Tests_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDefault_Assessment_Tests_ReferenceForArrayConstraintsFromSetDefault_Assessment_Tests_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Assessment_DataTypeDefault_Assessment_Tests_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Assessment_DataTypeDefault_Assessment_Tests_ReferenceItem instanceof \StructType\Recruiting_Assessment_TestObjectType) {
                $invalidValues[] = is_object($job_Requisition_Assessment_DataTypeDefault_Assessment_Tests_ReferenceItem) ? get_class($job_Requisition_Assessment_DataTypeDefault_Assessment_Tests_ReferenceItem) : sprintf('%s(%s)', gettype($job_Requisition_Assessment_DataTypeDefault_Assessment_Tests_ReferenceItem), var_export($job_Requisition_Assessment_DataTypeDefault_Assessment_Tests_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Default_Assessment_Tests_Reference property can only contain items of type \StructType\Recruiting_Assessment_TestObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Default_Assessment_Tests_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Assessment_TestObjectType[] $default_Assessment_Tests_Reference
     * @return \StructType\Job_Requisition_Assessment_DataType
     */
    public function setDefault_Assessment_Tests_Reference(array $default_Assessment_Tests_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($default_Assessment_Tests_ReferenceArrayErrorMessage = self::validateDefault_Assessment_Tests_ReferenceForArrayConstraintsFromSetDefault_Assessment_Tests_Reference($default_Assessment_Tests_Reference))) {
            throw new \InvalidArgumentException($default_Assessment_Tests_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Default_Assessment_Tests_Reference = $default_Assessment_Tests_Reference;
        return $this;
    }
    /**
     * Add item to Default_Assessment_Tests_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Assessment_TestObjectType $item
     * @return \StructType\Job_Requisition_Assessment_DataType
     */
    public function addToDefault_Assessment_Tests_Reference(\StructType\Recruiting_Assessment_TestObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Assessment_TestObjectType) {
            throw new \InvalidArgumentException(sprintf('The Default_Assessment_Tests_Reference property can only contain items of type \StructType\Recruiting_Assessment_TestObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Default_Assessment_Tests_Reference[] = $item;
        return $this;
    }
}
