<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: End Date cannot be prior to Start Date. | Enter only one of a Job Posting Site Name or a Job Posting Site Reference. | A Job Posting Site Name was entered, but there are no Job Posting Sites in the current tenant with the specified
 * name. | Utilize the Request Criteria element to filter instance(s) of Job Postings by date, posting site, supervisory organization, job requisition, and active status.
 * @subpackage Structs
 */
class Job_Posting_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Job_Posting_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date of the Job Posting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_Start_Date;
    /**
     * The Job_Posting_End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date of the Job Posting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_End_Date;
    /**
     * The Job_Posting_Site_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the Job Posting Site. Specify the Job Posting Site by entering data here or in the Job Posting Site Reference.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_Site_Name;
    /**
     * The Job_Posting_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Job Posting Site. Specify the Job Posting Site by entering data here or entering the Job Posting Site Name.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Posting_SiteObjectType[]
     */
    public $Job_Posting_Site_Reference;
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Return Job Postings for a Supervisory Organization Reference.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supervisory_OrganizationObjectType[]
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Return Job Postings for a Job Requisition Reference.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType[]
     */
    public $Job_Requisition_Reference;
    /**
     * The Show_Only_Active_Job_Postings
     * Meta information extracted from the WSDL
     * - documentation: Only return Job Postings with a future Job Posting End Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Show_Only_Active_Job_Postings;
    /**
     * The Show_Only_External_Job_Postings
     * Meta information extracted from the WSDL
     * - documentation: Retrieves job postings that have been posted to an external career site.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Show_Only_External_Job_Postings;
    /**
     * The Exclude_Future_Job_Postings
     * Meta information extracted from the WSDL
     * - documentation: Retrieves job postings with start dates on and before the current date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Future_Job_Postings;
    /**
     * The Field_And_Parameter_Criteria_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Field_And_Parameter_Criteria_DataType
     */
    public $Field_And_Parameter_Criteria_Data;
    /**
     * Constructor method for Job_Posting_Request_CriteriaType
     * @uses Job_Posting_Request_CriteriaType::setJob_Posting_Start_Date()
     * @uses Job_Posting_Request_CriteriaType::setJob_Posting_End_Date()
     * @uses Job_Posting_Request_CriteriaType::setJob_Posting_Site_Name()
     * @uses Job_Posting_Request_CriteriaType::setJob_Posting_Site_Reference()
     * @uses Job_Posting_Request_CriteriaType::setSupervisory_Organization_Reference()
     * @uses Job_Posting_Request_CriteriaType::setJob_Requisition_Reference()
     * @uses Job_Posting_Request_CriteriaType::setShow_Only_Active_Job_Postings()
     * @uses Job_Posting_Request_CriteriaType::setShow_Only_External_Job_Postings()
     * @uses Job_Posting_Request_CriteriaType::setExclude_Future_Job_Postings()
     * @uses Job_Posting_Request_CriteriaType::setField_And_Parameter_Criteria_Data()
     * @param string $job_Posting_Start_Date
     * @param string $job_Posting_End_Date
     * @param string $job_Posting_Site_Name
     * @param \StructType\Job_Posting_SiteObjectType[] $job_Posting_Site_Reference
     * @param \StructType\Supervisory_OrganizationObjectType[] $supervisory_Organization_Reference
     * @param \StructType\Job_Requisition_EnabledObjectType[] $job_Requisition_Reference
     * @param bool $show_Only_Active_Job_Postings
     * @param bool $show_Only_External_Job_Postings
     * @param bool $exclude_Future_Job_Postings
     * @param \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data
     */
    public function __construct($job_Posting_Start_Date = null, $job_Posting_End_Date = null, $job_Posting_Site_Name = null, array $job_Posting_Site_Reference = array(), array $supervisory_Organization_Reference = array(), array $job_Requisition_Reference = array(), $show_Only_Active_Job_Postings = null, $show_Only_External_Job_Postings = null, $exclude_Future_Job_Postings = null, \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data = null)
    {
        $this
            ->setJob_Posting_Start_Date($job_Posting_Start_Date)
            ->setJob_Posting_End_Date($job_Posting_End_Date)
            ->setJob_Posting_Site_Name($job_Posting_Site_Name)
            ->setJob_Posting_Site_Reference($job_Posting_Site_Reference)
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setShow_Only_Active_Job_Postings($show_Only_Active_Job_Postings)
            ->setShow_Only_External_Job_Postings($show_Only_External_Job_Postings)
            ->setExclude_Future_Job_Postings($exclude_Future_Job_Postings)
            ->setField_And_Parameter_Criteria_Data($field_And_Parameter_Criteria_Data);
    }
    /**
     * Get Job_Posting_Start_Date value
     * @return string|null
     */
    public function getJob_Posting_Start_Date()
    {
        return $this->Job_Posting_Start_Date;
    }
    /**
     * Set Job_Posting_Start_Date value
     * @param string $job_Posting_Start_Date
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function setJob_Posting_Start_Date($job_Posting_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Start_Date) && !is_string($job_Posting_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Start_Date, true), gettype($job_Posting_Start_Date)), __LINE__);
        }
        $this->Job_Posting_Start_Date = $job_Posting_Start_Date;
        return $this;
    }
    /**
     * Get Job_Posting_End_Date value
     * @return string|null
     */
    public function getJob_Posting_End_Date()
    {
        return $this->Job_Posting_End_Date;
    }
    /**
     * Set Job_Posting_End_Date value
     * @param string $job_Posting_End_Date
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function setJob_Posting_End_Date($job_Posting_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_End_Date) && !is_string($job_Posting_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_End_Date, true), gettype($job_Posting_End_Date)), __LINE__);
        }
        $this->Job_Posting_End_Date = $job_Posting_End_Date;
        return $this;
    }
    /**
     * Get Job_Posting_Site_Name value
     * @return string|null
     */
    public function getJob_Posting_Site_Name()
    {
        return $this->Job_Posting_Site_Name;
    }
    /**
     * Set Job_Posting_Site_Name value
     * @param string $job_Posting_Site_Name
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function setJob_Posting_Site_Name($job_Posting_Site_Name = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Site_Name) && !is_string($job_Posting_Site_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Site_Name, true), gettype($job_Posting_Site_Name)), __LINE__);
        }
        $this->Job_Posting_Site_Name = $job_Posting_Site_Name;
        return $this;
    }
    /**
     * Get Job_Posting_Site_Reference value
     * @return \StructType\Job_Posting_SiteObjectType[]|null
     */
    public function getJob_Posting_Site_Reference()
    {
        return $this->Job_Posting_Site_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Posting_Site_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Site_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Posting_Site_ReferenceForArrayConstraintsFromSetJob_Posting_Site_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Request_CriteriaTypeJob_Posting_Site_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Request_CriteriaTypeJob_Posting_Site_ReferenceItem instanceof \StructType\Job_Posting_SiteObjectType) {
                $invalidValues[] = is_object($job_Posting_Request_CriteriaTypeJob_Posting_Site_ReferenceItem) ? get_class($job_Posting_Request_CriteriaTypeJob_Posting_Site_ReferenceItem) : sprintf('%s(%s)', gettype($job_Posting_Request_CriteriaTypeJob_Posting_Site_ReferenceItem), var_export($job_Posting_Request_CriteriaTypeJob_Posting_Site_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Posting_Site_Reference property can only contain items of type \StructType\Job_Posting_SiteObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Posting_Site_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_SiteObjectType[] $job_Posting_Site_Reference
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function setJob_Posting_Site_Reference(array $job_Posting_Site_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Posting_Site_ReferenceArrayErrorMessage = self::validateJob_Posting_Site_ReferenceForArrayConstraintsFromSetJob_Posting_Site_Reference($job_Posting_Site_Reference))) {
            throw new \InvalidArgumentException($job_Posting_Site_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Posting_Site_Reference = $job_Posting_Site_Reference;
        return $this;
    }
    /**
     * Add item to Job_Posting_Site_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_SiteObjectType $item
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function addToJob_Posting_Site_Reference(\StructType\Job_Posting_SiteObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Posting_SiteObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Posting_Site_Reference property can only contain items of type \StructType\Job_Posting_SiteObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Posting_Site_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType[]|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupervisory_Organization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupervisory_Organization_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupervisory_Organization_ReferenceForArrayConstraintsFromSetSupervisory_Organization_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Request_CriteriaTypeSupervisory_Organization_ReferenceItem instanceof \StructType\Supervisory_OrganizationObjectType) {
                $invalidValues[] = is_object($job_Posting_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) ? get_class($job_Posting_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) : sprintf('%s(%s)', gettype($job_Posting_Request_CriteriaTypeSupervisory_Organization_ReferenceItem), var_export($job_Posting_Request_CriteriaTypeSupervisory_Organization_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supervisory_Organization_Reference property can only contain items of type \StructType\Supervisory_OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supervisory_OrganizationObjectType[] $supervisory_Organization_Reference
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function setSupervisory_Organization_Reference(array $supervisory_Organization_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supervisory_Organization_ReferenceArrayErrorMessage = self::validateSupervisory_Organization_ReferenceForArrayConstraintsFromSetSupervisory_Organization_Reference($supervisory_Organization_Reference))) {
            throw new \InvalidArgumentException($supervisory_Organization_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Add item to Supervisory_Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supervisory_OrganizationObjectType $item
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function addToSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supervisory_OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supervisory_Organization_Reference property can only contain items of type \StructType\Supervisory_OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supervisory_Organization_Reference[] = $item;
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType[]|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_ReferenceForArrayConstraintsFromSetJob_Requisition_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Request_CriteriaTypeJob_Requisition_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Request_CriteriaTypeJob_Requisition_ReferenceItem instanceof \StructType\Job_Requisition_EnabledObjectType) {
                $invalidValues[] = is_object($job_Posting_Request_CriteriaTypeJob_Requisition_ReferenceItem) ? get_class($job_Posting_Request_CriteriaTypeJob_Requisition_ReferenceItem) : sprintf('%s(%s)', gettype($job_Posting_Request_CriteriaTypeJob_Requisition_ReferenceItem), var_export($job_Posting_Request_CriteriaTypeJob_Requisition_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Reference property can only contain items of type \StructType\Job_Requisition_EnabledObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_EnabledObjectType[] $job_Requisition_Reference
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function setJob_Requisition_Reference(array $job_Requisition_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_ReferenceArrayErrorMessage = self::validateJob_Requisition_ReferenceForArrayConstraintsFromSetJob_Requisition_Reference($job_Requisition_Reference))) {
            throw new \InvalidArgumentException($job_Requisition_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_EnabledObjectType $item
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function addToJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Requisition_EnabledObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Reference property can only contain items of type \StructType\Job_Requisition_EnabledObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Reference[] = $item;
        return $this;
    }
    /**
     * Get Show_Only_Active_Job_Postings value
     * @return bool|null
     */
    public function getShow_Only_Active_Job_Postings()
    {
        return $this->Show_Only_Active_Job_Postings;
    }
    /**
     * Set Show_Only_Active_Job_Postings value
     * @param bool $show_Only_Active_Job_Postings
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function setShow_Only_Active_Job_Postings($show_Only_Active_Job_Postings = null)
    {
        // validation for constraint: boolean
        if (!is_null($show_Only_Active_Job_Postings) && !is_bool($show_Only_Active_Job_Postings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($show_Only_Active_Job_Postings, true), gettype($show_Only_Active_Job_Postings)), __LINE__);
        }
        $this->Show_Only_Active_Job_Postings = $show_Only_Active_Job_Postings;
        return $this;
    }
    /**
     * Get Show_Only_External_Job_Postings value
     * @return bool|null
     */
    public function getShow_Only_External_Job_Postings()
    {
        return $this->Show_Only_External_Job_Postings;
    }
    /**
     * Set Show_Only_External_Job_Postings value
     * @param bool $show_Only_External_Job_Postings
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function setShow_Only_External_Job_Postings($show_Only_External_Job_Postings = null)
    {
        // validation for constraint: boolean
        if (!is_null($show_Only_External_Job_Postings) && !is_bool($show_Only_External_Job_Postings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($show_Only_External_Job_Postings, true), gettype($show_Only_External_Job_Postings)), __LINE__);
        }
        $this->Show_Only_External_Job_Postings = $show_Only_External_Job_Postings;
        return $this;
    }
    /**
     * Get Exclude_Future_Job_Postings value
     * @return bool|null
     */
    public function getExclude_Future_Job_Postings()
    {
        return $this->Exclude_Future_Job_Postings;
    }
    /**
     * Set Exclude_Future_Job_Postings value
     * @param bool $exclude_Future_Job_Postings
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function setExclude_Future_Job_Postings($exclude_Future_Job_Postings = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Future_Job_Postings) && !is_bool($exclude_Future_Job_Postings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Future_Job_Postings, true), gettype($exclude_Future_Job_Postings)), __LINE__);
        }
        $this->Exclude_Future_Job_Postings = $exclude_Future_Job_Postings;
        return $this;
    }
    /**
     * Get Field_And_Parameter_Criteria_Data value
     * @return \StructType\Field_And_Parameter_Criteria_DataType|null
     */
    public function getField_And_Parameter_Criteria_Data()
    {
        return $this->Field_And_Parameter_Criteria_Data;
    }
    /**
     * Set Field_And_Parameter_Criteria_Data value
     * @param \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data
     * @return \StructType\Job_Posting_Request_CriteriaType
     */
    public function setField_And_Parameter_Criteria_Data(\StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data = null)
    {
        $this->Field_And_Parameter_Criteria_Data = $field_And_Parameter_Criteria_Data;
        return $this;
    }
}
