<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data for individual Job Postings.
 * @subpackage Structs
 */
class Job_Posting_DataType extends AbstractStructBase
{
    /**
     * The Job_Posting_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Posting to modify.
     * - minOccurs: 0
     * @var \StructType\Job_PostingObjectType
     */
    public $Job_Posting_Reference;
    /**
     * The Job_Posting_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Posting Site for Job Posting.
     * - minOccurs: 0
     * @var \StructType\Job_Posting_SiteObjectType
     */
    public $Job_Posting_Site_Reference;
    /**
     * The Primary_Posting
     * Meta information extracted from the WSDL
     * - documentation: Job posting is the default job posting used for social share and invite to apply referrals. Will return false until post job business process is complete.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Primary_Posting;
    /**
     * The Forecasted_Payout
     * Meta information extracted from the WSDL
     * - documentation: The Forecasted Agency Payout on a Job Posting. Calculated at time of posting or updated later. The Currency for this value is stored separately on the Job Posting.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Forecasted_Payout;
    /**
     * The Agency_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Currency for the Forecasted Agency Payout stored on the Job Posting.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Agency_Currency_Reference;
    /**
     * Constructor method for Job_Posting_DataType
     * @uses Job_Posting_DataType::setJob_Posting_Reference()
     * @uses Job_Posting_DataType::setJob_Posting_Site_Reference()
     * @uses Job_Posting_DataType::setPrimary_Posting()
     * @uses Job_Posting_DataType::setForecasted_Payout()
     * @uses Job_Posting_DataType::setAgency_Currency_Reference()
     * @param \StructType\Job_PostingObjectType $job_Posting_Reference
     * @param \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @param bool $primary_Posting
     * @param float $forecasted_Payout
     * @param \StructType\CurrencyObjectType $agency_Currency_Reference
     */
    public function __construct(\StructType\Job_PostingObjectType $job_Posting_Reference = null, \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference = null, $primary_Posting = null, $forecasted_Payout = null, \StructType\CurrencyObjectType $agency_Currency_Reference = null)
    {
        $this
            ->setJob_Posting_Reference($job_Posting_Reference)
            ->setJob_Posting_Site_Reference($job_Posting_Site_Reference)
            ->setPrimary_Posting($primary_Posting)
            ->setForecasted_Payout($forecasted_Payout)
            ->setAgency_Currency_Reference($agency_Currency_Reference);
    }
    /**
     * Get Job_Posting_Reference value
     * @return \StructType\Job_PostingObjectType|null
     */
    public function getJob_Posting_Reference()
    {
        return $this->Job_Posting_Reference;
    }
    /**
     * Set Job_Posting_Reference value
     * @param \StructType\Job_PostingObjectType $job_Posting_Reference
     * @return \StructType\Job_Posting_DataType
     */
    public function setJob_Posting_Reference(\StructType\Job_PostingObjectType $job_Posting_Reference = null)
    {
        $this->Job_Posting_Reference = $job_Posting_Reference;
        return $this;
    }
    /**
     * Get Job_Posting_Site_Reference value
     * @return \StructType\Job_Posting_SiteObjectType|null
     */
    public function getJob_Posting_Site_Reference()
    {
        return $this->Job_Posting_Site_Reference;
    }
    /**
     * Set Job_Posting_Site_Reference value
     * @param \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @return \StructType\Job_Posting_DataType
     */
    public function setJob_Posting_Site_Reference(\StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference = null)
    {
        $this->Job_Posting_Site_Reference = $job_Posting_Site_Reference;
        return $this;
    }
    /**
     * Get Primary_Posting value
     * @return bool|null
     */
    public function getPrimary_Posting()
    {
        return $this->Primary_Posting;
    }
    /**
     * Set Primary_Posting value
     * @param bool $primary_Posting
     * @return \StructType\Job_Posting_DataType
     */
    public function setPrimary_Posting($primary_Posting = null)
    {
        // validation for constraint: boolean
        if (!is_null($primary_Posting) && !is_bool($primary_Posting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primary_Posting, true), gettype($primary_Posting)), __LINE__);
        }
        $this->Primary_Posting = $primary_Posting;
        return $this;
    }
    /**
     * Get Forecasted_Payout value
     * @return float|null
     */
    public function getForecasted_Payout()
    {
        return $this->Forecasted_Payout;
    }
    /**
     * Set Forecasted_Payout value
     * @param float $forecasted_Payout
     * @return \StructType\Job_Posting_DataType
     */
    public function setForecasted_Payout($forecasted_Payout = null)
    {
        // validation for constraint: float
        if (!is_null($forecasted_Payout) && !(is_float($forecasted_Payout) || is_numeric($forecasted_Payout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($forecasted_Payout, true), gettype($forecasted_Payout)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($forecasted_Payout) && mb_strlen(mb_substr($forecasted_Payout, false !== mb_strpos($forecasted_Payout, '.') ? mb_strpos($forecasted_Payout, '.') + 1 : mb_strlen($forecasted_Payout))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($forecasted_Payout, true), mb_strlen(mb_substr($forecasted_Payout, mb_strpos($forecasted_Payout, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($forecasted_Payout) && $forecasted_Payout < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($forecasted_Payout, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($forecasted_Payout) && mb_strlen(preg_replace('/(\D)/', '', $forecasted_Payout)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($forecasted_Payout, true), mb_strlen(preg_replace('/(\D)/', '', $forecasted_Payout))), __LINE__);
        }
        $this->Forecasted_Payout = $forecasted_Payout;
        return $this;
    }
    /**
     * Get Agency_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getAgency_Currency_Reference()
    {
        return $this->Agency_Currency_Reference;
    }
    /**
     * Set Agency_Currency_Reference value
     * @param \StructType\CurrencyObjectType $agency_Currency_Reference
     * @return \StructType\Job_Posting_DataType
     */
    public function setAgency_Currency_Reference(\StructType\CurrencyObjectType $agency_Currency_Reference = null)
    {
        $this->Agency_Currency_Reference = $agency_Currency_Reference;
        return $this;
    }
}
