<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Interview_Session_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the interview session reference and its data.
 * @subpackage Structs
 */
class Interview_Session_DataType extends AbstractStructBase
{
    /**
     * The Interview_Session_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the interview session.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Interview_Session_Reference;
    /**
     * The Interview_Session_Details_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the interviewers, duration in minutes, interview start time, interview end time, interview type, and comment data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Interview_Session_Details_DataType[]
     */
    public $Interview_Session_Details_Data;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the interview session reference will be deleted.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Interview_Session_DataType
     * @uses Interview_Session_DataType::setInterview_Session_Reference()
     * @uses Interview_Session_DataType::setInterview_Session_Details_Data()
     * @uses Interview_Session_DataType::setDelete()
     * @param \StructType\Unique_IdentifierObjectType $interview_Session_Reference
     * @param \StructType\Interview_Session_Details_DataType[] $interview_Session_Details_Data
     * @param bool $delete
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $interview_Session_Reference = null, array $interview_Session_Details_Data = array(), $delete = null)
    {
        $this
            ->setInterview_Session_Reference($interview_Session_Reference)
            ->setInterview_Session_Details_Data($interview_Session_Details_Data)
            ->setDelete($delete);
    }
    /**
     * Get Interview_Session_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getInterview_Session_Reference()
    {
        return $this->Interview_Session_Reference;
    }
    /**
     * Set Interview_Session_Reference value
     * @param \StructType\Unique_IdentifierObjectType $interview_Session_Reference
     * @return \StructType\Interview_Session_DataType
     */
    public function setInterview_Session_Reference(\StructType\Unique_IdentifierObjectType $interview_Session_Reference = null)
    {
        $this->Interview_Session_Reference = $interview_Session_Reference;
        return $this;
    }
    /**
     * Get Interview_Session_Details_Data value
     * @return \StructType\Interview_Session_Details_DataType[]|null
     */
    public function getInterview_Session_Details_Data()
    {
        return $this->Interview_Session_Details_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInterview_Session_Details_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview_Session_Details_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterview_Session_Details_DataForArrayConstraintsFromSetInterview_Session_Details_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interview_Session_DataTypeInterview_Session_Details_DataItem) {
            // validation for constraint: itemType
            if (!$interview_Session_DataTypeInterview_Session_Details_DataItem instanceof \StructType\Interview_Session_Details_DataType) {
                $invalidValues[] = is_object($interview_Session_DataTypeInterview_Session_Details_DataItem) ? get_class($interview_Session_DataTypeInterview_Session_Details_DataItem) : sprintf('%s(%s)', gettype($interview_Session_DataTypeInterview_Session_Details_DataItem), var_export($interview_Session_DataTypeInterview_Session_Details_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interview_Session_Details_Data property can only contain items of type \StructType\Interview_Session_Details_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interview_Session_Details_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_Session_Details_DataType[] $interview_Session_Details_Data
     * @return \StructType\Interview_Session_DataType
     */
    public function setInterview_Session_Details_Data(array $interview_Session_Details_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($interview_Session_Details_DataArrayErrorMessage = self::validateInterview_Session_Details_DataForArrayConstraintsFromSetInterview_Session_Details_Data($interview_Session_Details_Data))) {
            throw new \InvalidArgumentException($interview_Session_Details_DataArrayErrorMessage, __LINE__);
        }
        $this->Interview_Session_Details_Data = $interview_Session_Details_Data;
        return $this;
    }
    /**
     * Add item to Interview_Session_Details_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_Session_Details_DataType $item
     * @return \StructType\Interview_Session_DataType
     */
    public function addToInterview_Session_Details_Data(\StructType\Interview_Session_Details_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Interview_Session_Details_DataType) {
            throw new \InvalidArgumentException(sprintf('The Interview_Session_Details_Data property can only contain items of type \StructType\Interview_Session_Details_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interview_Session_Details_Data[] = $item;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Interview_Session_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
