<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Interview_Room_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for interview room.
 * @subpackage Structs
 */
class Interview_Room_DataType extends AbstractStructBase
{
    /**
     * The Interview_Room_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the interview room.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Interview_Room_Name;
    /**
     * The Interview_Room_Email_Address
     * Meta information extracted from the WSDL
     * - documentation: Email Address of the interview room.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Interview_Room_Email_Address;
    /**
     * Constructor method for Interview_Room_DataType
     * @uses Interview_Room_DataType::setInterview_Room_Name()
     * @uses Interview_Room_DataType::setInterview_Room_Email_Address()
     * @param string $interview_Room_Name
     * @param string $interview_Room_Email_Address
     */
    public function __construct($interview_Room_Name = null, $interview_Room_Email_Address = null)
    {
        $this
            ->setInterview_Room_Name($interview_Room_Name)
            ->setInterview_Room_Email_Address($interview_Room_Email_Address);
    }
    /**
     * Get Interview_Room_Name value
     * @return string|null
     */
    public function getInterview_Room_Name()
    {
        return $this->Interview_Room_Name;
    }
    /**
     * Set Interview_Room_Name value
     * @param string $interview_Room_Name
     * @return \StructType\Interview_Room_DataType
     */
    public function setInterview_Room_Name($interview_Room_Name = null)
    {
        // validation for constraint: string
        if (!is_null($interview_Room_Name) && !is_string($interview_Room_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interview_Room_Name, true), gettype($interview_Room_Name)), __LINE__);
        }
        $this->Interview_Room_Name = $interview_Room_Name;
        return $this;
    }
    /**
     * Get Interview_Room_Email_Address value
     * @return string|null
     */
    public function getInterview_Room_Email_Address()
    {
        return $this->Interview_Room_Email_Address;
    }
    /**
     * Set Interview_Room_Email_Address value
     * @param string $interview_Room_Email_Address
     * @return \StructType\Interview_Room_DataType
     */
    public function setInterview_Room_Email_Address($interview_Room_Email_Address = null)
    {
        // validation for constraint: string
        if (!is_null($interview_Room_Email_Address) && !is_string($interview_Room_Email_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interview_Room_Email_Address, true), gettype($interview_Room_Email_Address)), __LINE__);
        }
        $this->Interview_Room_Email_Address = $interview_Room_Email_Address;
        return $this;
    }
}
