<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Interview_Feedback_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Criteria used to determine which interview to return.
 * @subpackage Structs
 */
class Interview_Feedback_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Job Application associated to the interview.
     * - choice: Job_Application_Reference | Candidate_Interview_Criteria_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Candidate_Interview_Criteria_Data
     * Meta information extracted from the WSDL
     * - choice: Job_Application_Reference | Candidate_Interview_Criteria_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Move_Candidate_CriteriaType
     */
    public $Candidate_Interview_Criteria_Data;
    /**
     * Constructor method for Interview_Feedback_Request_CriteriaType
     * @uses Interview_Feedback_Request_CriteriaType::setJob_Application_Reference()
     * @uses Interview_Feedback_Request_CriteriaType::setCandidate_Interview_Criteria_Data()
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\Move_Candidate_CriteriaType $candidate_Interview_Criteria_Data
     */
    public function __construct(\StructType\Job_ApplicationObjectType $job_Application_Reference = null, \StructType\Move_Candidate_CriteriaType $candidate_Interview_Criteria_Data = null)
    {
        $this
            ->setJob_Application_Reference($job_Application_Reference)
            ->setCandidate_Interview_Criteria_Data($candidate_Interview_Criteria_Data);
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return isset($this->Job_Application_Reference) ? $this->Job_Application_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Application_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Candidate_Interview_Criteria_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Application_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Application_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Application_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Interview_Feedback_Request_CriteriaType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        // validation for constraint: choice(Job_Application_Reference, Candidate_Interview_Criteria_Data)
        if ('' !== ($job_Application_ReferenceChoiceErrorMessage = self::validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($job_Application_Reference))) {
            throw new \InvalidArgumentException($job_Application_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Application_Reference) || (is_array($job_Application_Reference) && empty($job_Application_Reference))) {
            unset($this->Job_Application_Reference);
        } else {
            $this->Job_Application_Reference = $job_Application_Reference;
        }
        return $this;
    }
    /**
     * Get Candidate_Interview_Criteria_Data value
     * @return \StructType\Move_Candidate_CriteriaType|null
     */
    public function getCandidate_Interview_Criteria_Data()
    {
        return isset($this->Candidate_Interview_Criteria_Data) ? $this->Candidate_Interview_Criteria_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCandidate_Interview_Criteria_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Interview_Criteria_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCandidate_Interview_Criteria_DataForChoiceConstraintsFromSetCandidate_Interview_Criteria_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Application_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Candidate_Interview_Criteria_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Candidate_Interview_Criteria_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Candidate_Interview_Criteria_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Move_Candidate_CriteriaType $candidate_Interview_Criteria_Data
     * @return \StructType\Interview_Feedback_Request_CriteriaType
     */
    public function setCandidate_Interview_Criteria_Data(\StructType\Move_Candidate_CriteriaType $candidate_Interview_Criteria_Data = null)
    {
        // validation for constraint: choice(Job_Application_Reference, Candidate_Interview_Criteria_Data)
        if ('' !== ($candidate_Interview_Criteria_DataChoiceErrorMessage = self::validateCandidate_Interview_Criteria_DataForChoiceConstraintsFromSetCandidate_Interview_Criteria_Data($candidate_Interview_Criteria_Data))) {
            throw new \InvalidArgumentException($candidate_Interview_Criteria_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($candidate_Interview_Criteria_Data) || (is_array($candidate_Interview_Criteria_Data) && empty($candidate_Interview_Criteria_Data))) {
            unset($this->Candidate_Interview_Criteria_Data);
        } else {
            $this->Candidate_Interview_Criteria_Data = $candidate_Interview_Criteria_Data;
        }
        return $this;
    }
}
