<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Import_Applicant_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Documentation Import Applicant Request element
 * @subpackage Structs
 */
class Import_Applicant_RequestType extends AbstractStructBase
{
    /**
     * The Applicant
     * Meta information extracted from the WSDL
     * - documentation: The main Wrapper element for the Applicant Data Web Service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Applicant_Information_HVType[]
     */
    public $Applicant;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Import_Applicant_RequestType
     * @uses Import_Applicant_RequestType::setApplicant()
     * @uses Import_Applicant_RequestType::setVersion()
     * @param \StructType\Applicant_Information_HVType[] $applicant
     * @param string $version
     */
    public function __construct(array $applicant = array(), $version = null)
    {
        $this
            ->setApplicant($applicant)
            ->setVersion($version);
    }
    /**
     * Get Applicant value
     * @return \StructType\Applicant_Information_HVType[]|null
     */
    public function getApplicant()
    {
        return $this->Applicant;
    }
    /**
     * This method is responsible for validating the values passed to the setApplicant method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicant method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicantForArrayConstraintsFromSetApplicant(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $import_Applicant_RequestTypeApplicantItem) {
            // validation for constraint: itemType
            if (!$import_Applicant_RequestTypeApplicantItem instanceof \StructType\Applicant_Information_HVType) {
                $invalidValues[] = is_object($import_Applicant_RequestTypeApplicantItem) ? get_class($import_Applicant_RequestTypeApplicantItem) : sprintf('%s(%s)', gettype($import_Applicant_RequestTypeApplicantItem), var_export($import_Applicant_RequestTypeApplicantItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Applicant property can only contain items of type \StructType\Applicant_Information_HVType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Applicant value
     * @throws \InvalidArgumentException
     * @param \StructType\Applicant_Information_HVType[] $applicant
     * @return \StructType\Import_Applicant_RequestType
     */
    public function setApplicant(array $applicant = array())
    {
        // validation for constraint: array
        if ('' !== ($applicantArrayErrorMessage = self::validateApplicantForArrayConstraintsFromSetApplicant($applicant))) {
            throw new \InvalidArgumentException($applicantArrayErrorMessage, __LINE__);
        }
        $this->Applicant = $applicant;
        return $this;
    }
    /**
     * Add item to Applicant value
     * @throws \InvalidArgumentException
     * @param \StructType\Applicant_Information_HVType $item
     * @return \StructType\Import_Applicant_RequestType
     */
    public function addToApplicant(\StructType\Applicant_Information_HVType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Applicant_Information_HVType) {
            throw new \InvalidArgumentException(sprintf('The Applicant property can only contain items of type \StructType\Applicant_Information_HVType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Applicant[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Import_Applicant_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
