<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_Recruiting_Assessment_Categories_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Recruiting Assessment Categories Response Container
 * @subpackage Structs
 */
class Get_Recruiting_Assessment_Categories_ResponseType extends AbstractStructBase
{
    /**
     * The Request_References
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_Category_Request_ReferencesType
     */
    public $Request_References;
    /**
     * The Response_Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Response_FilterType
     */
    public $Response_Filter;
    /**
     * The Response_Group
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_Category_Response_GroupType[]
     */
    public $Response_Group;
    /**
     * The Response_Results
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Response_ResultsType
     */
    public $Response_Results;
    /**
     * The Response_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_Category_Response_DataType
     */
    public $Response_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Get_Recruiting_Assessment_Categories_ResponseType
     * @uses Get_Recruiting_Assessment_Categories_ResponseType::setRequest_References()
     * @uses Get_Recruiting_Assessment_Categories_ResponseType::setResponse_Filter()
     * @uses Get_Recruiting_Assessment_Categories_ResponseType::setResponse_Group()
     * @uses Get_Recruiting_Assessment_Categories_ResponseType::setResponse_Results()
     * @uses Get_Recruiting_Assessment_Categories_ResponseType::setResponse_Data()
     * @uses Get_Recruiting_Assessment_Categories_ResponseType::setVersion()
     * @param \StructType\Recruiting_Assessment_Category_Request_ReferencesType $request_References
     * @param \StructType\Response_FilterType $response_Filter
     * @param \StructType\Recruiting_Assessment_Category_Response_GroupType[] $response_Group
     * @param \StructType\Response_ResultsType $response_Results
     * @param \StructType\Recruiting_Assessment_Category_Response_DataType $response_Data
     * @param string $version
     */
    public function __construct(\StructType\Recruiting_Assessment_Category_Request_ReferencesType $request_References = null, \StructType\Response_FilterType $response_Filter = null, array $response_Group = array(), \StructType\Response_ResultsType $response_Results = null, \StructType\Recruiting_Assessment_Category_Response_DataType $response_Data = null, $version = null)
    {
        $this
            ->setRequest_References($request_References)
            ->setResponse_Filter($response_Filter)
            ->setResponse_Group($response_Group)
            ->setResponse_Results($response_Results)
            ->setResponse_Data($response_Data)
            ->setVersion($version);
    }
    /**
     * Get Request_References value
     * @return \StructType\Recruiting_Assessment_Category_Request_ReferencesType|null
     */
    public function getRequest_References()
    {
        return $this->Request_References;
    }
    /**
     * Set Request_References value
     * @param \StructType\Recruiting_Assessment_Category_Request_ReferencesType $request_References
     * @return \StructType\Get_Recruiting_Assessment_Categories_ResponseType
     */
    public function setRequest_References(\StructType\Recruiting_Assessment_Category_Request_ReferencesType $request_References = null)
    {
        $this->Request_References = $request_References;
        return $this;
    }
    /**
     * Get Response_Filter value
     * @return \StructType\Response_FilterType|null
     */
    public function getResponse_Filter()
    {
        return $this->Response_Filter;
    }
    /**
     * Set Response_Filter value
     * @param \StructType\Response_FilterType $response_Filter
     * @return \StructType\Get_Recruiting_Assessment_Categories_ResponseType
     */
    public function setResponse_Filter(\StructType\Response_FilterType $response_Filter = null)
    {
        $this->Response_Filter = $response_Filter;
        return $this;
    }
    /**
     * Get Response_Group value
     * @return \StructType\Recruiting_Assessment_Category_Response_GroupType[]|null
     */
    public function getResponse_Group()
    {
        return $this->Response_Group;
    }
    /**
     * This method is responsible for validating the values passed to the setResponse_Group method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResponse_Group method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResponse_GroupForArrayConstraintsFromSetResponse_Group(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $get_Recruiting_Assessment_Categories_ResponseTypeResponse_GroupItem) {
            // validation for constraint: itemType
            if (!$get_Recruiting_Assessment_Categories_ResponseTypeResponse_GroupItem instanceof \StructType\Recruiting_Assessment_Category_Response_GroupType) {
                $invalidValues[] = is_object($get_Recruiting_Assessment_Categories_ResponseTypeResponse_GroupItem) ? get_class($get_Recruiting_Assessment_Categories_ResponseTypeResponse_GroupItem) : sprintf('%s(%s)', gettype($get_Recruiting_Assessment_Categories_ResponseTypeResponse_GroupItem), var_export($get_Recruiting_Assessment_Categories_ResponseTypeResponse_GroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Response_Group property can only contain items of type \StructType\Recruiting_Assessment_Category_Response_GroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Response_Group value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Assessment_Category_Response_GroupType[] $response_Group
     * @return \StructType\Get_Recruiting_Assessment_Categories_ResponseType
     */
    public function setResponse_Group(array $response_Group = array())
    {
        // validation for constraint: array
        if ('' !== ($response_GroupArrayErrorMessage = self::validateResponse_GroupForArrayConstraintsFromSetResponse_Group($response_Group))) {
            throw new \InvalidArgumentException($response_GroupArrayErrorMessage, __LINE__);
        }
        $this->Response_Group = $response_Group;
        return $this;
    }
    /**
     * Add item to Response_Group value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Assessment_Category_Response_GroupType $item
     * @return \StructType\Get_Recruiting_Assessment_Categories_ResponseType
     */
    public function addToResponse_Group(\StructType\Recruiting_Assessment_Category_Response_GroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Assessment_Category_Response_GroupType) {
            throw new \InvalidArgumentException(sprintf('The Response_Group property can only contain items of type \StructType\Recruiting_Assessment_Category_Response_GroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Response_Group[] = $item;
        return $this;
    }
    /**
     * Get Response_Results value
     * @return \StructType\Response_ResultsType|null
     */
    public function getResponse_Results()
    {
        return $this->Response_Results;
    }
    /**
     * Set Response_Results value
     * @param \StructType\Response_ResultsType $response_Results
     * @return \StructType\Get_Recruiting_Assessment_Categories_ResponseType
     */
    public function setResponse_Results(\StructType\Response_ResultsType $response_Results = null)
    {
        $this->Response_Results = $response_Results;
        return $this;
    }
    /**
     * Get Response_Data value
     * @return \StructType\Recruiting_Assessment_Category_Response_DataType|null
     */
    public function getResponse_Data()
    {
        return $this->Response_Data;
    }
    /**
     * Set Response_Data value
     * @param \StructType\Recruiting_Assessment_Category_Response_DataType $response_Data
     * @return \StructType\Get_Recruiting_Assessment_Categories_ResponseType
     */
    public function setResponse_Data(\StructType\Recruiting_Assessment_Category_Response_DataType $response_Data = null)
    {
        $this->Response_Data = $response_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Get_Recruiting_Assessment_Categories_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
