<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Generic_Job_Posting_SiteObjectType StructType
 * @subpackage Structs
 */
class Generic_Job_Posting_SiteObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Generic_Job_Posting_SiteObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta information extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for Generic_Job_Posting_SiteObjectType
     * @uses Generic_Job_Posting_SiteObjectType::setID()
     * @uses Generic_Job_Posting_SiteObjectType::setDescriptor()
     * @param \StructType\Generic_Job_Posting_SiteObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Generic_Job_Posting_SiteObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * This method is responsible for validating the values passed to the setID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIDForArrayConstraintsFromSetID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $generic_Job_Posting_SiteObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$generic_Job_Posting_SiteObjectTypeIDItem instanceof \StructType\Generic_Job_Posting_SiteObjectIDType) {
                $invalidValues[] = is_object($generic_Job_Posting_SiteObjectTypeIDItem) ? get_class($generic_Job_Posting_SiteObjectTypeIDItem) : sprintf('%s(%s)', gettype($generic_Job_Posting_SiteObjectTypeIDItem), var_export($generic_Job_Posting_SiteObjectTypeIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ID property can only contain items of type \StructType\Generic_Job_Posting_SiteObjectIDType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Generic_Job_Posting_SiteObjectIDType[] $iD
     * @return \StructType\Generic_Job_Posting_SiteObjectType
     */
    public function setID(array $iD = array())
    {
        // validation for constraint: array
        if ('' !== ($iDArrayErrorMessage = self::validateIDForArrayConstraintsFromSetID($iD))) {
            throw new \InvalidArgumentException($iDArrayErrorMessage, __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Generic_Job_Posting_SiteObjectIDType $item
     * @return \StructType\Generic_Job_Posting_SiteObjectType
     */
    public function addToID(\StructType\Generic_Job_Posting_SiteObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Generic_Job_Posting_SiteObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of type \StructType\Generic_Job_Posting_SiteObjectIDType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\Generic_Job_Posting_SiteObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptor, true), gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
}
