<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Financials_Business_Sub_Process_ParametersType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for the processing options for sub-business processes within a business process. If no options are submitted (or the options are submitted as 'false') then the sub-business process is simply initiated as if it where
 * submitted on-line with approvals, reviews, notifications and to-do's in place. If the Initiator is an Integration System User, any validations you configured on the Initiation step are ignored.
 * @subpackage Structs
 */
class Financials_Business_Sub_Process_ParametersType extends AbstractStructBase
{
    /**
     * The Skip
     * Meta information extracted from the WSDL
     * - documentation: When set to "true" or "1", the business process is automatically skipped (if it is defined as "skippable" within the business process definition).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Skip;
    /**
     * The Business_Process_Comment_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Business_Process_Comment_DataType
     */
    public $Business_Process_Comment_Data;
    /**
     * Constructor method for Financials_Business_Sub_Process_ParametersType
     * @uses Financials_Business_Sub_Process_ParametersType::setSkip()
     * @uses Financials_Business_Sub_Process_ParametersType::setBusiness_Process_Comment_Data()
     * @param bool $skip
     * @param \StructType\Business_Process_Comment_DataType $business_Process_Comment_Data
     */
    public function __construct($skip = null, \StructType\Business_Process_Comment_DataType $business_Process_Comment_Data = null)
    {
        $this
            ->setSkip($skip)
            ->setBusiness_Process_Comment_Data($business_Process_Comment_Data);
    }
    /**
     * Get Skip value
     * @return bool|null
     */
    public function getSkip()
    {
        return $this->Skip;
    }
    /**
     * Set Skip value
     * @param bool $skip
     * @return \StructType\Financials_Business_Sub_Process_ParametersType
     */
    public function setSkip($skip = null)
    {
        // validation for constraint: boolean
        if (!is_null($skip) && !is_bool($skip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skip, true), gettype($skip)), __LINE__);
        }
        $this->Skip = $skip;
        return $this;
    }
    /**
     * Get Business_Process_Comment_Data value
     * @return \StructType\Business_Process_Comment_DataType|null
     */
    public function getBusiness_Process_Comment_Data()
    {
        return $this->Business_Process_Comment_Data;
    }
    /**
     * Set Business_Process_Comment_Data value
     * @param \StructType\Business_Process_Comment_DataType $business_Process_Comment_Data
     * @return \StructType\Financials_Business_Sub_Process_ParametersType
     */
    public function setBusiness_Process_Comment_Data(\StructType\Business_Process_Comment_DataType $business_Process_Comment_Data = null)
    {
        $this->Business_Process_Comment_Data = $business_Process_Comment_Data;
        return $this;
    }
}
