<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Evergreen_Job_Requisition_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the Request Criteria element to filter instance(s) of Evergreen Requisitions by status or supervisory org.
 * @subpackage Structs
 */
class Evergreen_Job_Requisition_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Transaction_Log_Criteria_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Transaction_Log_CriteriaType[]
     */
    public $Transaction_Log_Criteria_Data;
    /**
     * The Job_Requisition_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for the status of the job requisition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_StatusObjectType[]
     */
    public $Job_Requisition_Status_Reference;
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for the organization.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supervisory_OrganizationObjectType[]
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Primary_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference(s) to the location that a worker being hired/contracted using this opening can use. The results for this criteria are combined(union operation) with the results from the Additional Locations Reference criteria
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Primary_Location_Reference;
    /**
     * The Additional_Locations_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Additional Location(s) for the Job Requisition. This also applies to Positions that have Job Requisitions. The results for this criteria are combined(union operation) with the results from the Location Reference criteria
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Additional_Locations_Reference;
    /**
     * The Field_And_Parameter_Criteria_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Field_And_Parameter_Criteria_DataType
     */
    public $Field_And_Parameter_Criteria_Data;
    /**
     * Constructor method for Evergreen_Job_Requisition_Request_CriteriaType
     * @uses Evergreen_Job_Requisition_Request_CriteriaType::setTransaction_Log_Criteria_Data()
     * @uses Evergreen_Job_Requisition_Request_CriteriaType::setJob_Requisition_Status_Reference()
     * @uses Evergreen_Job_Requisition_Request_CriteriaType::setSupervisory_Organization_Reference()
     * @uses Evergreen_Job_Requisition_Request_CriteriaType::setPrimary_Location_Reference()
     * @uses Evergreen_Job_Requisition_Request_CriteriaType::setAdditional_Locations_Reference()
     * @uses Evergreen_Job_Requisition_Request_CriteriaType::setField_And_Parameter_Criteria_Data()
     * @param \StructType\Transaction_Log_CriteriaType[] $transaction_Log_Criteria_Data
     * @param \StructType\Job_Requisition_StatusObjectType[] $job_Requisition_Status_Reference
     * @param \StructType\Supervisory_OrganizationObjectType[] $supervisory_Organization_Reference
     * @param \StructType\LocationObjectType[] $primary_Location_Reference
     * @param \StructType\LocationObjectType[] $additional_Locations_Reference
     * @param \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data
     */
    public function __construct(array $transaction_Log_Criteria_Data = array(), array $job_Requisition_Status_Reference = array(), array $supervisory_Organization_Reference = array(), array $primary_Location_Reference = array(), array $additional_Locations_Reference = array(), \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data = null)
    {
        $this
            ->setTransaction_Log_Criteria_Data($transaction_Log_Criteria_Data)
            ->setJob_Requisition_Status_Reference($job_Requisition_Status_Reference)
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setPrimary_Location_Reference($primary_Location_Reference)
            ->setAdditional_Locations_Reference($additional_Locations_Reference)
            ->setField_And_Parameter_Criteria_Data($field_And_Parameter_Criteria_Data);
    }
    /**
     * Get Transaction_Log_Criteria_Data value
     * @return \StructType\Transaction_Log_CriteriaType[]|null
     */
    public function getTransaction_Log_Criteria_Data()
    {
        return $this->Transaction_Log_Criteria_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTransaction_Log_Criteria_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransaction_Log_Criteria_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransaction_Log_Criteria_DataForArrayConstraintsFromSetTransaction_Log_Criteria_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Request_CriteriaTypeTransaction_Log_Criteria_DataItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Request_CriteriaTypeTransaction_Log_Criteria_DataItem instanceof \StructType\Transaction_Log_CriteriaType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Request_CriteriaTypeTransaction_Log_Criteria_DataItem) ? get_class($evergreen_Job_Requisition_Request_CriteriaTypeTransaction_Log_Criteria_DataItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Request_CriteriaTypeTransaction_Log_Criteria_DataItem), var_export($evergreen_Job_Requisition_Request_CriteriaTypeTransaction_Log_Criteria_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transaction_Log_Criteria_Data property can only contain items of type \StructType\Transaction_Log_CriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transaction_Log_Criteria_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Transaction_Log_CriteriaType[] $transaction_Log_Criteria_Data
     * @return \StructType\Evergreen_Job_Requisition_Request_CriteriaType
     */
    public function setTransaction_Log_Criteria_Data(array $transaction_Log_Criteria_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($transaction_Log_Criteria_DataArrayErrorMessage = self::validateTransaction_Log_Criteria_DataForArrayConstraintsFromSetTransaction_Log_Criteria_Data($transaction_Log_Criteria_Data))) {
            throw new \InvalidArgumentException($transaction_Log_Criteria_DataArrayErrorMessage, __LINE__);
        }
        $this->Transaction_Log_Criteria_Data = $transaction_Log_Criteria_Data;
        return $this;
    }
    /**
     * Add item to Transaction_Log_Criteria_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Transaction_Log_CriteriaType $item
     * @return \StructType\Evergreen_Job_Requisition_Request_CriteriaType
     */
    public function addToTransaction_Log_Criteria_Data(\StructType\Transaction_Log_CriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transaction_Log_CriteriaType) {
            throw new \InvalidArgumentException(sprintf('The Transaction_Log_Criteria_Data property can only contain items of type \StructType\Transaction_Log_CriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transaction_Log_Criteria_Data[] = $item;
        return $this;
    }
    /**
     * Get Job_Requisition_Status_Reference value
     * @return \StructType\Job_Requisition_StatusObjectType[]|null
     */
    public function getJob_Requisition_Status_Reference()
    {
        return $this->Job_Requisition_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_Status_ReferenceForArrayConstraintsFromSetJob_Requisition_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Request_CriteriaTypeJob_Requisition_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Request_CriteriaTypeJob_Requisition_Status_ReferenceItem instanceof \StructType\Job_Requisition_StatusObjectType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Request_CriteriaTypeJob_Requisition_Status_ReferenceItem) ? get_class($evergreen_Job_Requisition_Request_CriteriaTypeJob_Requisition_Status_ReferenceItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Request_CriteriaTypeJob_Requisition_Status_ReferenceItem), var_export($evergreen_Job_Requisition_Request_CriteriaTypeJob_Requisition_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Status_Reference property can only contain items of type \StructType\Job_Requisition_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_StatusObjectType[] $job_Requisition_Status_Reference
     * @return \StructType\Evergreen_Job_Requisition_Request_CriteriaType
     */
    public function setJob_Requisition_Status_Reference(array $job_Requisition_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_Status_ReferenceArrayErrorMessage = self::validateJob_Requisition_Status_ReferenceForArrayConstraintsFromSetJob_Requisition_Status_Reference($job_Requisition_Status_Reference))) {
            throw new \InvalidArgumentException($job_Requisition_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Status_Reference = $job_Requisition_Status_Reference;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_StatusObjectType $item
     * @return \StructType\Evergreen_Job_Requisition_Request_CriteriaType
     */
    public function addToJob_Requisition_Status_Reference(\StructType\Job_Requisition_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Requisition_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Status_Reference property can only contain items of type \StructType\Job_Requisition_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType[]|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupervisory_Organization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupervisory_Organization_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupervisory_Organization_ReferenceForArrayConstraintsFromSetSupervisory_Organization_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Request_CriteriaTypeSupervisory_Organization_ReferenceItem instanceof \StructType\Supervisory_OrganizationObjectType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) ? get_class($evergreen_Job_Requisition_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Request_CriteriaTypeSupervisory_Organization_ReferenceItem), var_export($evergreen_Job_Requisition_Request_CriteriaTypeSupervisory_Organization_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supervisory_Organization_Reference property can only contain items of type \StructType\Supervisory_OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supervisory_OrganizationObjectType[] $supervisory_Organization_Reference
     * @return \StructType\Evergreen_Job_Requisition_Request_CriteriaType
     */
    public function setSupervisory_Organization_Reference(array $supervisory_Organization_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supervisory_Organization_ReferenceArrayErrorMessage = self::validateSupervisory_Organization_ReferenceForArrayConstraintsFromSetSupervisory_Organization_Reference($supervisory_Organization_Reference))) {
            throw new \InvalidArgumentException($supervisory_Organization_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Add item to Supervisory_Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supervisory_OrganizationObjectType $item
     * @return \StructType\Evergreen_Job_Requisition_Request_CriteriaType
     */
    public function addToSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supervisory_OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supervisory_Organization_Reference property can only contain items of type \StructType\Supervisory_OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supervisory_Organization_Reference[] = $item;
        return $this;
    }
    /**
     * Get Primary_Location_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getPrimary_Location_Reference()
    {
        return $this->Primary_Location_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPrimary_Location_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrimary_Location_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrimary_Location_ReferenceForArrayConstraintsFromSetPrimary_Location_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Request_CriteriaTypePrimary_Location_ReferenceItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Request_CriteriaTypePrimary_Location_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Request_CriteriaTypePrimary_Location_ReferenceItem) ? get_class($evergreen_Job_Requisition_Request_CriteriaTypePrimary_Location_ReferenceItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Request_CriteriaTypePrimary_Location_ReferenceItem), var_export($evergreen_Job_Requisition_Request_CriteriaTypePrimary_Location_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Primary_Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Primary_Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $primary_Location_Reference
     * @return \StructType\Evergreen_Job_Requisition_Request_CriteriaType
     */
    public function setPrimary_Location_Reference(array $primary_Location_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($primary_Location_ReferenceArrayErrorMessage = self::validatePrimary_Location_ReferenceForArrayConstraintsFromSetPrimary_Location_Reference($primary_Location_Reference))) {
            throw new \InvalidArgumentException($primary_Location_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Primary_Location_Reference = $primary_Location_Reference;
        return $this;
    }
    /**
     * Add item to Primary_Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Evergreen_Job_Requisition_Request_CriteriaType
     */
    public function addToPrimary_Location_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Primary_Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Primary_Location_Reference[] = $item;
        return $this;
    }
    /**
     * Get Additional_Locations_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getAdditional_Locations_Reference()
    {
        return $this->Additional_Locations_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Locations_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Locations_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Locations_ReferenceForArrayConstraintsFromSetAdditional_Locations_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Request_CriteriaTypeAdditional_Locations_ReferenceItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Request_CriteriaTypeAdditional_Locations_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Request_CriteriaTypeAdditional_Locations_ReferenceItem) ? get_class($evergreen_Job_Requisition_Request_CriteriaTypeAdditional_Locations_ReferenceItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Request_CriteriaTypeAdditional_Locations_ReferenceItem), var_export($evergreen_Job_Requisition_Request_CriteriaTypeAdditional_Locations_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $additional_Locations_Reference
     * @return \StructType\Evergreen_Job_Requisition_Request_CriteriaType
     */
    public function setAdditional_Locations_Reference(array $additional_Locations_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Locations_ReferenceArrayErrorMessage = self::validateAdditional_Locations_ReferenceForArrayConstraintsFromSetAdditional_Locations_Reference($additional_Locations_Reference))) {
            throw new \InvalidArgumentException($additional_Locations_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Additional_Locations_Reference = $additional_Locations_Reference;
        return $this;
    }
    /**
     * Add item to Additional_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Evergreen_Job_Requisition_Request_CriteriaType
     */
    public function addToAdditional_Locations_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Locations_Reference[] = $item;
        return $this;
    }
    /**
     * Get Field_And_Parameter_Criteria_Data value
     * @return \StructType\Field_And_Parameter_Criteria_DataType|null
     */
    public function getField_And_Parameter_Criteria_Data()
    {
        return $this->Field_And_Parameter_Criteria_Data;
    }
    /**
     * Set Field_And_Parameter_Criteria_Data value
     * @param \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data
     * @return \StructType\Evergreen_Job_Requisition_Request_CriteriaType
     */
    public function setField_And_Parameter_Criteria_Data(\StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data = null)
    {
        $this->Field_And_Parameter_Criteria_Data = $field_And_Parameter_Criteria_Data;
        return $this;
    }
}
