<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Education_Profile_for_Job_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the education profile's information for a position.
 * @subpackage Structs
 */
class Education_Profile_for_Job_DataType extends AbstractStructBase
{
    /**
     * The Degree_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the degree completed.
     * @var \StructType\DegreeObjectType
     */
    public $Degree_Reference;
    /**
     * The Field_Of_Study_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the field of study for the degree.
     * - minOccurs: 0
     * @var \StructType\Field_of_StudyObjectType
     */
    public $Field_Of_Study_Reference;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the profile is required for this position.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required;
    /**
     * The Qualification_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The source (job profile or position) reference from which the qualification came from.
     * - minOccurs: 0
     * @var \StructType\Talent_Qualification_EnabledObjectType
     */
    public $Qualification_Source_Reference;
    /**
     * Constructor method for Education_Profile_for_Job_DataType
     * @uses Education_Profile_for_Job_DataType::setDegree_Reference()
     * @uses Education_Profile_for_Job_DataType::setField_Of_Study_Reference()
     * @uses Education_Profile_for_Job_DataType::setRequired()
     * @uses Education_Profile_for_Job_DataType::setQualification_Source_Reference()
     * @param \StructType\DegreeObjectType $degree_Reference
     * @param \StructType\Field_of_StudyObjectType $field_Of_Study_Reference
     * @param bool $required
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     */
    public function __construct(\StructType\DegreeObjectType $degree_Reference = null, \StructType\Field_of_StudyObjectType $field_Of_Study_Reference = null, $required = null, \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this
            ->setDegree_Reference($degree_Reference)
            ->setField_Of_Study_Reference($field_Of_Study_Reference)
            ->setRequired($required)
            ->setQualification_Source_Reference($qualification_Source_Reference);
    }
    /**
     * Get Degree_Reference value
     * @return \StructType\DegreeObjectType|null
     */
    public function getDegree_Reference()
    {
        return $this->Degree_Reference;
    }
    /**
     * Set Degree_Reference value
     * @param \StructType\DegreeObjectType $degree_Reference
     * @return \StructType\Education_Profile_for_Job_DataType
     */
    public function setDegree_Reference(\StructType\DegreeObjectType $degree_Reference = null)
    {
        $this->Degree_Reference = $degree_Reference;
        return $this;
    }
    /**
     * Get Field_Of_Study_Reference value
     * @return \StructType\Field_of_StudyObjectType|null
     */
    public function getField_Of_Study_Reference()
    {
        return $this->Field_Of_Study_Reference;
    }
    /**
     * Set Field_Of_Study_Reference value
     * @param \StructType\Field_of_StudyObjectType $field_Of_Study_Reference
     * @return \StructType\Education_Profile_for_Job_DataType
     */
    public function setField_Of_Study_Reference(\StructType\Field_of_StudyObjectType $field_Of_Study_Reference = null)
    {
        $this->Field_Of_Study_Reference = $field_Of_Study_Reference;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \StructType\Education_Profile_for_Job_DataType
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get Qualification_Source_Reference value
     * @return \StructType\Talent_Qualification_EnabledObjectType|null
     */
    public function getQualification_Source_Reference()
    {
        return $this->Qualification_Source_Reference;
    }
    /**
     * Set Qualification_Source_Reference value
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     * @return \StructType\Education_Profile_for_Job_DataType
     */
    public function setQualification_Source_Reference(\StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this->Qualification_Source_Reference = $qualification_Source_Reference;
        return $this;
    }
}
