<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Edit_Positon_Restriction_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Responds with the event ID of the Position Restrictions Edit Event, the Position Restriction being edited and the workflow state of the event.
 * @subpackage Structs
 */
class Edit_Positon_Restriction_ResponseType extends AbstractStructBase
{
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Position Restrictions Edit Event.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Event_Reference;
    /**
     * The Position_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Position Restriction edited in this event.
     * - minOccurs: 0
     * @var \StructType\Position_GroupObjectType
     */
    public $Position_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Edit_Positon_Restriction_ResponseType
     * @uses Edit_Positon_Restriction_ResponseType::setEvent_Reference()
     * @uses Edit_Positon_Restriction_ResponseType::setPosition_Reference()
     * @uses Edit_Positon_Restriction_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @param \StructType\Position_GroupObjectType $position_Reference
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $event_Reference = null, \StructType\Position_GroupObjectType $position_Reference = null, $version = null)
    {
        $this
            ->setEvent_Reference($event_Reference)
            ->setPosition_Reference($position_Reference)
            ->setVersion($version);
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getEvent_Reference()
    {
        return $this->Event_Reference;
    }
    /**
     * Set Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @return \StructType\Edit_Positon_Restriction_ResponseType
     */
    public function setEvent_Reference(\StructType\Unique_IdentifierObjectType $event_Reference = null)
    {
        $this->Event_Reference = $event_Reference;
        return $this;
    }
    /**
     * Get Position_Reference value
     * @return \StructType\Position_GroupObjectType|null
     */
    public function getPosition_Reference()
    {
        return $this->Position_Reference;
    }
    /**
     * Set Position_Reference value
     * @param \StructType\Position_GroupObjectType $position_Reference
     * @return \StructType\Edit_Positon_Restriction_ResponseType
     */
    public function setPosition_Reference(\StructType\Position_GroupObjectType $position_Reference = null)
    {
        $this->Position_Reference = $position_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Edit_Positon_Restriction_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
