<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Edit_Position_Restrictions_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the editing of a position restriction.
 * @subpackage Structs
 */
class Edit_Position_Restrictions_DataType extends AbstractStructBase
{
    /**
     * The Position_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier for the Position
     * @var \StructType\Position_RestrictionsObjectType
     */
    public $Position_Reference;
    /**
     * The Edit_Position_Restriction_Event_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Edit_Position_Restriction_Event_DataType
     */
    public $Edit_Position_Restriction_Event_Data;
    /**
     * The Edit_Assign_Organization_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType
     */
    public $Edit_Assign_Organization_Sub_Process;
    /**
     * The Request_Default_Compensation_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Request_Compensation_Default_Sub_Business_ProcessType
     */
    public $Request_Default_Compensation_Sub_Process;
    /**
     * The Assign_Pay_Group_Sub_Process
     * Meta information extracted from the WSDL
     * - documentation: Contains the Assign Pay Group for Position Restriction sub business process attributes and data needed to complete that sub process in the Create Position parent business process. This is currently only required to enable commitment
     * accounting for open positions.
     * - minOccurs: 0
     * @var \StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType
     */
    public $Assign_Pay_Group_Sub_Process;
    /**
     * Constructor method for Edit_Position_Restrictions_DataType
     * @uses Edit_Position_Restrictions_DataType::setPosition_Reference()
     * @uses Edit_Position_Restrictions_DataType::setEdit_Position_Restriction_Event_Data()
     * @uses Edit_Position_Restrictions_DataType::setEdit_Assign_Organization_Sub_Process()
     * @uses Edit_Position_Restrictions_DataType::setRequest_Default_Compensation_Sub_Process()
     * @uses Edit_Position_Restrictions_DataType::setAssign_Pay_Group_Sub_Process()
     * @param \StructType\Position_RestrictionsObjectType $position_Reference
     * @param \StructType\Edit_Position_Restriction_Event_DataType $edit_Position_Restriction_Event_Data
     * @param \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType $edit_Assign_Organization_Sub_Process
     * @param \StructType\Request_Compensation_Default_Sub_Business_ProcessType $request_Default_Compensation_Sub_Process
     * @param \StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType $assign_Pay_Group_Sub_Process
     */
    public function __construct(\StructType\Position_RestrictionsObjectType $position_Reference = null, \StructType\Edit_Position_Restriction_Event_DataType $edit_Position_Restriction_Event_Data = null, \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType $edit_Assign_Organization_Sub_Process = null, \StructType\Request_Compensation_Default_Sub_Business_ProcessType $request_Default_Compensation_Sub_Process = null, \StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType $assign_Pay_Group_Sub_Process = null)
    {
        $this
            ->setPosition_Reference($position_Reference)
            ->setEdit_Position_Restriction_Event_Data($edit_Position_Restriction_Event_Data)
            ->setEdit_Assign_Organization_Sub_Process($edit_Assign_Organization_Sub_Process)
            ->setRequest_Default_Compensation_Sub_Process($request_Default_Compensation_Sub_Process)
            ->setAssign_Pay_Group_Sub_Process($assign_Pay_Group_Sub_Process);
    }
    /**
     * Get Position_Reference value
     * @return \StructType\Position_RestrictionsObjectType|null
     */
    public function getPosition_Reference()
    {
        return $this->Position_Reference;
    }
    /**
     * Set Position_Reference value
     * @param \StructType\Position_RestrictionsObjectType $position_Reference
     * @return \StructType\Edit_Position_Restrictions_DataType
     */
    public function setPosition_Reference(\StructType\Position_RestrictionsObjectType $position_Reference = null)
    {
        $this->Position_Reference = $position_Reference;
        return $this;
    }
    /**
     * Get Edit_Position_Restriction_Event_Data value
     * @return \StructType\Edit_Position_Restriction_Event_DataType|null
     */
    public function getEdit_Position_Restriction_Event_Data()
    {
        return $this->Edit_Position_Restriction_Event_Data;
    }
    /**
     * Set Edit_Position_Restriction_Event_Data value
     * @param \StructType\Edit_Position_Restriction_Event_DataType $edit_Position_Restriction_Event_Data
     * @return \StructType\Edit_Position_Restrictions_DataType
     */
    public function setEdit_Position_Restriction_Event_Data(\StructType\Edit_Position_Restriction_Event_DataType $edit_Position_Restriction_Event_Data = null)
    {
        $this->Edit_Position_Restriction_Event_Data = $edit_Position_Restriction_Event_Data;
        return $this;
    }
    /**
     * Get Edit_Assign_Organization_Sub_Process value
     * @return \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType|null
     */
    public function getEdit_Assign_Organization_Sub_Process()
    {
        return $this->Edit_Assign_Organization_Sub_Process;
    }
    /**
     * Set Edit_Assign_Organization_Sub_Process value
     * @param \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType $edit_Assign_Organization_Sub_Process
     * @return \StructType\Edit_Position_Restrictions_DataType
     */
    public function setEdit_Assign_Organization_Sub_Process(\StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType $edit_Assign_Organization_Sub_Process = null)
    {
        $this->Edit_Assign_Organization_Sub_Process = $edit_Assign_Organization_Sub_Process;
        return $this;
    }
    /**
     * Get Request_Default_Compensation_Sub_Process value
     * @return \StructType\Request_Compensation_Default_Sub_Business_ProcessType|null
     */
    public function getRequest_Default_Compensation_Sub_Process()
    {
        return $this->Request_Default_Compensation_Sub_Process;
    }
    /**
     * Set Request_Default_Compensation_Sub_Process value
     * @param \StructType\Request_Compensation_Default_Sub_Business_ProcessType $request_Default_Compensation_Sub_Process
     * @return \StructType\Edit_Position_Restrictions_DataType
     */
    public function setRequest_Default_Compensation_Sub_Process(\StructType\Request_Compensation_Default_Sub_Business_ProcessType $request_Default_Compensation_Sub_Process = null)
    {
        $this->Request_Default_Compensation_Sub_Process = $request_Default_Compensation_Sub_Process;
        return $this;
    }
    /**
     * Get Assign_Pay_Group_Sub_Process value
     * @return \StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType|null
     */
    public function getAssign_Pay_Group_Sub_Process()
    {
        return $this->Assign_Pay_Group_Sub_Process;
    }
    /**
     * Set Assign_Pay_Group_Sub_Process value
     * @param \StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType $assign_Pay_Group_Sub_Process
     * @return \StructType\Edit_Position_Restrictions_DataType
     */
    public function setAssign_Pay_Group_Sub_Process(\StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType $assign_Pay_Group_Sub_Process = null)
    {
        $this->Assign_Pay_Group_Sub_Process = $assign_Pay_Group_Sub_Process;
        return $this;
    }
}
