<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Edit_Position_Restrictions_Additional_Data_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows updating of effective-dated custom objects for position restrictions. When updating custom objects that allow multiple instances, data for existing instances must appear in the request, otherwise it will be removed.
 * @subpackage Structs
 */
class Edit_Position_Restrictions_Additional_Data_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Position_Restrictions_Custom_Object_Data
     * @var \StructType\Position_Restrictions_Custom_Object_DataType
     */
    public $Position_Restrictions_Custom_Object_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Edit_Position_Restrictions_Additional_Data_RequestType
     * @uses Edit_Position_Restrictions_Additional_Data_RequestType::setBusiness_Process_Parameters()
     * @uses Edit_Position_Restrictions_Additional_Data_RequestType::setPosition_Restrictions_Custom_Object_Data()
     * @uses Edit_Position_Restrictions_Additional_Data_RequestType::setVersion()
     * @param \StructType\Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Position_Restrictions_Custom_Object_DataType $position_Restrictions_Custom_Object_Data
     * @param string $version
     */
    public function __construct(\StructType\Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Position_Restrictions_Custom_Object_DataType $position_Restrictions_Custom_Object_Data = null, $version = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setPosition_Restrictions_Custom_Object_Data($position_Restrictions_Custom_Object_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Edit_Position_Restrictions_Additional_Data_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Position_Restrictions_Custom_Object_Data value
     * @return \StructType\Position_Restrictions_Custom_Object_DataType|null
     */
    public function getPosition_Restrictions_Custom_Object_Data()
    {
        return $this->Position_Restrictions_Custom_Object_Data;
    }
    /**
     * Set Position_Restrictions_Custom_Object_Data value
     * @param \StructType\Position_Restrictions_Custom_Object_DataType $position_Restrictions_Custom_Object_Data
     * @return \StructType\Edit_Position_Restrictions_Additional_Data_RequestType
     */
    public function setPosition_Restrictions_Custom_Object_Data(\StructType\Position_Restrictions_Custom_Object_DataType $position_Restrictions_Custom_Object_Data = null)
    {
        $this->Position_Restrictions_Custom_Object_Data = $position_Restrictions_Custom_Object_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Edit_Position_Restrictions_Additional_Data_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
