<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Edit_Job_Requisition_Additional_Data_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Job Requisition effective-dated custom object data.
 * @subpackage Structs
 */
class Edit_Job_Requisition_Additional_Data_ResponseType extends AbstractStructBase
{
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Edit additional data event reference.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Event_Reference;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Edit additional data job requisition reference.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Edit additional data effective date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Effective_Date;
    /**
     * The Additional_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Effective_Dated_Web_Service_Additional_DataType[]
     */
    public $Additional_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Edit_Job_Requisition_Additional_Data_ResponseType
     * @uses Edit_Job_Requisition_Additional_Data_ResponseType::setEvent_Reference()
     * @uses Edit_Job_Requisition_Additional_Data_ResponseType::setJob_Requisition_Reference()
     * @uses Edit_Job_Requisition_Additional_Data_ResponseType::setEffective_Date()
     * @uses Edit_Job_Requisition_Additional_Data_ResponseType::setAdditional_Data()
     * @uses Edit_Job_Requisition_Additional_Data_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @param string $effective_Date
     * @param \StructType\Effective_Dated_Web_Service_Additional_DataType[] $additional_Data
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $event_Reference = null, \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null, $effective_Date = null, array $additional_Data = array(), $version = null)
    {
        $this
            ->setEvent_Reference($event_Reference)
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setEffective_Date($effective_Date)
            ->setAdditional_Data($additional_Data)
            ->setVersion($version);
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getEvent_Reference()
    {
        return $this->Event_Reference;
    }
    /**
     * Set Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @return \StructType\Edit_Job_Requisition_Additional_Data_ResponseType
     */
    public function setEvent_Reference(\StructType\Unique_IdentifierObjectType $event_Reference = null)
    {
        $this->Event_Reference = $event_Reference;
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Edit_Job_Requisition_Additional_Data_ResponseType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Edit_Job_Requisition_Additional_Data_ResponseType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Additional_Data value
     * @return \StructType\Effective_Dated_Web_Service_Additional_DataType[]|null
     */
    public function getAdditional_Data()
    {
        return $this->Additional_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_DataForArrayConstraintsFromSetAdditional_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $edit_Job_Requisition_Additional_Data_ResponseTypeAdditional_DataItem) {
            // validation for constraint: itemType
            if (!$edit_Job_Requisition_Additional_Data_ResponseTypeAdditional_DataItem instanceof \StructType\Effective_Dated_Web_Service_Additional_DataType) {
                $invalidValues[] = is_object($edit_Job_Requisition_Additional_Data_ResponseTypeAdditional_DataItem) ? get_class($edit_Job_Requisition_Additional_Data_ResponseTypeAdditional_DataItem) : sprintf('%s(%s)', gettype($edit_Job_Requisition_Additional_Data_ResponseTypeAdditional_DataItem), var_export($edit_Job_Requisition_Additional_Data_ResponseTypeAdditional_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Data property can only contain items of type \StructType\Effective_Dated_Web_Service_Additional_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Effective_Dated_Web_Service_Additional_DataType[] $additional_Data
     * @return \StructType\Edit_Job_Requisition_Additional_Data_ResponseType
     */
    public function setAdditional_Data(array $additional_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_DataArrayErrorMessage = self::validateAdditional_DataForArrayConstraintsFromSetAdditional_Data($additional_Data))) {
            throw new \InvalidArgumentException($additional_DataArrayErrorMessage, __LINE__);
        }
        $this->Additional_Data = $additional_Data;
        return $this;
    }
    /**
     * Add item to Additional_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Effective_Dated_Web_Service_Additional_DataType $item
     * @return \StructType\Edit_Job_Requisition_Additional_Data_ResponseType
     */
    public function addToAdditional_Data(\StructType\Effective_Dated_Web_Service_Additional_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Effective_Dated_Web_Service_Additional_DataType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Data property can only contain items of type \StructType\Effective_Dated_Web_Service_Additional_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Edit_Job_Requisition_Additional_Data_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
