<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Default_Position_Organization_Assignments_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the default organization assignments for the Position.
 * @subpackage Structs
 */
class Default_Position_Organization_Assignments_DataType extends AbstractStructBase
{
    /**
     * The Company_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unique identifiers for the default company assignments for the Position.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType[]
     */
    public $Company_Assignments_Reference;
    /**
     * The Cost_Center_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unique identifiers for the default cost center assignments for the Position.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType[]
     */
    public $Cost_Center_Assignments_Reference;
    /**
     * The Region_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unique identifiers for the default region assignments for the Position.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegionObjectType[]
     */
    public $Region_Assignments_Reference;
    /**
     * The Custom_Organization_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unique identifiers for the default custom organization assignments for the Position.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType[]
     */
    public $Custom_Organization_Assignments_Reference;
    /**
     * Constructor method for Default_Position_Organization_Assignments_DataType
     * @uses Default_Position_Organization_Assignments_DataType::setCompany_Assignments_Reference()
     * @uses Default_Position_Organization_Assignments_DataType::setCost_Center_Assignments_Reference()
     * @uses Default_Position_Organization_Assignments_DataType::setRegion_Assignments_Reference()
     * @uses Default_Position_Organization_Assignments_DataType::setCustom_Organization_Assignments_Reference()
     * @param \StructType\CompanyObjectType[] $company_Assignments_Reference
     * @param \StructType\Cost_CenterObjectType[] $cost_Center_Assignments_Reference
     * @param \StructType\RegionObjectType[] $region_Assignments_Reference
     * @param \StructType\Custom_OrganizationObjectType[] $custom_Organization_Assignments_Reference
     */
    public function __construct(array $company_Assignments_Reference = array(), array $cost_Center_Assignments_Reference = array(), array $region_Assignments_Reference = array(), array $custom_Organization_Assignments_Reference = array())
    {
        $this
            ->setCompany_Assignments_Reference($company_Assignments_Reference)
            ->setCost_Center_Assignments_Reference($cost_Center_Assignments_Reference)
            ->setRegion_Assignments_Reference($region_Assignments_Reference)
            ->setCustom_Organization_Assignments_Reference($custom_Organization_Assignments_Reference);
    }
    /**
     * Get Company_Assignments_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompany_Assignments_Reference()
    {
        return $this->Company_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_Assignments_ReferenceForArrayConstraintsFromSetCompany_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $default_Position_Organization_Assignments_DataTypeCompany_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$default_Position_Organization_Assignments_DataTypeCompany_Assignments_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($default_Position_Organization_Assignments_DataTypeCompany_Assignments_ReferenceItem) ? get_class($default_Position_Organization_Assignments_DataTypeCompany_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($default_Position_Organization_Assignments_DataTypeCompany_Assignments_ReferenceItem), var_export($default_Position_Organization_Assignments_DataTypeCompany_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Assignments_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $company_Assignments_Reference
     * @return \StructType\Default_Position_Organization_Assignments_DataType
     */
    public function setCompany_Assignments_Reference(array $company_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_Assignments_ReferenceArrayErrorMessage = self::validateCompany_Assignments_ReferenceForArrayConstraintsFromSetCompany_Assignments_Reference($company_Assignments_Reference))) {
            throw new \InvalidArgumentException($company_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Assignments_Reference = $company_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Company_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Default_Position_Organization_Assignments_DataType
     */
    public function addToCompany_Assignments_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Assignments_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Assignments_Reference[] = $item;
        return $this;
    }
    /**
     * Get Cost_Center_Assignments_Reference value
     * @return \StructType\Cost_CenterObjectType[]|null
     */
    public function getCost_Center_Assignments_Reference()
    {
        return $this->Cost_Center_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCost_Center_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCost_Center_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCost_Center_Assignments_ReferenceForArrayConstraintsFromSetCost_Center_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $default_Position_Organization_Assignments_DataTypeCost_Center_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$default_Position_Organization_Assignments_DataTypeCost_Center_Assignments_ReferenceItem instanceof \StructType\Cost_CenterObjectType) {
                $invalidValues[] = is_object($default_Position_Organization_Assignments_DataTypeCost_Center_Assignments_ReferenceItem) ? get_class($default_Position_Organization_Assignments_DataTypeCost_Center_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($default_Position_Organization_Assignments_DataTypeCost_Center_Assignments_ReferenceItem), var_export($default_Position_Organization_Assignments_DataTypeCost_Center_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Cost_Center_Assignments_Reference property can only contain items of type \StructType\Cost_CenterObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Cost_Center_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Cost_CenterObjectType[] $cost_Center_Assignments_Reference
     * @return \StructType\Default_Position_Organization_Assignments_DataType
     */
    public function setCost_Center_Assignments_Reference(array $cost_Center_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($cost_Center_Assignments_ReferenceArrayErrorMessage = self::validateCost_Center_Assignments_ReferenceForArrayConstraintsFromSetCost_Center_Assignments_Reference($cost_Center_Assignments_Reference))) {
            throw new \InvalidArgumentException($cost_Center_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Cost_Center_Assignments_Reference = $cost_Center_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Cost_Center_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Cost_CenterObjectType $item
     * @return \StructType\Default_Position_Organization_Assignments_DataType
     */
    public function addToCost_Center_Assignments_Reference(\StructType\Cost_CenterObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Cost_CenterObjectType) {
            throw new \InvalidArgumentException(sprintf('The Cost_Center_Assignments_Reference property can only contain items of type \StructType\Cost_CenterObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Cost_Center_Assignments_Reference[] = $item;
        return $this;
    }
    /**
     * Get Region_Assignments_Reference value
     * @return \StructType\RegionObjectType[]|null
     */
    public function getRegion_Assignments_Reference()
    {
        return $this->Region_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRegion_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegion_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegion_Assignments_ReferenceForArrayConstraintsFromSetRegion_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $default_Position_Organization_Assignments_DataTypeRegion_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$default_Position_Organization_Assignments_DataTypeRegion_Assignments_ReferenceItem instanceof \StructType\RegionObjectType) {
                $invalidValues[] = is_object($default_Position_Organization_Assignments_DataTypeRegion_Assignments_ReferenceItem) ? get_class($default_Position_Organization_Assignments_DataTypeRegion_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($default_Position_Organization_Assignments_DataTypeRegion_Assignments_ReferenceItem), var_export($default_Position_Organization_Assignments_DataTypeRegion_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Region_Assignments_Reference property can only contain items of type \StructType\RegionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Region_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionObjectType[] $region_Assignments_Reference
     * @return \StructType\Default_Position_Organization_Assignments_DataType
     */
    public function setRegion_Assignments_Reference(array $region_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($region_Assignments_ReferenceArrayErrorMessage = self::validateRegion_Assignments_ReferenceForArrayConstraintsFromSetRegion_Assignments_Reference($region_Assignments_Reference))) {
            throw new \InvalidArgumentException($region_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Region_Assignments_Reference = $region_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Region_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionObjectType $item
     * @return \StructType\Default_Position_Organization_Assignments_DataType
     */
    public function addToRegion_Assignments_Reference(\StructType\RegionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Region_Assignments_Reference property can only contain items of type \StructType\RegionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Region_Assignments_Reference[] = $item;
        return $this;
    }
    /**
     * Get Custom_Organization_Assignments_Reference value
     * @return \StructType\Custom_OrganizationObjectType[]|null
     */
    public function getCustom_Organization_Assignments_Reference()
    {
        return $this->Custom_Organization_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCustom_Organization_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustom_Organization_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustom_Organization_Assignments_ReferenceForArrayConstraintsFromSetCustom_Organization_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $default_Position_Organization_Assignments_DataTypeCustom_Organization_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$default_Position_Organization_Assignments_DataTypeCustom_Organization_Assignments_ReferenceItem instanceof \StructType\Custom_OrganizationObjectType) {
                $invalidValues[] = is_object($default_Position_Organization_Assignments_DataTypeCustom_Organization_Assignments_ReferenceItem) ? get_class($default_Position_Organization_Assignments_DataTypeCustom_Organization_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($default_Position_Organization_Assignments_DataTypeCustom_Organization_Assignments_ReferenceItem), var_export($default_Position_Organization_Assignments_DataTypeCustom_Organization_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Custom_Organization_Assignments_Reference property can only contain items of type \StructType\Custom_OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Custom_Organization_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_OrganizationObjectType[] $custom_Organization_Assignments_Reference
     * @return \StructType\Default_Position_Organization_Assignments_DataType
     */
    public function setCustom_Organization_Assignments_Reference(array $custom_Organization_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($custom_Organization_Assignments_ReferenceArrayErrorMessage = self::validateCustom_Organization_Assignments_ReferenceForArrayConstraintsFromSetCustom_Organization_Assignments_Reference($custom_Organization_Assignments_Reference))) {
            throw new \InvalidArgumentException($custom_Organization_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Custom_Organization_Assignments_Reference = $custom_Organization_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Custom_Organization_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_OrganizationObjectType $item
     * @return \StructType\Default_Position_Organization_Assignments_DataType
     */
    public function addToCustom_Organization_Assignments_Reference(\StructType\Custom_OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Custom_OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Custom_Organization_Assignments_Reference property can only contain items of type \StructType\Custom_OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Custom_Organization_Assignments_Reference[] = $item;
        return $this;
    }
}
