<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Create_Evergreen_Job_Requisition_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the creation of a new evergreen job requisition.
 * @subpackage Structs
 */
class Create_Evergreen_Job_Requisition_DataType extends AbstractStructBase
{
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supervisory Organization this requisition is being created for. The tenant must have job requisitions enabled for job management.
     * - minOccurs: 0
     * @var \StructType\Supervisory_OrganizationObjectType
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Evergreen_Requisition_Data
     * Meta information extracted from the WSDL
     * - documentation: Data for the Create Evergreen Job Requisition event. This element is required and must contain all its required attributes.
     * @var \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public $Evergreen_Requisition_Data;
    /**
     * The Post_Job_Sub_Process
     * Meta information extracted from the WSDL
     * - documentation: Run the Post Job Sub Business Process to post this job requisition to one or more Job Posting Sites. To use, Post Job must be enabled in the Workflow Definition for Create Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Post_Job_Sub_Business_ProcessType
     */
    public $Post_Job_Sub_Process;
    /**
     * The Assign_Organization_Roles_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Assign_Organization_Roles_Sub_Business_ProcessType
     */
    public $Assign_Organization_Roles_Sub_Process;
    /**
     * The Request_Requisition_Compensation_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Request_Requisition_Compensation_Sub_ProcessType
     */
    public $Request_Requisition_Compensation_Sub_Process;
    /**
     * Constructor method for Create_Evergreen_Job_Requisition_DataType
     * @uses Create_Evergreen_Job_Requisition_DataType::setSupervisory_Organization_Reference()
     * @uses Create_Evergreen_Job_Requisition_DataType::setEvergreen_Requisition_Data()
     * @uses Create_Evergreen_Job_Requisition_DataType::setPost_Job_Sub_Process()
     * @uses Create_Evergreen_Job_Requisition_DataType::setAssign_Organization_Roles_Sub_Process()
     * @uses Create_Evergreen_Job_Requisition_DataType::setRequest_Requisition_Compensation_Sub_Process()
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @param \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType $evergreen_Requisition_Data
     * @param \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process
     * @param \StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process
     * @param \StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process
     */
    public function __construct(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null, \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType $evergreen_Requisition_Data = null, \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process = null, \StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process = null, \StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process = null)
    {
        $this
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setEvergreen_Requisition_Data($evergreen_Requisition_Data)
            ->setPost_Job_Sub_Process($post_Job_Sub_Process)
            ->setAssign_Organization_Roles_Sub_Process($assign_Organization_Roles_Sub_Process)
            ->setRequest_Requisition_Compensation_Sub_Process($request_Requisition_Compensation_Sub_Process);
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @return \StructType\Create_Evergreen_Job_Requisition_DataType
     */
    public function setSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Get Evergreen_Requisition_Data value
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType|null
     */
    public function getEvergreen_Requisition_Data()
    {
        return $this->Evergreen_Requisition_Data;
    }
    /**
     * Set Evergreen_Requisition_Data value
     * @param \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType $evergreen_Requisition_Data
     * @return \StructType\Create_Evergreen_Job_Requisition_DataType
     */
    public function setEvergreen_Requisition_Data(\StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType $evergreen_Requisition_Data = null)
    {
        $this->Evergreen_Requisition_Data = $evergreen_Requisition_Data;
        return $this;
    }
    /**
     * Get Post_Job_Sub_Process value
     * @return \StructType\Post_Job_Sub_Business_ProcessType|null
     */
    public function getPost_Job_Sub_Process()
    {
        return $this->Post_Job_Sub_Process;
    }
    /**
     * Set Post_Job_Sub_Process value
     * @param \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process
     * @return \StructType\Create_Evergreen_Job_Requisition_DataType
     */
    public function setPost_Job_Sub_Process(\StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process = null)
    {
        $this->Post_Job_Sub_Process = $post_Job_Sub_Process;
        return $this;
    }
    /**
     * Get Assign_Organization_Roles_Sub_Process value
     * @return \StructType\Assign_Organization_Roles_Sub_Business_ProcessType|null
     */
    public function getAssign_Organization_Roles_Sub_Process()
    {
        return $this->Assign_Organization_Roles_Sub_Process;
    }
    /**
     * Set Assign_Organization_Roles_Sub_Process value
     * @param \StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process
     * @return \StructType\Create_Evergreen_Job_Requisition_DataType
     */
    public function setAssign_Organization_Roles_Sub_Process(\StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process = null)
    {
        $this->Assign_Organization_Roles_Sub_Process = $assign_Organization_Roles_Sub_Process;
        return $this;
    }
    /**
     * Get Request_Requisition_Compensation_Sub_Process value
     * @return \StructType\Request_Requisition_Compensation_Sub_ProcessType|null
     */
    public function getRequest_Requisition_Compensation_Sub_Process()
    {
        return $this->Request_Requisition_Compensation_Sub_Process;
    }
    /**
     * Set Request_Requisition_Compensation_Sub_Process value
     * @param \StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process
     * @return \StructType\Create_Evergreen_Job_Requisition_DataType
     */
    public function setRequest_Requisition_Compensation_Sub_Process(\StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process = null)
    {
        $this->Request_Requisition_Compensation_Sub_Process = $request_Requisition_Compensation_Sub_Process;
        return $this;
    }
}
