<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Costing_Allocation_Interval_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: End Date must be after or on Start Date | Costing Allocation Interval date ranges must not overlap - the date range submitted conflicts with an existing Costing Allocation Interval. | Costing Allocation Interval data may not be
 * submitted when the requested action is Delete. | Costing Allocation Details are required when adding a new Costing Allocation Interval. | Start Date is required when adding a new Costing Allocation Interval. | The Costing Override ID must be unique
 * within the Workday system - the ID submitted corresponds with an existing Costing Override. | The Costing Allocation Interval Update Keys submitted do not correspond with an existing Costing Override. | Update Keys may not be specified when "Replace
 * Existing Costing Allocation Intervals" is enabled - Allocation Intervals can only be added, not updated. | Allocation percentage must total 100%. | Costing Allocation Interval date ranges must not overlap - the date range submitted conflicts with
 * another proposed Costing Allocation Interval. | Specifies an allocation for a given date range
 * @subpackage Structs
 */
class Costing_Allocation_Interval_DataType extends AbstractStructBase
{
    /**
     * The Costing_Interval_Update_Key
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Costing_Interval_Update_KeyType[]
     */
    public $Costing_Interval_Update_Key;
    /**
     * The Costing_Override_ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for the Costing Allocation Interval within Workday. You can optionally submit this for a new instance, but If left blank Workday will automatically generate an appropriate ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Costing_Override_ID;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start date for the allocation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End date for the allocation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Costing_Allocation_Detail_Data
     * Meta information extracted from the WSDL
     * - documentation: Details of the allocation, (e.g., one or many sets of allocation dimensions with a specific distribution percentage). Note that individual allocation details can not be edited because they do not have a discrete key - rather, the
     * entire set of desired allocation details (totaling 100% distribution) must be submitted, which then replaces the existing details.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Costing_Allocation_Detail_Replacement_DataType[]
     */
    public $Costing_Allocation_Detail_Data;
    /**
     * Constructor method for Costing_Allocation_Interval_DataType
     * @uses Costing_Allocation_Interval_DataType::setCosting_Interval_Update_Key()
     * @uses Costing_Allocation_Interval_DataType::setCosting_Override_ID()
     * @uses Costing_Allocation_Interval_DataType::setStart_Date()
     * @uses Costing_Allocation_Interval_DataType::setEnd_Date()
     * @uses Costing_Allocation_Interval_DataType::setCosting_Allocation_Detail_Data()
     * @param \StructType\Costing_Interval_Update_KeyType[] $costing_Interval_Update_Key
     * @param string $costing_Override_ID
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\Costing_Allocation_Detail_Replacement_DataType[] $costing_Allocation_Detail_Data
     */
    public function __construct(array $costing_Interval_Update_Key = array(), $costing_Override_ID = null, $start_Date = null, $end_Date = null, array $costing_Allocation_Detail_Data = array())
    {
        $this
            ->setCosting_Interval_Update_Key($costing_Interval_Update_Key)
            ->setCosting_Override_ID($costing_Override_ID)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setCosting_Allocation_Detail_Data($costing_Allocation_Detail_Data);
    }
    /**
     * Get Costing_Interval_Update_Key value
     * @return \StructType\Costing_Interval_Update_KeyType[]|null
     */
    public function getCosting_Interval_Update_Key()
    {
        return $this->Costing_Interval_Update_Key;
    }
    /**
     * This method is responsible for validating the values passed to the setCosting_Interval_Update_Key method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCosting_Interval_Update_Key method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCosting_Interval_Update_KeyForArrayConstraintsFromSetCosting_Interval_Update_Key(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costing_Allocation_Interval_DataTypeCosting_Interval_Update_KeyItem) {
            // validation for constraint: itemType
            if (!$costing_Allocation_Interval_DataTypeCosting_Interval_Update_KeyItem instanceof \StructType\Costing_Interval_Update_KeyType) {
                $invalidValues[] = is_object($costing_Allocation_Interval_DataTypeCosting_Interval_Update_KeyItem) ? get_class($costing_Allocation_Interval_DataTypeCosting_Interval_Update_KeyItem) : sprintf('%s(%s)', gettype($costing_Allocation_Interval_DataTypeCosting_Interval_Update_KeyItem), var_export($costing_Allocation_Interval_DataTypeCosting_Interval_Update_KeyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Costing_Interval_Update_Key property can only contain items of type \StructType\Costing_Interval_Update_KeyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Costing_Interval_Update_Key value
     * @throws \InvalidArgumentException
     * @param \StructType\Costing_Interval_Update_KeyType[] $costing_Interval_Update_Key
     * @return \StructType\Costing_Allocation_Interval_DataType
     */
    public function setCosting_Interval_Update_Key(array $costing_Interval_Update_Key = array())
    {
        // validation for constraint: array
        if ('' !== ($costing_Interval_Update_KeyArrayErrorMessage = self::validateCosting_Interval_Update_KeyForArrayConstraintsFromSetCosting_Interval_Update_Key($costing_Interval_Update_Key))) {
            throw new \InvalidArgumentException($costing_Interval_Update_KeyArrayErrorMessage, __LINE__);
        }
        $this->Costing_Interval_Update_Key = $costing_Interval_Update_Key;
        return $this;
    }
    /**
     * Add item to Costing_Interval_Update_Key value
     * @throws \InvalidArgumentException
     * @param \StructType\Costing_Interval_Update_KeyType $item
     * @return \StructType\Costing_Allocation_Interval_DataType
     */
    public function addToCosting_Interval_Update_Key(\StructType\Costing_Interval_Update_KeyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Costing_Interval_Update_KeyType) {
            throw new \InvalidArgumentException(sprintf('The Costing_Interval_Update_Key property can only contain items of type \StructType\Costing_Interval_Update_KeyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Costing_Interval_Update_Key[] = $item;
        return $this;
    }
    /**
     * Get Costing_Override_ID value
     * @return string|null
     */
    public function getCosting_Override_ID()
    {
        return $this->Costing_Override_ID;
    }
    /**
     * Set Costing_Override_ID value
     * @param string $costing_Override_ID
     * @return \StructType\Costing_Allocation_Interval_DataType
     */
    public function setCosting_Override_ID($costing_Override_ID = null)
    {
        // validation for constraint: string
        if (!is_null($costing_Override_ID) && !is_string($costing_Override_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costing_Override_ID, true), gettype($costing_Override_ID)), __LINE__);
        }
        $this->Costing_Override_ID = $costing_Override_ID;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Costing_Allocation_Interval_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Costing_Allocation_Interval_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Costing_Allocation_Detail_Data value
     * @return \StructType\Costing_Allocation_Detail_Replacement_DataType[]|null
     */
    public function getCosting_Allocation_Detail_Data()
    {
        return $this->Costing_Allocation_Detail_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCosting_Allocation_Detail_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCosting_Allocation_Detail_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCosting_Allocation_Detail_DataForArrayConstraintsFromSetCosting_Allocation_Detail_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costing_Allocation_Interval_DataTypeCosting_Allocation_Detail_DataItem) {
            // validation for constraint: itemType
            if (!$costing_Allocation_Interval_DataTypeCosting_Allocation_Detail_DataItem instanceof \StructType\Costing_Allocation_Detail_Replacement_DataType) {
                $invalidValues[] = is_object($costing_Allocation_Interval_DataTypeCosting_Allocation_Detail_DataItem) ? get_class($costing_Allocation_Interval_DataTypeCosting_Allocation_Detail_DataItem) : sprintf('%s(%s)', gettype($costing_Allocation_Interval_DataTypeCosting_Allocation_Detail_DataItem), var_export($costing_Allocation_Interval_DataTypeCosting_Allocation_Detail_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Costing_Allocation_Detail_Data property can only contain items of type \StructType\Costing_Allocation_Detail_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Costing_Allocation_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Costing_Allocation_Detail_Replacement_DataType[] $costing_Allocation_Detail_Data
     * @return \StructType\Costing_Allocation_Interval_DataType
     */
    public function setCosting_Allocation_Detail_Data(array $costing_Allocation_Detail_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($costing_Allocation_Detail_DataArrayErrorMessage = self::validateCosting_Allocation_Detail_DataForArrayConstraintsFromSetCosting_Allocation_Detail_Data($costing_Allocation_Detail_Data))) {
            throw new \InvalidArgumentException($costing_Allocation_Detail_DataArrayErrorMessage, __LINE__);
        }
        $this->Costing_Allocation_Detail_Data = $costing_Allocation_Detail_Data;
        return $this;
    }
    /**
     * Add item to Costing_Allocation_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Costing_Allocation_Detail_Replacement_DataType $item
     * @return \StructType\Costing_Allocation_Interval_DataType
     */
    public function addToCosting_Allocation_Detail_Data(\StructType\Costing_Allocation_Detail_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Costing_Allocation_Detail_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Costing_Allocation_Detail_Data property can only contain items of type \StructType\Costing_Allocation_Detail_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Costing_Allocation_Detail_Data[] = $item;
        return $this;
    }
}
