<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Costing_Allocation_Detail_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Salary Over the Cap Allocation data lines should not be loaded unless the original allocation line includes a valid grant of Salary Over the Cap type. | The override worktags entered do not satisfy the set of required allocation
 * dimensions that have been established in the Maintain Worktag Usage task. | Each distribution worktag for an Allocation Detail must belong to a unique costing dimension - the set of worktags assigned for this Allocation Detail includes a costing
 * dimension more than once. | Company override may only be entered if Intercompany Accounting is enabled in the Edit Tenant Setup - Payroll. | Salary Over the Cap Allocation Details may only be entered if Salary Over the Cap is enabled in the Edit
 * Tenant Setup - Payroll and if Grant is a Payroll Costing Allocation worktag. | Salary Over the Cap sub-allocation percentage must total 100%. | Each Costing Allocation Detail within a Costing Allocation Interval must have its own unique ordering |
 * Details of the allocation, (e.g., a set of allocation dimensions and percentages)
 * @subpackage Structs
 */
class Costing_Allocation_Detail_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Orders the allocation detail (e.g., 'a', 'b', 'c', ...). Note that during general ledger costing, any rounding issues resulting from the distributions are reconciled in the last allocation detail.
     * - maxOccurs: 1
     * @var string
     */
    public $Order;
    /**
     * The Default_from_Organization_Assignment
     * Meta information extracted from the WSDL
     * - documentation: You can only assign one default org for each costing override. | Select Yes (Y) to indicate that the corresponding percentage should be allocated using the worker's (or position's) default organizational assignments with no
     * overrides. Workday detects if this Request represents a sub-event embedded within a higher-level business process, and if so searches for a possible Assign Organization sub-event which contains proposed assignments.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Default_from_Organization_Assignment;
    /**
     * The Costing_Override_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Overriding Company for an Allocation Detail, used for Intercompany Accounting
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Costing_Override_Company_Reference;
    /**
     * The Costing_Override_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The costing dimension value(s) to use for the override (e.g., cost center reference, fund reference, etc.).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tenanted_Payroll_WorktagObjectType[]
     */
    public $Costing_Override_Worktag_Reference;
    /**
     * The Distribution_Percent
     * Meta information extracted from the WSDL
     * - documentation: The percentage for the given allocation detail, represented as a decimal value (e.g., .5).
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 9
     * @var float
     */
    public $Distribution_Percent;
    /**
     * The Salary_Over_the_Cap_Costing_Allocation_Detail_Data
     * Meta information extracted from the WSDL
     * - documentation: Details of the Salary over the Cap allocation, (e.g., a set of allocation dimensions and percentages)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType[]
     */
    public $Salary_Over_the_Cap_Costing_Allocation_Detail_Data;
    /**
     * Constructor method for Costing_Allocation_Detail_Replacement_DataType
     * @uses Costing_Allocation_Detail_Replacement_DataType::setOrder()
     * @uses Costing_Allocation_Detail_Replacement_DataType::setDefault_from_Organization_Assignment()
     * @uses Costing_Allocation_Detail_Replacement_DataType::setCosting_Override_Company_Reference()
     * @uses Costing_Allocation_Detail_Replacement_DataType::setCosting_Override_Worktag_Reference()
     * @uses Costing_Allocation_Detail_Replacement_DataType::setDistribution_Percent()
     * @uses Costing_Allocation_Detail_Replacement_DataType::setSalary_Over_the_Cap_Costing_Allocation_Detail_Data()
     * @param string $order
     * @param bool $default_from_Organization_Assignment
     * @param \StructType\CompanyObjectType $costing_Override_Company_Reference
     * @param \StructType\Tenanted_Payroll_WorktagObjectType[] $costing_Override_Worktag_Reference
     * @param float $distribution_Percent
     * @param \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType[] $salary_Over_the_Cap_Costing_Allocation_Detail_Data
     */
    public function __construct($order = null, $default_from_Organization_Assignment = null, \StructType\CompanyObjectType $costing_Override_Company_Reference = null, array $costing_Override_Worktag_Reference = array(), $distribution_Percent = null, array $salary_Over_the_Cap_Costing_Allocation_Detail_Data = array())
    {
        $this
            ->setOrder($order)
            ->setDefault_from_Organization_Assignment($default_from_Organization_Assignment)
            ->setCosting_Override_Company_Reference($costing_Override_Company_Reference)
            ->setCosting_Override_Worktag_Reference($costing_Override_Worktag_Reference)
            ->setDistribution_Percent($distribution_Percent)
            ->setSalary_Over_the_Cap_Costing_Allocation_Detail_Data($salary_Over_the_Cap_Costing_Allocation_Detail_Data);
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Costing_Allocation_Detail_Replacement_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Default_from_Organization_Assignment value
     * @return bool|null
     */
    public function getDefault_from_Organization_Assignment()
    {
        return $this->Default_from_Organization_Assignment;
    }
    /**
     * Set Default_from_Organization_Assignment value
     * @param bool $default_from_Organization_Assignment
     * @return \StructType\Costing_Allocation_Detail_Replacement_DataType
     */
    public function setDefault_from_Organization_Assignment($default_from_Organization_Assignment = null)
    {
        // validation for constraint: boolean
        if (!is_null($default_from_Organization_Assignment) && !is_bool($default_from_Organization_Assignment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default_from_Organization_Assignment, true), gettype($default_from_Organization_Assignment)), __LINE__);
        }
        $this->Default_from_Organization_Assignment = $default_from_Organization_Assignment;
        return $this;
    }
    /**
     * Get Costing_Override_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCosting_Override_Company_Reference()
    {
        return $this->Costing_Override_Company_Reference;
    }
    /**
     * Set Costing_Override_Company_Reference value
     * @param \StructType\CompanyObjectType $costing_Override_Company_Reference
     * @return \StructType\Costing_Allocation_Detail_Replacement_DataType
     */
    public function setCosting_Override_Company_Reference(\StructType\CompanyObjectType $costing_Override_Company_Reference = null)
    {
        $this->Costing_Override_Company_Reference = $costing_Override_Company_Reference;
        return $this;
    }
    /**
     * Get Costing_Override_Worktag_Reference value
     * @return \StructType\Tenanted_Payroll_WorktagObjectType[]|null
     */
    public function getCosting_Override_Worktag_Reference()
    {
        return $this->Costing_Override_Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCosting_Override_Worktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCosting_Override_Worktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCosting_Override_Worktag_ReferenceForArrayConstraintsFromSetCosting_Override_Worktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costing_Allocation_Detail_Replacement_DataTypeCosting_Override_Worktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$costing_Allocation_Detail_Replacement_DataTypeCosting_Override_Worktag_ReferenceItem instanceof \StructType\Tenanted_Payroll_WorktagObjectType) {
                $invalidValues[] = is_object($costing_Allocation_Detail_Replacement_DataTypeCosting_Override_Worktag_ReferenceItem) ? get_class($costing_Allocation_Detail_Replacement_DataTypeCosting_Override_Worktag_ReferenceItem) : sprintf('%s(%s)', gettype($costing_Allocation_Detail_Replacement_DataTypeCosting_Override_Worktag_ReferenceItem), var_export($costing_Allocation_Detail_Replacement_DataTypeCosting_Override_Worktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Costing_Override_Worktag_Reference property can only contain items of type \StructType\Tenanted_Payroll_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Costing_Override_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tenanted_Payroll_WorktagObjectType[] $costing_Override_Worktag_Reference
     * @return \StructType\Costing_Allocation_Detail_Replacement_DataType
     */
    public function setCosting_Override_Worktag_Reference(array $costing_Override_Worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($costing_Override_Worktag_ReferenceArrayErrorMessage = self::validateCosting_Override_Worktag_ReferenceForArrayConstraintsFromSetCosting_Override_Worktag_Reference($costing_Override_Worktag_Reference))) {
            throw new \InvalidArgumentException($costing_Override_Worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Costing_Override_Worktag_Reference = $costing_Override_Worktag_Reference;
        return $this;
    }
    /**
     * Add item to Costing_Override_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tenanted_Payroll_WorktagObjectType $item
     * @return \StructType\Costing_Allocation_Detail_Replacement_DataType
     */
    public function addToCosting_Override_Worktag_Reference(\StructType\Tenanted_Payroll_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tenanted_Payroll_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Costing_Override_Worktag_Reference property can only contain items of type \StructType\Tenanted_Payroll_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Costing_Override_Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Distribution_Percent value
     * @return float|null
     */
    public function getDistribution_Percent()
    {
        return $this->Distribution_Percent;
    }
    /**
     * Set Distribution_Percent value
     * @param float $distribution_Percent
     * @return \StructType\Costing_Allocation_Detail_Replacement_DataType
     */
    public function setDistribution_Percent($distribution_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($distribution_Percent) && !(is_float($distribution_Percent) || is_numeric($distribution_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distribution_Percent, true), gettype($distribution_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($distribution_Percent) && mb_strlen(mb_substr($distribution_Percent, false !== mb_strpos($distribution_Percent, '.') ? mb_strpos($distribution_Percent, '.') + 1 : mb_strlen($distribution_Percent))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($distribution_Percent, true), mb_strlen(mb_substr($distribution_Percent, mb_strpos($distribution_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($distribution_Percent) && $distribution_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($distribution_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(9)
        if (!is_null($distribution_Percent) && mb_strlen(preg_replace('/(\D)/', '', $distribution_Percent)) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 9 digits, "%d" given', var_export($distribution_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $distribution_Percent))), __LINE__);
        }
        $this->Distribution_Percent = $distribution_Percent;
        return $this;
    }
    /**
     * Get Salary_Over_the_Cap_Costing_Allocation_Detail_Data value
     * @return \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType[]|null
     */
    public function getSalary_Over_the_Cap_Costing_Allocation_Detail_Data()
    {
        return $this->Salary_Over_the_Cap_Costing_Allocation_Detail_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSalary_Over_the_Cap_Costing_Allocation_Detail_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalary_Over_the_Cap_Costing_Allocation_Detail_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalary_Over_the_Cap_Costing_Allocation_Detail_DataForArrayConstraintsFromSetSalary_Over_the_Cap_Costing_Allocation_Detail_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costing_Allocation_Detail_Replacement_DataTypeSalary_Over_the_Cap_Costing_Allocation_Detail_DataItem) {
            // validation for constraint: itemType
            if (!$costing_Allocation_Detail_Replacement_DataTypeSalary_Over_the_Cap_Costing_Allocation_Detail_DataItem instanceof \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType) {
                $invalidValues[] = is_object($costing_Allocation_Detail_Replacement_DataTypeSalary_Over_the_Cap_Costing_Allocation_Detail_DataItem) ? get_class($costing_Allocation_Detail_Replacement_DataTypeSalary_Over_the_Cap_Costing_Allocation_Detail_DataItem) : sprintf('%s(%s)', gettype($costing_Allocation_Detail_Replacement_DataTypeSalary_Over_the_Cap_Costing_Allocation_Detail_DataItem), var_export($costing_Allocation_Detail_Replacement_DataTypeSalary_Over_the_Cap_Costing_Allocation_Detail_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Salary_Over_the_Cap_Costing_Allocation_Detail_Data property can only contain items of type \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Salary_Over_the_Cap_Costing_Allocation_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType[] $salary_Over_the_Cap_Costing_Allocation_Detail_Data
     * @return \StructType\Costing_Allocation_Detail_Replacement_DataType
     */
    public function setSalary_Over_the_Cap_Costing_Allocation_Detail_Data(array $salary_Over_the_Cap_Costing_Allocation_Detail_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($salary_Over_the_Cap_Costing_Allocation_Detail_DataArrayErrorMessage = self::validateSalary_Over_the_Cap_Costing_Allocation_Detail_DataForArrayConstraintsFromSetSalary_Over_the_Cap_Costing_Allocation_Detail_Data($salary_Over_the_Cap_Costing_Allocation_Detail_Data))) {
            throw new \InvalidArgumentException($salary_Over_the_Cap_Costing_Allocation_Detail_DataArrayErrorMessage, __LINE__);
        }
        $this->Salary_Over_the_Cap_Costing_Allocation_Detail_Data = $salary_Over_the_Cap_Costing_Allocation_Detail_Data;
        return $this;
    }
    /**
     * Add item to Salary_Over_the_Cap_Costing_Allocation_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType $item
     * @return \StructType\Costing_Allocation_Detail_Replacement_DataType
     */
    public function addToSalary_Over_the_Cap_Costing_Allocation_Detail_Data(\StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType) {
            throw new \InvalidArgumentException(sprintf('The Salary_Over_the_Cap_Costing_Allocation_Detail_Data property can only contain items of type \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Salary_Over_the_Cap_Costing_Allocation_Detail_Data[] = $item;
        return $this;
    }
}
