<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Close_Job_Requisition_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the closing of a job requisition.
 * @subpackage Structs
 */
class Close_Job_Requisition_DataType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the job requisition to be closed.
     * @var \StructType\Job_RequisitionObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Close_Job_Requisition_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the reason the job requisition is being closed.
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Close_Job_Requisition_Reason_Reference;
    /**
     * The Job_Requisition_Close_Date
     * Meta information extracted from the WSDL
     * - documentation: The Job Requisition Close Date is the date the requisition will be closed.
     * - maxOccurs: 1
     * @var string
     */
    public $Job_Requisition_Close_Date;
    /**
     * The Close_Unfilled_Positions
     * Meta information extracted from the WSDL
     * - documentation: If Close Unfilled Positions is set to 1 then unfilled positions related to the Job Requisition will be closed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Close_Unfilled_Positions;
    /**
     * The Position_Restriction_Reference
     * Meta information extracted from the WSDL
     * - documentation: If Position Restrictions are mentioned, then those would be considered for Close. If nothing is set, then all the Position Restrictions related to the Job Requisition would be considered for Close
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Position_RestrictionsObjectType[]
     */
    public $Position_Restriction_Reference;
    /**
     * The Unpost_Job_Sub_Business_Process
     * Meta information extracted from the WSDL
     * - documentation: Run the Update Job Posting sub business process to unpost the job postings associated with this Job Requisition. To use, Unpost Job must be enabled on the Workflow Definition for Close Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Unpost_Job_Sub_Business_ProcessType
     */
    public $Unpost_Job_Sub_Business_Process;
    /**
     * Constructor method for Close_Job_Requisition_DataType
     * @uses Close_Job_Requisition_DataType::setJob_Requisition_Reference()
     * @uses Close_Job_Requisition_DataType::setClose_Job_Requisition_Reason_Reference()
     * @uses Close_Job_Requisition_DataType::setJob_Requisition_Close_Date()
     * @uses Close_Job_Requisition_DataType::setClose_Unfilled_Positions()
     * @uses Close_Job_Requisition_DataType::setPosition_Restriction_Reference()
     * @uses Close_Job_Requisition_DataType::setUnpost_Job_Sub_Business_Process()
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @param \StructType\Event_Classification_SubcategoryObjectType $close_Job_Requisition_Reason_Reference
     * @param string $job_Requisition_Close_Date
     * @param bool $close_Unfilled_Positions
     * @param \StructType\Position_RestrictionsObjectType[] $position_Restriction_Reference
     * @param \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process
     */
    public function __construct(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null, \StructType\Event_Classification_SubcategoryObjectType $close_Job_Requisition_Reason_Reference = null, $job_Requisition_Close_Date = null, $close_Unfilled_Positions = null, array $position_Restriction_Reference = array(), \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process = null)
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setClose_Job_Requisition_Reason_Reference($close_Job_Requisition_Reason_Reference)
            ->setJob_Requisition_Close_Date($job_Requisition_Close_Date)
            ->setClose_Unfilled_Positions($close_Unfilled_Positions)
            ->setPosition_Restriction_Reference($position_Restriction_Reference)
            ->setUnpost_Job_Sub_Business_Process($unpost_Job_Sub_Business_Process);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_RequisitionObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @return \StructType\Close_Job_Requisition_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Close_Job_Requisition_Reason_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getClose_Job_Requisition_Reason_Reference()
    {
        return $this->Close_Job_Requisition_Reason_Reference;
    }
    /**
     * Set Close_Job_Requisition_Reason_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $close_Job_Requisition_Reason_Reference
     * @return \StructType\Close_Job_Requisition_DataType
     */
    public function setClose_Job_Requisition_Reason_Reference(\StructType\Event_Classification_SubcategoryObjectType $close_Job_Requisition_Reason_Reference = null)
    {
        $this->Close_Job_Requisition_Reason_Reference = $close_Job_Requisition_Reason_Reference;
        return $this;
    }
    /**
     * Get Job_Requisition_Close_Date value
     * @return string|null
     */
    public function getJob_Requisition_Close_Date()
    {
        return $this->Job_Requisition_Close_Date;
    }
    /**
     * Set Job_Requisition_Close_Date value
     * @param string $job_Requisition_Close_Date
     * @return \StructType\Close_Job_Requisition_DataType
     */
    public function setJob_Requisition_Close_Date($job_Requisition_Close_Date = null)
    {
        // validation for constraint: string
        if (!is_null($job_Requisition_Close_Date) && !is_string($job_Requisition_Close_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Requisition_Close_Date, true), gettype($job_Requisition_Close_Date)), __LINE__);
        }
        $this->Job_Requisition_Close_Date = $job_Requisition_Close_Date;
        return $this;
    }
    /**
     * Get Close_Unfilled_Positions value
     * @return bool|null
     */
    public function getClose_Unfilled_Positions()
    {
        return $this->Close_Unfilled_Positions;
    }
    /**
     * Set Close_Unfilled_Positions value
     * @param bool $close_Unfilled_Positions
     * @return \StructType\Close_Job_Requisition_DataType
     */
    public function setClose_Unfilled_Positions($close_Unfilled_Positions = null)
    {
        // validation for constraint: boolean
        if (!is_null($close_Unfilled_Positions) && !is_bool($close_Unfilled_Positions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($close_Unfilled_Positions, true), gettype($close_Unfilled_Positions)), __LINE__);
        }
        $this->Close_Unfilled_Positions = $close_Unfilled_Positions;
        return $this;
    }
    /**
     * Get Position_Restriction_Reference value
     * @return \StructType\Position_RestrictionsObjectType[]|null
     */
    public function getPosition_Restriction_Reference()
    {
        return $this->Position_Restriction_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition_Restriction_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition_Restriction_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePosition_Restriction_ReferenceForArrayConstraintsFromSetPosition_Restriction_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $close_Job_Requisition_DataTypePosition_Restriction_ReferenceItem) {
            // validation for constraint: itemType
            if (!$close_Job_Requisition_DataTypePosition_Restriction_ReferenceItem instanceof \StructType\Position_RestrictionsObjectType) {
                $invalidValues[] = is_object($close_Job_Requisition_DataTypePosition_Restriction_ReferenceItem) ? get_class($close_Job_Requisition_DataTypePosition_Restriction_ReferenceItem) : sprintf('%s(%s)', gettype($close_Job_Requisition_DataTypePosition_Restriction_ReferenceItem), var_export($close_Job_Requisition_DataTypePosition_Restriction_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Position_Restriction_Reference property can only contain items of type \StructType\Position_RestrictionsObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Position_Restriction_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_RestrictionsObjectType[] $position_Restriction_Reference
     * @return \StructType\Close_Job_Requisition_DataType
     */
    public function setPosition_Restriction_Reference(array $position_Restriction_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($position_Restriction_ReferenceArrayErrorMessage = self::validatePosition_Restriction_ReferenceForArrayConstraintsFromSetPosition_Restriction_Reference($position_Restriction_Reference))) {
            throw new \InvalidArgumentException($position_Restriction_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Position_Restriction_Reference = $position_Restriction_Reference;
        return $this;
    }
    /**
     * Add item to Position_Restriction_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_RestrictionsObjectType $item
     * @return \StructType\Close_Job_Requisition_DataType
     */
    public function addToPosition_Restriction_Reference(\StructType\Position_RestrictionsObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position_RestrictionsObjectType) {
            throw new \InvalidArgumentException(sprintf('The Position_Restriction_Reference property can only contain items of type \StructType\Position_RestrictionsObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Position_Restriction_Reference[] = $item;
        return $this;
    }
    /**
     * Get Unpost_Job_Sub_Business_Process value
     * @return \StructType\Unpost_Job_Sub_Business_ProcessType|null
     */
    public function getUnpost_Job_Sub_Business_Process()
    {
        return $this->Unpost_Job_Sub_Business_Process;
    }
    /**
     * Set Unpost_Job_Sub_Business_Process value
     * @param \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process
     * @return \StructType\Close_Job_Requisition_DataType
     */
    public function setUnpost_Job_Sub_Business_Process(\StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process = null)
    {
        $this->Unpost_Job_Sub_Business_Process = $unpost_Job_Sub_Business_Process;
        return $this;
    }
}
